/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityAIMoveToBlock
extends EntityAIBase {
    private final EntityCreature theEntity;
    private final double movementSpeed;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.ORIGIN;
    private boolean isAboveDestination;
    private final int searchLength;

    public EntityAIMoveToBlock(EntityCreature p_i45888_1_, double p_i45888_2_, int p_i45888_4_) {
        this.theEntity = p_i45888_1_;
        this.movementSpeed = p_i45888_2_;
        this.searchLength = p_i45888_4_;
        this.setMutexBits(5);
    }

    @Override
    public boolean shouldExecute() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.theEntity.getRNG().nextInt(200);
        return this.searchForDestination();
    }

    @Override
    public boolean continueExecuting() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.theEntity.world, this.destinationBlock);
    }

    @Override
    public void startExecuting() {
        this.theEntity.getNavigator().tryMoveToXYZ((double)this.destinationBlock.getX() + 0.5, this.destinationBlock.getY() + 1, (double)this.destinationBlock.getZ() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.theEntity.getRNG().nextInt(this.theEntity.getRNG().nextInt(1200) + 1200) + 1200;
    }

    @Override
    public void updateTask() {
        if (this.theEntity.getDistanceSqToCenter(this.destinationBlock.up()) > 1.0) {
            this.isAboveDestination = false;
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.theEntity.getNavigator().tryMoveToXYZ((double)this.destinationBlock.getX() + 0.5, this.destinationBlock.getY() + 1, (double)this.destinationBlock.getZ() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAboveDestination = true;
            --this.timeoutCounter;
        }
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestination;
    }

    private boolean searchForDestination() {
        int lvt_1_1_ = this.searchLength;
        boolean lvt_2_1_ = true;
        BlockPos lvt_3_1_ = new BlockPos(this.theEntity);
        int lvt_4_1_ = 0;
        while (lvt_4_1_ <= 1) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_1_1_; ++lvt_5_1_) {
                int lvt_6_1_ = 0;
                while (lvt_6_1_ <= lvt_5_1_) {
                    int lvt_7_1_;
                    int n = lvt_7_1_ = lvt_6_1_ < lvt_5_1_ && lvt_6_1_ > -lvt_5_1_ ? lvt_5_1_ : 0;
                    while (lvt_7_1_ <= lvt_5_1_) {
                        BlockPos lvt_8_1_ = lvt_3_1_.add(lvt_6_1_, lvt_4_1_ - 1, lvt_7_1_);
                        if (this.theEntity.isWithinHomeDistanceFromPosition(lvt_8_1_) && this.shouldMoveTo(this.theEntity.world, lvt_8_1_)) {
                            this.destinationBlock = lvt_8_1_;
                            return true;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                    lvt_6_1_ = lvt_6_1_ > 0 ? -lvt_6_1_ : 1 - lvt_6_1_;
                }
            }
            lvt_4_1_ = lvt_4_1_ > 0 ? -lvt_4_1_ : 1 - lvt_4_1_;
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(World var1, BlockPos var2);
}

