/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAINearestAttackableTarget<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super T> targetEntitySelector;
    protected T targetEntity;

    public EntityAINearestAttackableTarget(EntityCreature p_i45878_1_, Class<T> p_i45878_2_, boolean p_i45878_3_) {
        this(p_i45878_1_, p_i45878_2_, p_i45878_3_, false);
    }

    public EntityAINearestAttackableTarget(EntityCreature p_i45879_1_, Class<T> p_i45879_2_, boolean p_i45879_3_, boolean p_i45879_4_) {
        this(p_i45879_1_, p_i45879_2_, 10, p_i45879_3_, p_i45879_4_, null);
    }

    public EntityAINearestAttackableTarget(EntityCreature p_i45880_1_, Class<T> p_i45880_2_, int p_i45880_3_, boolean p_i45880_4_, boolean p_i45880_5_, final Predicate<? super T> p_i45880_6_) {
        super(p_i45880_1_, p_i45880_4_, p_i45880_5_);
        this.targetClass = p_i45880_2_;
        this.targetChance = p_i45880_3_;
        this.theNearestAttackableTargetSorter = new Sorter(p_i45880_1_);
        this.setMutexBits(1);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(T p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                if (p_i45880_6_ != null && !p_i45880_6_.apply(p_apply_1_)) {
                    return false;
                }
                if (!EntitySelectors.NOT_SPECTATING.apply(p_apply_1_)) {
                    return false;
                }
                return EntityAINearestAttackableTarget.this.isSuitableTarget((EntityLivingBase)p_apply_1_, false);
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((T)((EntityLivingBase)p_apply_1_));
            }
        };
    }

    @Override
    public boolean shouldExecute() {
        if (this.targetChance > 0 && this.taskOwner.getRNG().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass == EntityPlayer.class || this.targetClass == EntityPlayerMP.class) {
            this.targetEntity = this.taskOwner.world.getNearestAttackablePlayer(this.taskOwner.posX, this.taskOwner.posY + (double)this.taskOwner.getEyeHeight(), this.taskOwner.posZ, this.getTargetDistance(), this.getTargetDistance(), new Function<EntityPlayer, Double>(){

                @Nullable
                public Double apply(EntityPlayer p_apply_1_) {
                    ItemStack lvt_2_1_ = p_apply_1_.getItemStackFromSlot(EntityEquipmentSlot.HEAD);
                    if (lvt_2_1_.getItem() == Items.SKULL) {
                        boolean lvt_6_1_;
                        int lvt_3_1_ = lvt_2_1_.getItemDamage();
                        boolean lvt_4_1_ = EntityAINearestAttackableTarget.this.taskOwner instanceof EntitySkeleton && lvt_3_1_ == 0;
                        boolean lvt_5_1_ = EntityAINearestAttackableTarget.this.taskOwner instanceof EntityZombie && lvt_3_1_ == 2;
                        boolean bl = lvt_6_1_ = EntityAINearestAttackableTarget.this.taskOwner instanceof EntityCreeper && lvt_3_1_ == 4;
                        if (lvt_4_1_ || lvt_5_1_ || lvt_6_1_) {
                            return 0.5;
                        }
                    }
                    return 1.0;
                }

                @Nullable
                public /* synthetic */ Object apply(Object p_apply_1_) {
                    return this.apply((EntityPlayer)p_apply_1_);
                }
            }, this.targetEntitySelector);
            return this.targetEntity != null;
        }
        List<T> lvt_1_1_ = this.taskOwner.world.getEntitiesWithinAABB(this.targetClass, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector);
        if (lvt_1_1_.isEmpty()) {
            return false;
        }
        Collections.sort(lvt_1_1_, this.theNearestAttackableTargetSorter);
        this.targetEntity = (EntityLivingBase)lvt_1_1_.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double p_getTargetableArea_1_) {
        return this.taskOwner.getEntityBoundingBox().expand(p_getTargetableArea_1_, 4.0, p_getTargetableArea_1_);
    }

    @Override
    public void startExecuting() {
        this.taskOwner.setAttackTarget((EntityLivingBase)this.targetEntity);
        super.startExecuting();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity p_i1662_1_) {
            this.theEntity = p_i1662_1_;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double lvt_5_1_;
            double lvt_3_1_ = this.theEntity.getDistanceSqToEntity(p_compare_1_);
            if (lvt_3_1_ < (lvt_5_1_ = this.theEntity.getDistanceSqToEntity(p_compare_2_))) {
                return -1;
            }
            if (lvt_3_1_ > lvt_5_1_) {
                return 1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
            return this.compare((Entity)p_compare_1_, (Entity)p_compare_2_);
        }
    }
}

