/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.World;

public class EntityAIOcelotAttack
extends EntityAIBase {
    World world;
    EntityLiving theEntity;
    EntityLivingBase theVictim;
    int attackCountdown;

    public EntityAIOcelotAttack(EntityLiving p_i1641_1_) {
        this.theEntity = p_i1641_1_;
        this.world = p_i1641_1_.world;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        EntityLivingBase lvt_1_1_ = this.theEntity.getAttackTarget();
        if (lvt_1_1_ == null) {
            return false;
        }
        this.theVictim = lvt_1_1_;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        if (!this.theVictim.isEntityAlive()) {
            return false;
        }
        if (this.theEntity.getDistanceSqToEntity(this.theVictim) > 225.0) {
            return false;
        }
        return !this.theEntity.getNavigator().noPath() || this.shouldExecute();
    }

    @Override
    public void resetTask() {
        this.theVictim = null;
        this.theEntity.getNavigator().clearPathEntity();
    }

    @Override
    public void updateTask() {
        this.theEntity.getLookHelper().setLookPositionWithEntity(this.theVictim, 30.0f, 30.0f);
        double lvt_1_1_ = this.theEntity.width * 2.0f * (this.theEntity.width * 2.0f);
        double lvt_3_1_ = this.theEntity.getDistanceSq(this.theVictim.posX, this.theVictim.getEntityBoundingBox().minY, this.theVictim.posZ);
        double lvt_5_1_ = 0.8;
        if (lvt_3_1_ > lvt_1_1_ && lvt_3_1_ < 16.0) {
            lvt_5_1_ = 1.33;
        } else if (lvt_3_1_ < 225.0) {
            lvt_5_1_ = 0.6;
        }
        this.theEntity.getNavigator().tryMoveToEntityLiving(this.theVictim, lvt_5_1_);
        this.attackCountdown = Math.max(this.attackCountdown - 1, 0);
        if (lvt_3_1_ > lvt_1_1_) {
            return;
        }
        if (this.attackCountdown > 0) {
            return;
        }
        this.attackCountdown = 20;
        this.theEntity.attackEntityAsMob(this.theVictim);
    }
}

