/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIOcelotSit
extends EntityAIMoveToBlock {
    private final EntityOcelot ocelot;

    public EntityAIOcelotSit(EntityOcelot p_i45315_1_, double p_i45315_2_) {
        super(p_i45315_1_, p_i45315_2_, 8);
        this.ocelot = p_i45315_1_;
    }

    @Override
    public boolean shouldExecute() {
        return this.ocelot.isTamed() && !this.ocelot.isSitting() && super.shouldExecute();
    }

    @Override
    public void startExecuting() {
        super.startExecuting();
        this.ocelot.getAISit().setSitting(false);
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.ocelot.setSitting(false);
    }

    @Override
    public void updateTask() {
        super.updateTask();
        this.ocelot.getAISit().setSitting(false);
        if (!this.getIsAboveDestination()) {
            this.ocelot.setSitting(false);
        } else if (!this.ocelot.isSitting()) {
            this.ocelot.setSitting(true);
        }
    }

    @Override
    protected boolean shouldMoveTo(World p_shouldMoveTo_1_, BlockPos p_shouldMoveTo_2_) {
        if (!p_shouldMoveTo_1_.isAirBlock(p_shouldMoveTo_2_.up())) {
            return false;
        }
        IBlockState lvt_3_1_ = p_shouldMoveTo_1_.getBlockState(p_shouldMoveTo_2_);
        Block lvt_4_1_ = lvt_3_1_.getBlock();
        if (lvt_4_1_ == Blocks.CHEST) {
            TileEntity lvt_5_1_ = p_shouldMoveTo_1_.getTileEntity(p_shouldMoveTo_2_);
            if (lvt_5_1_ instanceof TileEntityChest && ((TileEntityChest)lvt_5_1_).numPlayersUsing < 1) {
                return true;
            }
        } else {
            if (lvt_4_1_ == Blocks.LIT_FURNACE) {
                return true;
            }
            if (lvt_4_1_ == Blocks.BED && lvt_3_1_.getValue(BlockBed.PART) != BlockBed.EnumPartType.HEAD) {
                return true;
            }
        }
        return false;
    }
}

