/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIPanic
extends EntityAIBase {
    private final EntityCreature theEntityCreature;
    protected double speed;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public EntityAIPanic(EntityCreature p_i1645_1_, double p_i1645_2_) {
        this.theEntityCreature = p_i1645_1_;
        this.speed = p_i1645_2_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        BlockPos lvt_1_1_;
        if (this.theEntityCreature.getAITarget() == null && !this.theEntityCreature.isBurning()) {
            return false;
        }
        if (this.theEntityCreature.isBurning() && (lvt_1_1_ = this.getRandPos(this.theEntityCreature.world, this.theEntityCreature, 5, 4)) != null) {
            this.randPosX = lvt_1_1_.getX();
            this.randPosY = lvt_1_1_.getY();
            this.randPosZ = lvt_1_1_.getZ();
            return true;
        }
        return this.findRandomPosition();
    }

    private boolean findRandomPosition() {
        Vec3d lvt_1_1_ = RandomPositionGenerator.findRandomTarget(this.theEntityCreature, 5, 4);
        if (lvt_1_1_ == null) {
            return false;
        }
        this.randPosX = lvt_1_1_.xCoord;
        this.randPosY = lvt_1_1_.yCoord;
        this.randPosZ = lvt_1_1_.zCoord;
        return true;
    }

    @Override
    public void startExecuting() {
        this.theEntityCreature.getNavigator().tryMoveToXYZ(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    @Override
    public boolean continueExecuting() {
        return !this.theEntityCreature.getNavigator().noPath();
    }

    @Nullable
    private BlockPos getRandPos(World p_getRandPos_1_, Entity p_getRandPos_2_, int p_getRandPos_3_, int p_getRandPos_4_) {
        BlockPos lvt_5_1_ = new BlockPos(p_getRandPos_2_);
        int lvt_6_1_ = lvt_5_1_.getX();
        int lvt_7_1_ = lvt_5_1_.getY();
        int lvt_8_1_ = lvt_5_1_.getZ();
        float lvt_9_1_ = p_getRandPos_3_ * p_getRandPos_3_ * p_getRandPos_4_ * 2;
        BlockPos lvt_10_1_ = null;
        BlockPos.MutableBlockPos lvt_11_1_ = new BlockPos.MutableBlockPos();
        for (int lvt_12_1_ = lvt_6_1_ - p_getRandPos_3_; lvt_12_1_ <= lvt_6_1_ + p_getRandPos_3_; ++lvt_12_1_) {
            for (int lvt_13_1_ = lvt_7_1_ - p_getRandPos_4_; lvt_13_1_ <= lvt_7_1_ + p_getRandPos_4_; ++lvt_13_1_) {
                for (int lvt_14_1_ = lvt_8_1_ - p_getRandPos_3_; lvt_14_1_ <= lvt_8_1_ + p_getRandPos_3_; ++lvt_14_1_) {
                    float lvt_16_1_;
                    lvt_11_1_.setPos(lvt_12_1_, lvt_13_1_, lvt_14_1_);
                    IBlockState lvt_15_1_ = p_getRandPos_1_.getBlockState(lvt_11_1_);
                    if (lvt_15_1_.getMaterial() != Material.WATER || !((lvt_16_1_ = (float)((lvt_12_1_ - lvt_6_1_) * (lvt_12_1_ - lvt_6_1_) + (lvt_13_1_ - lvt_7_1_) * (lvt_13_1_ - lvt_7_1_) + (lvt_14_1_ - lvt_8_1_) * (lvt_14_1_ - lvt_8_1_))) < lvt_9_1_)) continue;
                    lvt_9_1_ = lvt_16_1_;
                    lvt_10_1_ = new BlockPos(lvt_11_1_);
                }
            }
        }
        return lvt_10_1_;
    }
}

