/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.math.Vec3d;

public class EntityAIPlay
extends EntityAIBase {
    private final EntityVillager villagerObj;
    private EntityLivingBase targetVillager;
    private final double speed;
    private int playTime;

    public EntityAIPlay(EntityVillager p_i1646_1_, double p_i1646_2_) {
        this.villagerObj = p_i1646_1_;
        this.speed = p_i1646_2_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        Vec3d lvt_4_1_;
        if (this.villagerObj.getGrowingAge() >= 0) {
            return false;
        }
        if (this.villagerObj.getRNG().nextInt(400) != 0) {
            return false;
        }
        List<EntityVillager> lvt_1_1_ = this.villagerObj.world.getEntitiesWithinAABB(EntityVillager.class, this.villagerObj.getEntityBoundingBox().expand(6.0, 3.0, 6.0));
        double lvt_2_1_ = Double.MAX_VALUE;
        for (EntityVillager lvt_5_1_ : lvt_1_1_) {
            double lvt_6_1_;
            if (lvt_5_1_ == this.villagerObj || lvt_5_1_.isPlaying() || lvt_5_1_.getGrowingAge() >= 0 || (lvt_6_1_ = lvt_5_1_.getDistanceSqToEntity(this.villagerObj)) > lvt_2_1_) continue;
            lvt_2_1_ = lvt_6_1_;
            this.targetVillager = lvt_5_1_;
        }
        return this.targetVillager != null || (lvt_4_1_ = RandomPositionGenerator.findRandomTarget(this.villagerObj, 16, 3)) != null;
    }

    @Override
    public boolean continueExecuting() {
        return this.playTime > 0;
    }

    @Override
    public void startExecuting() {
        if (this.targetVillager != null) {
            this.villagerObj.setPlaying(true);
        }
        this.playTime = 1000;
    }

    @Override
    public void resetTask() {
        this.villagerObj.setPlaying(false);
        this.targetVillager = null;
    }

    @Override
    public void updateTask() {
        --this.playTime;
        if (this.targetVillager != null) {
            if (this.villagerObj.getDistanceSqToEntity(this.targetVillager) > 4.0) {
                this.villagerObj.getNavigator().tryMoveToEntityLiving(this.targetVillager, this.speed);
            }
        } else if (this.villagerObj.getNavigator().noPath()) {
            Vec3d lvt_1_1_ = RandomPositionGenerator.findRandomTarget(this.villagerObj, 16, 3);
            if (lvt_1_1_ == null) {
                return;
            }
            this.villagerObj.getNavigator().tryMoveToXYZ(lvt_1_1_.xCoord, lvt_1_1_.yCoord, lvt_1_1_.zCoord, this.speed);
        }
    }
}

