/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;

public class EntityAIRestrictOpenDoor
extends EntityAIBase {
    private final EntityCreature entityObj;
    private VillageDoorInfo frontDoor;

    public EntityAIRestrictOpenDoor(EntityCreature p_i1651_1_) {
        this.entityObj = p_i1651_1_;
        if (!(p_i1651_1_.getNavigator() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for RestrictOpenDoorGoal");
        }
    }

    @Override
    public boolean shouldExecute() {
        if (this.entityObj.world.isDaytime()) {
            return false;
        }
        BlockPos lvt_1_1_ = new BlockPos(this.entityObj);
        Village lvt_2_1_ = this.entityObj.world.getVillageCollection().getNearestVillage(lvt_1_1_, 16);
        if (lvt_2_1_ == null) {
            return false;
        }
        this.frontDoor = lvt_2_1_.getNearestDoor(lvt_1_1_);
        if (this.frontDoor == null) {
            return false;
        }
        return (double)this.frontDoor.getDistanceToInsideBlockSq(lvt_1_1_) < 2.25;
    }

    @Override
    public boolean continueExecuting() {
        if (this.entityObj.world.isDaytime()) {
            return false;
        }
        return !this.frontDoor.getIsDetachedFromVillageFlag() && this.frontDoor.isInsideSide(new BlockPos(this.entityObj));
    }

    @Override
    public void startExecuting() {
        ((PathNavigateGround)this.entityObj.getNavigator()).setBreakDoors(false);
        ((PathNavigateGround)this.entityObj.getNavigator()).setEnterDoors(false);
    }

    @Override
    public void resetTask() {
        ((PathNavigateGround)this.entityObj.getNavigator()).setBreakDoors(true);
        ((PathNavigateGround)this.entityObj.getNavigator()).setEnterDoors(true);
        this.frontDoor = null;
    }

    @Override
    public void updateTask() {
        this.frontDoor.incrementDoorOpeningRestrictionCounter();
    }
}

