/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class EntityAIRunAroundLikeCrazy
extends EntityAIBase {
    private final AbstractHorse horseHost;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;

    public EntityAIRunAroundLikeCrazy(AbstractHorse p_i1653_1_, double p_i1653_2_) {
        this.horseHost = p_i1653_1_;
        this.speed = p_i1653_2_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (this.horseHost.isTame() || !this.horseHost.isBeingRidden()) {
            return false;
        }
        Vec3d lvt_1_1_ = RandomPositionGenerator.findRandomTarget(this.horseHost, 5, 4);
        if (lvt_1_1_ == null) {
            return false;
        }
        this.targetX = lvt_1_1_.xCoord;
        this.targetY = lvt_1_1_.yCoord;
        this.targetZ = lvt_1_1_.zCoord;
        return true;
    }

    @Override
    public void startExecuting() {
        this.horseHost.getNavigator().tryMoveToXYZ(this.targetX, this.targetY, this.targetZ, this.speed);
    }

    @Override
    public boolean continueExecuting() {
        return !this.horseHost.getNavigator().noPath() && this.horseHost.isBeingRidden();
    }

    @Override
    public void updateTask() {
        if (this.horseHost.getRNG().nextInt(50) == 0) {
            Entity lvt_1_1_ = this.horseHost.getPassengers().get(0);
            if (lvt_1_1_ == null) {
                return;
            }
            if (lvt_1_1_ instanceof EntityPlayer) {
                int lvt_2_1_ = this.horseHost.getTemper();
                int lvt_3_1_ = this.horseHost.getMaxTemper();
                if (lvt_3_1_ > 0 && this.horseHost.getRNG().nextInt(lvt_3_1_) < lvt_2_1_) {
                    this.horseHost.setTamedBy((EntityPlayer)lvt_1_1_);
                    return;
                }
                this.horseHost.increaseTemper(5);
            }
            this.horseHost.removePassengers();
            this.horseHost.makeMad();
            this.horseHost.world.setEntityState(this.horseHost, (byte)6);
        }
    }
}

