/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;

public class EntityAISkeletonRiders
extends EntityAIBase {
    private final EntitySkeletonHorse horse;

    public EntityAISkeletonRiders(EntitySkeletonHorse p_i46797_1_) {
        this.horse = p_i46797_1_;
    }

    @Override
    public boolean shouldExecute() {
        return this.horse.world.isAnyPlayerWithinRangeAt(this.horse.posX, this.horse.posY, this.horse.posZ, 10.0);
    }

    @Override
    public void updateTask() {
        DifficultyInstance lvt_1_1_ = this.horse.world.getDifficultyForLocation(new BlockPos(this.horse));
        this.horse.setTrap(false);
        this.horse.setHorseTamed(true);
        this.horse.setGrowingAge(0);
        this.horse.world.addWeatherEffect(new EntityLightningBolt(this.horse.world, this.horse.posX, this.horse.posY, this.horse.posZ, true));
        EntitySkeleton lvt_2_1_ = this.createSkeleton(lvt_1_1_, this.horse);
        lvt_2_1_.startRiding(this.horse);
        for (int lvt_3_1_ = 0; lvt_3_1_ < 3; ++lvt_3_1_) {
            AbstractHorse lvt_4_1_ = this.createHorse(lvt_1_1_);
            EntitySkeleton lvt_5_1_ = this.createSkeleton(lvt_1_1_, lvt_4_1_);
            lvt_5_1_.startRiding(lvt_4_1_);
            lvt_4_1_.addVelocity(this.horse.getRNG().nextGaussian() * 0.5, 0.0, this.horse.getRNG().nextGaussian() * 0.5);
        }
    }

    private AbstractHorse createHorse(DifficultyInstance p_createHorse_1_) {
        EntitySkeletonHorse lvt_2_1_ = new EntitySkeletonHorse(this.horse.world);
        lvt_2_1_.onInitialSpawn(p_createHorse_1_, null);
        lvt_2_1_.setPosition(this.horse.posX, this.horse.posY, this.horse.posZ);
        lvt_2_1_.hurtResistantTime = 60;
        lvt_2_1_.enablePersistence();
        lvt_2_1_.setHorseTamed(true);
        lvt_2_1_.setGrowingAge(0);
        lvt_2_1_.world.spawnEntity(lvt_2_1_);
        return lvt_2_1_;
    }

    private EntitySkeleton createSkeleton(DifficultyInstance p_createSkeleton_1_, AbstractHorse p_createSkeleton_2_) {
        EntitySkeleton lvt_3_1_ = new EntitySkeleton(p_createSkeleton_2_.world);
        lvt_3_1_.onInitialSpawn(p_createSkeleton_1_, null);
        lvt_3_1_.setPosition(p_createSkeleton_2_.posX, p_createSkeleton_2_.posY, p_createSkeleton_2_.posZ);
        lvt_3_1_.hurtResistantTime = 60;
        lvt_3_1_.enablePersistence();
        if (lvt_3_1_.getItemStackFromSlot(EntityEquipmentSlot.HEAD).isEmpty()) {
            lvt_3_1_.setItemStackToSlot(EntityEquipmentSlot.HEAD, new ItemStack(Items.IRON_HELMET));
        }
        lvt_3_1_.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, EnchantmentHelper.addRandomEnchantment(lvt_3_1_.getRNG(), lvt_3_1_.getHeldItemMainhand(), (int)(5.0f + p_createSkeleton_1_.getClampedAdditionalDifficulty() * (float)lvt_3_1_.getRNG().nextInt(18)), false));
        lvt_3_1_.setItemStackToSlot(EntityEquipmentSlot.HEAD, EnchantmentHelper.addRandomEnchantment(lvt_3_1_.getRNG(), lvt_3_1_.getItemStackFromSlot(EntityEquipmentSlot.HEAD), (int)(5.0f + p_createSkeleton_1_.getClampedAdditionalDifficulty() * (float)lvt_3_1_.getRNG().nextInt(18)), false));
        lvt_3_1_.world.spawnEntity(lvt_3_1_);
        return lvt_3_1_;
    }
}

