/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public abstract class EntityAITarget
extends EntityAIBase {
    protected final EntityCreature taskOwner;
    protected boolean shouldCheckSight;
    private final boolean nearbyOnly;
    private int targetSearchStatus;
    private int targetSearchDelay;
    private int targetUnseenTicks;
    protected EntityLivingBase target;
    protected int unseenMemoryTicks = 60;

    public EntityAITarget(EntityCreature p_i1669_1_, boolean p_i1669_2_) {
        this(p_i1669_1_, p_i1669_2_, false);
    }

    public EntityAITarget(EntityCreature p_i1670_1_, boolean p_i1670_2_, boolean p_i1670_3_) {
        this.taskOwner = p_i1670_1_;
        this.shouldCheckSight = p_i1670_2_;
        this.nearbyOnly = p_i1670_3_;
    }

    @Override
    public boolean continueExecuting() {
        EntityLivingBase lvt_1_1_ = this.taskOwner.getAttackTarget();
        if (lvt_1_1_ == null) {
            lvt_1_1_ = this.target;
        }
        if (lvt_1_1_ == null) {
            return false;
        }
        if (!lvt_1_1_.isEntityAlive()) {
            return false;
        }
        Team lvt_2_1_ = this.taskOwner.getTeam();
        Team lvt_3_1_ = lvt_1_1_.getTeam();
        if (lvt_2_1_ != null && lvt_3_1_ == lvt_2_1_) {
            return false;
        }
        double lvt_4_1_ = this.getTargetDistance();
        if (this.taskOwner.getDistanceSqToEntity(lvt_1_1_) > lvt_4_1_ * lvt_4_1_) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.taskOwner.getEntitySenses().canSee(lvt_1_1_)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) {
                return false;
            }
        }
        if (lvt_1_1_ instanceof EntityPlayer && ((EntityPlayer)lvt_1_1_).capabilities.disableDamage) {
            return false;
        }
        this.taskOwner.setAttackTarget(lvt_1_1_);
        return true;
    }

    protected double getTargetDistance() {
        IAttributeInstance lvt_1_1_ = this.taskOwner.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        return lvt_1_1_ == null ? 16.0 : lvt_1_1_.getAttributeValue();
    }

    @Override
    public void startExecuting() {
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.targetUnseenTicks = 0;
    }

    @Override
    public void resetTask() {
        this.taskOwner.setAttackTarget(null);
        this.target = null;
    }

    public static boolean isSuitableTarget(EntityLiving p_isSuitableTarget_0_, EntityLivingBase p_isSuitableTarget_1_, boolean p_isSuitableTarget_2_, boolean p_isSuitableTarget_3_) {
        if (p_isSuitableTarget_1_ == null) {
            return false;
        }
        if (p_isSuitableTarget_1_ == p_isSuitableTarget_0_) {
            return false;
        }
        if (!p_isSuitableTarget_1_.isEntityAlive()) {
            return false;
        }
        if (!p_isSuitableTarget_0_.canAttackClass(p_isSuitableTarget_1_.getClass())) {
            return false;
        }
        if (p_isSuitableTarget_0_.isOnSameTeam(p_isSuitableTarget_1_)) {
            return false;
        }
        if (p_isSuitableTarget_0_ instanceof IEntityOwnable && ((IEntityOwnable)((Object)p_isSuitableTarget_0_)).getOwnerId() != null) {
            if (p_isSuitableTarget_1_ instanceof IEntityOwnable && ((IEntityOwnable)((Object)p_isSuitableTarget_0_)).getOwnerId().equals(p_isSuitableTarget_1_.getUniqueID())) {
                return false;
            }
            if (p_isSuitableTarget_1_ == ((IEntityOwnable)((Object)p_isSuitableTarget_0_)).getOwner()) {
                return false;
            }
        } else if (p_isSuitableTarget_1_ instanceof EntityPlayer && !p_isSuitableTarget_2_ && ((EntityPlayer)p_isSuitableTarget_1_).capabilities.disableDamage) {
            return false;
        }
        return !p_isSuitableTarget_3_ || p_isSuitableTarget_0_.getEntitySenses().canSee(p_isSuitableTarget_1_);
    }

    protected boolean isSuitableTarget(EntityLivingBase p_isSuitableTarget_1_, boolean p_isSuitableTarget_2_) {
        if (!EntityAITarget.isSuitableTarget(this.taskOwner, p_isSuitableTarget_1_, p_isSuitableTarget_2_, this.shouldCheckSight)) {
            return false;
        }
        if (!this.taskOwner.isWithinHomeDistanceFromPosition(new BlockPos(p_isSuitableTarget_1_))) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.canEasilyReach(p_isSuitableTarget_1_) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canEasilyReach(EntityLivingBase p_canEasilyReach_1_) {
        int lvt_5_1_;
        this.targetSearchDelay = 10 + this.taskOwner.getRNG().nextInt(5);
        Path lvt_2_1_ = this.taskOwner.getNavigator().getPathToEntityLiving(p_canEasilyReach_1_);
        if (lvt_2_1_ == null) {
            return false;
        }
        PathPoint lvt_3_1_ = lvt_2_1_.getFinalPathPoint();
        if (lvt_3_1_ == null) {
            return false;
        }
        int lvt_4_1_ = lvt_3_1_.xCoord - MathHelper.floor(p_canEasilyReach_1_.posX);
        return (double)(lvt_4_1_ * lvt_4_1_ + (lvt_5_1_ = lvt_3_1_.zCoord - MathHelper.floor(p_canEasilyReach_1_.posZ)) * lvt_5_1_) <= 2.25;
    }

    public EntityAITarget setUnseenMemoryTicks(int p_setUnseenMemoryTicks_1_) {
        this.unseenMemoryTicks = p_setUnseenMemoryTicks_1_;
        return this;
    }
}

