/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.profiler.Profiler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityAITasks {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Set<EntityAITaskEntry> taskEntries = Sets.newLinkedHashSet();
    private final Set<EntityAITaskEntry> executingTaskEntries = Sets.newLinkedHashSet();
    private final Profiler theProfiler;
    private int tickCount;
    private int tickRate = 3;
    private int disabledControlFlags;

    public EntityAITasks(Profiler p_i1628_1_) {
        this.theProfiler = p_i1628_1_;
    }

    public void addTask(int p_addTask_1_, EntityAIBase p_addTask_2_) {
        this.taskEntries.add(new EntityAITaskEntry(p_addTask_1_, p_addTask_2_));
    }

    public void removeTask(EntityAIBase p_removeTask_1_) {
        Iterator<EntityAITaskEntry> lvt_2_1_ = this.taskEntries.iterator();
        while (lvt_2_1_.hasNext()) {
            EntityAITaskEntry lvt_3_1_ = lvt_2_1_.next();
            EntityAIBase lvt_4_1_ = lvt_3_1_.action;
            if (lvt_4_1_ != p_removeTask_1_) continue;
            if (lvt_3_1_.using) {
                lvt_3_1_.using = false;
                lvt_3_1_.action.resetTask();
                this.executingTaskEntries.remove(lvt_3_1_);
            }
            lvt_2_1_.remove();
            return;
        }
    }

    public void onUpdateTasks() {
        this.theProfiler.startSection("goalSetup");
        if (this.tickCount++ % this.tickRate == 0) {
            for (EntityAITaskEntry lvt_2_1_ : this.taskEntries) {
                if (lvt_2_1_.using) {
                    if (this.canUse(lvt_2_1_) && this.canContinue(lvt_2_1_)) continue;
                    lvt_2_1_.using = false;
                    lvt_2_1_.action.resetTask();
                    this.executingTaskEntries.remove(lvt_2_1_);
                    continue;
                }
                if (!this.canUse(lvt_2_1_) || !lvt_2_1_.action.shouldExecute()) continue;
                lvt_2_1_.using = true;
                lvt_2_1_.action.startExecuting();
                this.executingTaskEntries.add(lvt_2_1_);
            }
        } else {
            Iterator<EntityAITaskEntry> lvt_1_1_ = this.executingTaskEntries.iterator();
            while (lvt_1_1_.hasNext()) {
                EntityAITaskEntry lvt_2_2_ = lvt_1_1_.next();
                if (this.canContinue(lvt_2_2_)) continue;
                lvt_2_2_.using = false;
                lvt_2_2_.action.resetTask();
                lvt_1_1_.remove();
            }
        }
        this.theProfiler.endSection();
        if (!this.executingTaskEntries.isEmpty()) {
            this.theProfiler.startSection("goalTick");
            for (EntityAITaskEntry lvt_2_3_ : this.executingTaskEntries) {
                lvt_2_3_.action.updateTask();
            }
            this.theProfiler.endSection();
        }
    }

    private boolean canContinue(EntityAITaskEntry p_canContinue_1_) {
        return p_canContinue_1_.action.continueExecuting();
    }

    private boolean canUse(EntityAITaskEntry p_canUse_1_) {
        if (this.executingTaskEntries.isEmpty()) {
            return true;
        }
        if (this.isControlFlagDisabled(p_canUse_1_.action.getMutexBits())) {
            return false;
        }
        for (EntityAITaskEntry lvt_3_1_ : this.executingTaskEntries) {
            if (lvt_3_1_ == p_canUse_1_ || !(p_canUse_1_.priority >= lvt_3_1_.priority ? !this.areTasksCompatible(p_canUse_1_, lvt_3_1_) : !lvt_3_1_.action.isInterruptible())) continue;
            return false;
        }
        return true;
    }

    private boolean areTasksCompatible(EntityAITaskEntry p_areTasksCompatible_1_, EntityAITaskEntry p_areTasksCompatible_2_) {
        return (p_areTasksCompatible_1_.action.getMutexBits() & p_areTasksCompatible_2_.action.getMutexBits()) == 0;
    }

    public boolean isControlFlagDisabled(int p_isControlFlagDisabled_1_) {
        return (this.disabledControlFlags & p_isControlFlagDisabled_1_) > 0;
    }

    public void disableControlFlag(int p_disableControlFlag_1_) {
        this.disabledControlFlags |= p_disableControlFlag_1_;
    }

    public void enableControlFlag(int p_enableControlFlag_1_) {
        this.disabledControlFlags &= ~p_enableControlFlag_1_;
    }

    public void setControlFlag(int p_setControlFlag_1_, boolean p_setControlFlag_2_) {
        if (p_setControlFlag_2_) {
            this.enableControlFlag(p_setControlFlag_1_);
        } else {
            this.disableControlFlag(p_setControlFlag_1_);
        }
    }

    public class EntityAITaskEntry {
        public final EntityAIBase action;
        public final int priority;
        public boolean using;

        public EntityAITaskEntry(int p_i1627_2_, EntityAIBase p_i1627_3_) {
            this.priority = p_i1627_2_;
            this.action = p_i1627_3_;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ == null || this.getClass() != p_equals_1_.getClass()) {
                return false;
            }
            return this.action.equals(((EntityAITaskEntry)p_equals_1_).action);
        }

        public int hashCode() {
            return this.action.hashCode();
        }
    }
}

