/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class EntityAIVillagerInteract
extends EntityAIWatchClosest2 {
    private int interactionDelay;
    private final EntityVillager villager;

    public EntityAIVillagerInteract(EntityVillager p_i45886_1_) {
        super(p_i45886_1_, EntityVillager.class, 3.0f, 0.02f);
        this.villager = p_i45886_1_;
    }

    @Override
    public void startExecuting() {
        super.startExecuting();
        this.interactionDelay = this.villager.canAbondonItems() && this.closestEntity instanceof EntityVillager && ((EntityVillager)this.closestEntity).wantsMoreFood() ? 10 : 0;
    }

    @Override
    public void updateTask() {
        super.updateTask();
        if (this.interactionDelay > 0) {
            --this.interactionDelay;
            if (this.interactionDelay == 0) {
                InventoryBasic lvt_1_1_ = this.villager.getVillagerInventory();
                for (int lvt_2_1_ = 0; lvt_2_1_ < lvt_1_1_.getSizeInventory(); ++lvt_2_1_) {
                    ItemStack lvt_3_1_ = lvt_1_1_.getStackInSlot(lvt_2_1_);
                    ItemStack lvt_4_1_ = ItemStack.EMPTY;
                    if (!lvt_3_1_.isEmpty()) {
                        Item lvt_5_1_ = lvt_3_1_.getItem();
                        if ((lvt_5_1_ == Items.BREAD || lvt_5_1_ == Items.POTATO || lvt_5_1_ == Items.CARROT || lvt_5_1_ == Items.BEETROOT) && lvt_3_1_.getCount() > 3) {
                            int lvt_6_1_ = lvt_3_1_.getCount() / 2;
                            lvt_3_1_.shrink(lvt_6_1_);
                            lvt_4_1_ = new ItemStack(lvt_5_1_, lvt_6_1_, lvt_3_1_.getMetadata());
                        } else if (lvt_5_1_ == Items.WHEAT && lvt_3_1_.getCount() > 5) {
                            int lvt_6_2_ = lvt_3_1_.getCount() / 2 / 3 * 3;
                            int lvt_7_1_ = lvt_6_2_ / 3;
                            lvt_3_1_.shrink(lvt_6_2_);
                            lvt_4_1_ = new ItemStack(Items.BREAD, lvt_7_1_, 0);
                        }
                        if (lvt_3_1_.isEmpty()) {
                            lvt_1_1_.setInventorySlotContents(lvt_2_1_, ItemStack.EMPTY);
                        }
                    }
                    if (lvt_4_1_.isEmpty()) continue;
                    double lvt_5_2_ = this.villager.posY - (double)0.3f + (double)this.villager.getEyeHeight();
                    EntityItem lvt_7_2_ = new EntityItem(this.villager.world, this.villager.posX, lvt_5_2_, this.villager.posZ, lvt_4_1_);
                    float lvt_8_1_ = 0.3f;
                    float lvt_9_1_ = this.villager.rotationYawHead;
                    float lvt_10_1_ = this.villager.rotationPitch;
                    lvt_7_2_.motionX = -MathHelper.sin(lvt_9_1_ * ((float)Math.PI / 180)) * MathHelper.cos(lvt_10_1_ * ((float)Math.PI / 180)) * 0.3f;
                    lvt_7_2_.motionZ = MathHelper.cos(lvt_9_1_ * ((float)Math.PI / 180)) * MathHelper.cos(lvt_10_1_ * ((float)Math.PI / 180)) * 0.3f;
                    lvt_7_2_.motionY = -MathHelper.sin(lvt_10_1_ * ((float)Math.PI / 180)) * 0.3f + 0.1f;
                    lvt_7_2_.setDefaultPickupDelay();
                    this.villager.world.spawnEntity(lvt_7_2_);
                    break;
                }
            }
        }
    }
}

