/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;

public class EntityAIWander
extends EntityAIBase {
    protected final EntityCreature entity;
    protected double xPosition;
    protected double yPosition;
    protected double zPosition;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;

    public EntityAIWander(EntityCreature p_i1648_1_, double p_i1648_2_) {
        this(p_i1648_1_, p_i1648_2_, 120);
    }

    public EntityAIWander(EntityCreature p_i45887_1_, double p_i45887_2_, int p_i45887_4_) {
        this.entity = p_i45887_1_;
        this.speed = p_i45887_2_;
        this.executionChance = p_i45887_4_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        Vec3d lvt_1_1_;
        if (!this.mustUpdate) {
            if (this.entity.getAge() >= 100) {
                return false;
            }
            if (this.entity.getRNG().nextInt(this.executionChance) != 0) {
                return false;
            }
        }
        if ((lvt_1_1_ = this.getPosition()) == null) {
            return false;
        }
        this.xPosition = lvt_1_1_.xCoord;
        this.yPosition = lvt_1_1_.yCoord;
        this.zPosition = lvt_1_1_.zCoord;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        return RandomPositionGenerator.findRandomTarget(this.entity, 10, 7);
    }

    @Override
    public boolean continueExecuting() {
        return !this.entity.getNavigator().noPath();
    }

    @Override
    public void startExecuting() {
        this.entity.getNavigator().tryMoveToXYZ(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int p_setExecutionChance_1_) {
        this.executionChance = p_setExecutionChance_1_;
    }
}

