/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class EntityLookHelper {
    private final EntityLiving entity;
    private float deltaLookYaw;
    private float deltaLookPitch;
    private boolean isLooking;
    private double posX;
    private double posY;
    private double posZ;

    public EntityLookHelper(EntityLiving p_i1613_1_) {
        this.entity = p_i1613_1_;
    }

    public void setLookPositionWithEntity(Entity p_setLookPositionWithEntity_1_, float p_setLookPositionWithEntity_2_, float p_setLookPositionWithEntity_3_) {
        this.posX = p_setLookPositionWithEntity_1_.posX;
        this.posY = p_setLookPositionWithEntity_1_ instanceof EntityLivingBase ? p_setLookPositionWithEntity_1_.posY + (double)p_setLookPositionWithEntity_1_.getEyeHeight() : (p_setLookPositionWithEntity_1_.getEntityBoundingBox().minY + p_setLookPositionWithEntity_1_.getEntityBoundingBox().maxY) / 2.0;
        this.posZ = p_setLookPositionWithEntity_1_.posZ;
        this.deltaLookYaw = p_setLookPositionWithEntity_2_;
        this.deltaLookPitch = p_setLookPositionWithEntity_3_;
        this.isLooking = true;
    }

    public void setLookPosition(double p_setLookPosition_1_, double p_setLookPosition_3_, double p_setLookPosition_5_, float p_setLookPosition_7_, float p_setLookPosition_8_) {
        this.posX = p_setLookPosition_1_;
        this.posY = p_setLookPosition_3_;
        this.posZ = p_setLookPosition_5_;
        this.deltaLookYaw = p_setLookPosition_7_;
        this.deltaLookPitch = p_setLookPosition_8_;
        this.isLooking = true;
    }

    public void onUpdateLook() {
        this.entity.rotationPitch = 0.0f;
        if (this.isLooking) {
            this.isLooking = false;
            double lvt_1_1_ = this.posX - this.entity.posX;
            double lvt_3_1_ = this.posY - (this.entity.posY + (double)this.entity.getEyeHeight());
            double lvt_5_1_ = this.posZ - this.entity.posZ;
            double lvt_7_1_ = MathHelper.sqrt(lvt_1_1_ * lvt_1_1_ + lvt_5_1_ * lvt_5_1_);
            float lvt_9_1_ = (float)(MathHelper.atan2(lvt_5_1_, lvt_1_1_) * 57.2957763671875) - 90.0f;
            float lvt_10_1_ = (float)(-(MathHelper.atan2(lvt_3_1_, lvt_7_1_) * 57.2957763671875));
            this.entity.rotationPitch = this.updateRotation(this.entity.rotationPitch, lvt_10_1_, this.deltaLookPitch);
            this.entity.rotationYawHead = this.updateRotation(this.entity.rotationYawHead, lvt_9_1_, this.deltaLookYaw);
        } else {
            this.entity.rotationYawHead = this.updateRotation(this.entity.rotationYawHead, this.entity.renderYawOffset, 10.0f);
        }
        float lvt_1_2_ = MathHelper.wrapDegrees(this.entity.rotationYawHead - this.entity.renderYawOffset);
        if (!this.entity.getNavigator().noPath()) {
            if (lvt_1_2_ < -75.0f) {
                this.entity.rotationYawHead = this.entity.renderYawOffset - 75.0f;
            }
            if (lvt_1_2_ > 75.0f) {
                this.entity.rotationYawHead = this.entity.renderYawOffset + 75.0f;
            }
        }
    }

    private float updateRotation(float p_updateRotation_1_, float p_updateRotation_2_, float p_updateRotation_3_) {
        float lvt_4_1_ = MathHelper.wrapDegrees(p_updateRotation_2_ - p_updateRotation_1_);
        if (lvt_4_1_ > p_updateRotation_3_) {
            lvt_4_1_ = p_updateRotation_3_;
        }
        if (lvt_4_1_ < -p_updateRotation_3_) {
            lvt_4_1_ = -p_updateRotation_3_;
        }
        return p_updateRotation_1_ + lvt_4_1_;
    }

    public boolean getIsLooking() {
        return this.isLooking;
    }

    public double getLookPosX() {
        return this.posX;
    }

    public double getLookPosY() {
        return this.posY;
    }

    public double getLookPosZ() {
        return this.posZ;
    }
}

