/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.MathHelper;

public class EntityMoveHelper {
    protected final EntityLiving entity;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected double speed;
    protected float moveForward;
    protected float moveStrafe;
    public Action action = Action.WAIT;

    public EntityMoveHelper(EntityLiving p_i1614_1_) {
        this.entity = p_i1614_1_;
    }

    public boolean isUpdating() {
        return this.action == Action.MOVE_TO;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setMoveTo(double p_setMoveTo_1_, double p_setMoveTo_3_, double p_setMoveTo_5_, double p_setMoveTo_7_) {
        this.posX = p_setMoveTo_1_;
        this.posY = p_setMoveTo_3_;
        this.posZ = p_setMoveTo_5_;
        this.speed = p_setMoveTo_7_;
        this.action = Action.MOVE_TO;
    }

    public void strafe(float p_strafe_1_, float p_strafe_2_) {
        this.action = Action.STRAFE;
        this.moveForward = p_strafe_1_;
        this.moveStrafe = p_strafe_2_;
        this.speed = 0.25;
    }

    public void read(EntityMoveHelper p_read_1_) {
        this.action = p_read_1_.action;
        this.posX = p_read_1_.posX;
        this.posY = p_read_1_.posY;
        this.posZ = p_read_1_.posZ;
        this.speed = Math.max(p_read_1_.speed, 1.0);
        this.moveForward = p_read_1_.moveForward;
        this.moveStrafe = p_read_1_.moveStrafe;
    }

    public void onUpdateMoveHelper() {
        if (this.action == Action.STRAFE) {
            NodeProcessor lvt_11_1_;
            float lvt_1_1_ = (float)this.entity.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue();
            float lvt_2_1_ = (float)this.speed * lvt_1_1_;
            float lvt_3_1_ = this.moveForward;
            float lvt_4_1_ = this.moveStrafe;
            float lvt_5_1_ = MathHelper.sqrt(lvt_3_1_ * lvt_3_1_ + lvt_4_1_ * lvt_4_1_);
            if (lvt_5_1_ < 1.0f) {
                lvt_5_1_ = 1.0f;
            }
            lvt_5_1_ = lvt_2_1_ / lvt_5_1_;
            float lvt_6_1_ = MathHelper.sin(this.entity.rotationYaw * ((float)Math.PI / 180));
            float lvt_7_1_ = MathHelper.cos(this.entity.rotationYaw * ((float)Math.PI / 180));
            float lvt_8_1_ = (lvt_3_1_ *= lvt_5_1_) * lvt_7_1_ - (lvt_4_1_ *= lvt_5_1_) * lvt_6_1_;
            float lvt_9_1_ = lvt_4_1_ * lvt_7_1_ + lvt_3_1_ * lvt_6_1_;
            PathNavigate lvt_10_1_ = this.entity.getNavigator();
            if (lvt_10_1_ != null && (lvt_11_1_ = lvt_10_1_.getNodeProcessor()) != null && lvt_11_1_.getPathNodeType(this.entity.world, MathHelper.floor(this.entity.posX + (double)lvt_8_1_), MathHelper.floor(this.entity.posY), MathHelper.floor(this.entity.posZ + (double)lvt_9_1_)) != PathNodeType.WALKABLE) {
                this.moveForward = 1.0f;
                this.moveStrafe = 0.0f;
                lvt_2_1_ = lvt_1_1_;
            }
            this.entity.setAIMoveSpeed(lvt_2_1_);
            this.entity.setMoveForward(this.moveForward);
            this.entity.setMoveStrafing(this.moveStrafe);
            this.action = Action.WAIT;
        } else if (this.action == Action.MOVE_TO) {
            this.action = Action.WAIT;
            double lvt_1_2_ = this.posX - this.entity.posX;
            double lvt_5_2_ = this.posY - this.entity.posY;
            double lvt_3_2_ = this.posZ - this.entity.posZ;
            double lvt_7_2_ = lvt_1_2_ * lvt_1_2_ + lvt_5_2_ * lvt_5_2_ + lvt_3_2_ * lvt_3_2_;
            if (lvt_7_2_ < 2.500000277905201E-7) {
                this.entity.setMoveForward(0.0f);
                return;
            }
            float lvt_9_2_ = (float)(MathHelper.atan2(lvt_3_2_, lvt_1_2_) * 57.2957763671875) - 90.0f;
            this.entity.rotationYaw = this.limitAngle(this.entity.rotationYaw, lvt_9_2_, 90.0f);
            this.entity.setAIMoveSpeed((float)(this.speed * this.entity.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue()));
            if (lvt_5_2_ > (double)this.entity.stepHeight && lvt_1_2_ * lvt_1_2_ + lvt_3_2_ * lvt_3_2_ < (double)Math.max(1.0f, this.entity.width)) {
                this.entity.getJumpHelper().setJumping();
                this.action = Action.JUMPING;
            }
        } else if (this.action == Action.JUMPING) {
            this.entity.setAIMoveSpeed((float)(this.speed * this.entity.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue()));
            if (this.entity.onGround) {
                this.action = Action.WAIT;
            }
        } else {
            this.entity.setMoveForward(0.0f);
        }
    }

    protected float limitAngle(float p_limitAngle_1_, float p_limitAngle_2_, float p_limitAngle_3_) {
        float lvt_5_1_;
        float lvt_4_1_ = MathHelper.wrapDegrees(p_limitAngle_2_ - p_limitAngle_1_);
        if (lvt_4_1_ > p_limitAngle_3_) {
            lvt_4_1_ = p_limitAngle_3_;
        }
        if (lvt_4_1_ < -p_limitAngle_3_) {
            lvt_4_1_ = -p_limitAngle_3_;
        }
        if ((lvt_5_1_ = p_limitAngle_1_ + lvt_4_1_) < 0.0f) {
            lvt_5_1_ += 360.0f;
        } else if (lvt_5_1_ > 360.0f) {
            lvt_5_1_ -= 360.0f;
        }
        return lvt_5_1_;
    }

    public double getX() {
        return this.posX;
    }

    public double getY() {
        return this.posY;
    }

    public double getZ() {
        return this.posZ;
    }

    public static enum Action {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

