/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class RandomPositionGenerator {
    private static Vec3d staticVector = Vec3d.ZERO;

    @Nullable
    public static Vec3d findRandomTarget(EntityCreature p_findRandomTarget_0_, int p_findRandomTarget_1_, int p_findRandomTarget_2_) {
        return RandomPositionGenerator.findRandomTargetBlock(p_findRandomTarget_0_, p_findRandomTarget_1_, p_findRandomTarget_2_, null);
    }

    @Nullable
    public static Vec3d getLandPos(EntityCreature p_getLandPos_0_, int p_getLandPos_1_, int p_getLandPos_2_) {
        return RandomPositionGenerator.generateRandomPos(p_getLandPos_0_, p_getLandPos_1_, p_getLandPos_2_, null, false);
    }

    @Nullable
    public static Vec3d findRandomTargetBlockTowards(EntityCreature p_findRandomTargetBlockTowards_0_, int p_findRandomTargetBlockTowards_1_, int p_findRandomTargetBlockTowards_2_, Vec3d p_findRandomTargetBlockTowards_3_) {
        staticVector = p_findRandomTargetBlockTowards_3_.subtract(p_findRandomTargetBlockTowards_0_.posX, p_findRandomTargetBlockTowards_0_.posY, p_findRandomTargetBlockTowards_0_.posZ);
        return RandomPositionGenerator.findRandomTargetBlock(p_findRandomTargetBlockTowards_0_, p_findRandomTargetBlockTowards_1_, p_findRandomTargetBlockTowards_2_, staticVector);
    }

    @Nullable
    public static Vec3d findRandomTargetBlockAwayFrom(EntityCreature p_findRandomTargetBlockAwayFrom_0_, int p_findRandomTargetBlockAwayFrom_1_, int p_findRandomTargetBlockAwayFrom_2_, Vec3d p_findRandomTargetBlockAwayFrom_3_) {
        staticVector = new Vec3d(p_findRandomTargetBlockAwayFrom_0_.posX, p_findRandomTargetBlockAwayFrom_0_.posY, p_findRandomTargetBlockAwayFrom_0_.posZ).subtract(p_findRandomTargetBlockAwayFrom_3_);
        return RandomPositionGenerator.findRandomTargetBlock(p_findRandomTargetBlockAwayFrom_0_, p_findRandomTargetBlockAwayFrom_1_, p_findRandomTargetBlockAwayFrom_2_, staticVector);
    }

    @Nullable
    private static Vec3d findRandomTargetBlock(EntityCreature p_findRandomTargetBlock_0_, int p_findRandomTargetBlock_1_, int p_findRandomTargetBlock_2_, Vec3d p_findRandomTargetBlock_3_) {
        return RandomPositionGenerator.generateRandomPos(p_findRandomTargetBlock_0_, p_findRandomTargetBlock_1_, p_findRandomTargetBlock_2_, p_findRandomTargetBlock_3_, true);
    }

    @Nullable
    private static Vec3d generateRandomPos(EntityCreature p_generateRandomPos_0_, int p_generateRandomPos_1_, int p_generateRandomPos_2_, Vec3d p_generateRandomPos_3_, boolean p_generateRandomPos_4_) {
        boolean lvt_7_2_;
        PathNavigate lvt_5_1_ = p_generateRandomPos_0_.getNavigator();
        Random lvt_6_1_ = p_generateRandomPos_0_.getRNG();
        if (p_generateRandomPos_0_.hasHome()) {
            double lvt_10_1_;
            double lvt_8_1_ = p_generateRandomPos_0_.getHomePosition().distanceSq(MathHelper.floor(p_generateRandomPos_0_.posX), MathHelper.floor(p_generateRandomPos_0_.posY), MathHelper.floor(p_generateRandomPos_0_.posZ)) + 4.0;
            boolean lvt_7_1_ = lvt_8_1_ < (lvt_10_1_ = (double)(p_generateRandomPos_0_.getMaximumHomeDistance() + (float)p_generateRandomPos_1_)) * lvt_10_1_;
        } else {
            lvt_7_2_ = false;
        }
        boolean lvt_8_2_ = false;
        float lvt_9_1_ = -99999.0f;
        int lvt_10_2_ = 0;
        int lvt_11_1_ = 0;
        int lvt_12_1_ = 0;
        for (int lvt_13_1_ = 0; lvt_13_1_ < 10; ++lvt_13_1_) {
            float lvt_18_1_;
            int lvt_14_1_ = lvt_6_1_.nextInt(2 * p_generateRandomPos_1_ + 1) - p_generateRandomPos_1_;
            int lvt_15_1_ = lvt_6_1_.nextInt(2 * p_generateRandomPos_2_ + 1) - p_generateRandomPos_2_;
            int lvt_16_1_ = lvt_6_1_.nextInt(2 * p_generateRandomPos_1_ + 1) - p_generateRandomPos_1_;
            if (p_generateRandomPos_3_ != null && (double)lvt_14_1_ * p_generateRandomPos_3_.xCoord + (double)lvt_16_1_ * p_generateRandomPos_3_.zCoord < 0.0) continue;
            if (p_generateRandomPos_0_.hasHome() && p_generateRandomPos_1_ > 1) {
                BlockPos lvt_17_1_ = p_generateRandomPos_0_.getHomePosition();
                lvt_14_1_ = p_generateRandomPos_0_.posX > (double)lvt_17_1_.getX() ? (lvt_14_1_ -= lvt_6_1_.nextInt(p_generateRandomPos_1_ / 2)) : (lvt_14_1_ += lvt_6_1_.nextInt(p_generateRandomPos_1_ / 2));
                lvt_16_1_ = p_generateRandomPos_0_.posZ > (double)lvt_17_1_.getZ() ? (lvt_16_1_ -= lvt_6_1_.nextInt(p_generateRandomPos_1_ / 2)) : (lvt_16_1_ += lvt_6_1_.nextInt(p_generateRandomPos_1_ / 2));
            }
            BlockPos lvt_17_2_ = new BlockPos((double)lvt_14_1_ + p_generateRandomPos_0_.posX, (double)lvt_15_1_ + p_generateRandomPos_0_.posY, (double)lvt_16_1_ + p_generateRandomPos_0_.posZ);
            if (lvt_7_2_ && !p_generateRandomPos_0_.isWithinHomeDistanceFromPosition(lvt_17_2_) || !lvt_5_1_.canEntityStandOnPos(lvt_17_2_) || !p_generateRandomPos_4_ && RandomPositionGenerator.isWaterDestination(lvt_17_2_ = RandomPositionGenerator.moveAboveSolid(lvt_17_2_, p_generateRandomPos_0_), p_generateRandomPos_0_) || !((lvt_18_1_ = p_generateRandomPos_0_.getBlockPathWeight(lvt_17_2_)) > lvt_9_1_)) continue;
            lvt_9_1_ = lvt_18_1_;
            lvt_10_2_ = lvt_14_1_;
            lvt_11_1_ = lvt_15_1_;
            lvt_12_1_ = lvt_16_1_;
            lvt_8_2_ = true;
        }
        if (lvt_8_2_) {
            return new Vec3d((double)lvt_10_2_ + p_generateRandomPos_0_.posX, (double)lvt_11_1_ + p_generateRandomPos_0_.posY, (double)lvt_12_1_ + p_generateRandomPos_0_.posZ);
        }
        return null;
    }

    private static BlockPos moveAboveSolid(BlockPos p_moveAboveSolid_0_, EntityCreature p_moveAboveSolid_1_) {
        if (p_moveAboveSolid_1_.world.getBlockState(p_moveAboveSolid_0_).getMaterial().isSolid()) {
            BlockPos lvt_2_1_ = p_moveAboveSolid_0_.up();
            while (lvt_2_1_.getY() < p_moveAboveSolid_1_.world.getHeight() && p_moveAboveSolid_1_.world.getBlockState(lvt_2_1_).getMaterial().isSolid()) {
                lvt_2_1_ = lvt_2_1_.up();
            }
            return lvt_2_1_;
        }
        return p_moveAboveSolid_0_;
    }

    private static boolean isWaterDestination(BlockPos p_isWaterDestination_0_, EntityCreature p_isWaterDestination_1_) {
        return p_isWaterDestination_1_.world.getBlockState(p_isWaterDestination_0_).getMaterial() == Material.WATER;
    }
}

