/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.LowerStringMap;

public abstract class AbstractAttributeMap {
    protected final Map<IAttribute, IAttributeInstance> attributes = Maps.newHashMap();
    protected final Map<String, IAttributeInstance> attributesByName = new LowerStringMap<IAttributeInstance>();
    protected final Multimap<IAttribute, IAttribute> descendantsByParent = HashMultimap.create();

    public IAttributeInstance getAttributeInstance(IAttribute p_getAttributeInstance_1_) {
        return this.attributes.get(p_getAttributeInstance_1_);
    }

    @Nullable
    public IAttributeInstance getAttributeInstanceByName(String p_getAttributeInstanceByName_1_) {
        return this.attributesByName.get(p_getAttributeInstanceByName_1_);
    }

    public IAttributeInstance registerAttribute(IAttribute p_registerAttribute_1_) {
        if (this.attributesByName.containsKey(p_registerAttribute_1_.getName())) {
            throw new IllegalArgumentException("Attribute is already registered!");
        }
        IAttributeInstance lvt_2_1_ = this.createInstance(p_registerAttribute_1_);
        this.attributesByName.put(p_registerAttribute_1_.getName(), lvt_2_1_);
        this.attributes.put(p_registerAttribute_1_, lvt_2_1_);
        for (IAttribute lvt_3_1_ = p_registerAttribute_1_.getParent(); lvt_3_1_ != null; lvt_3_1_ = lvt_3_1_.getParent()) {
            this.descendantsByParent.put((Object)lvt_3_1_, (Object)p_registerAttribute_1_);
        }
        return lvt_2_1_;
    }

    protected abstract IAttributeInstance createInstance(IAttribute var1);

    public Collection<IAttributeInstance> getAllAttributes() {
        return this.attributesByName.values();
    }

    public void onAttributeModified(IAttributeInstance p_onAttributeModified_1_) {
    }

    public void removeAttributeModifiers(Multimap<String, AttributeModifier> p_removeAttributeModifiers_1_) {
        for (Map.Entry lvt_3_1_ : p_removeAttributeModifiers_1_.entries()) {
            IAttributeInstance lvt_4_1_ = this.getAttributeInstanceByName((String)lvt_3_1_.getKey());
            if (lvt_4_1_ == null) continue;
            lvt_4_1_.removeModifier((AttributeModifier)lvt_3_1_.getValue());
        }
    }

    public void applyAttributeModifiers(Multimap<String, AttributeModifier> p_applyAttributeModifiers_1_) {
        for (Map.Entry lvt_3_1_ : p_applyAttributeModifiers_1_.entries()) {
            IAttributeInstance lvt_4_1_ = this.getAttributeInstanceByName((String)lvt_3_1_.getKey());
            if (lvt_4_1_ == null) continue;
            lvt_4_1_.removeModifier((AttributeModifier)lvt_3_1_.getValue());
            lvt_4_1_.applyModifier((AttributeModifier)lvt_3_1_.getValue());
        }
    }
}

