/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.LowerStringMap;

public class AttributeMap
extends AbstractAttributeMap {
    private final Set<IAttributeInstance> attributeInstanceSet = Sets.newHashSet();
    protected final Map<String, IAttributeInstance> descriptionToAttributeInstanceMap = new LowerStringMap<IAttributeInstance>();

    @Override
    public ModifiableAttributeInstance getAttributeInstance(IAttribute p_getAttributeInstance_1_) {
        return (ModifiableAttributeInstance)super.getAttributeInstance(p_getAttributeInstance_1_);
    }

    @Override
    public ModifiableAttributeInstance getAttributeInstanceByName(String p_getAttributeInstanceByName_1_) {
        IAttributeInstance lvt_2_1_ = super.getAttributeInstanceByName(p_getAttributeInstanceByName_1_);
        if (lvt_2_1_ == null) {
            lvt_2_1_ = this.descriptionToAttributeInstanceMap.get(p_getAttributeInstanceByName_1_);
        }
        return (ModifiableAttributeInstance)lvt_2_1_;
    }

    @Override
    public IAttributeInstance registerAttribute(IAttribute p_registerAttribute_1_) {
        IAttributeInstance lvt_2_1_ = super.registerAttribute(p_registerAttribute_1_);
        if (p_registerAttribute_1_ instanceof RangedAttribute && ((RangedAttribute)p_registerAttribute_1_).getDescription() != null) {
            this.descriptionToAttributeInstanceMap.put(((RangedAttribute)p_registerAttribute_1_).getDescription(), lvt_2_1_);
        }
        return lvt_2_1_;
    }

    @Override
    protected IAttributeInstance createInstance(IAttribute p_createInstance_1_) {
        return new ModifiableAttributeInstance(this, p_createInstance_1_);
    }

    @Override
    public void onAttributeModified(IAttributeInstance p_onAttributeModified_1_) {
        if (p_onAttributeModified_1_.getAttribute().getShouldWatch()) {
            this.attributeInstanceSet.add(p_onAttributeModified_1_);
        }
        for (IAttribute lvt_3_1_ : this.descendantsByParent.get((Object)p_onAttributeModified_1_.getAttribute())) {
            ModifiableAttributeInstance lvt_4_1_ = this.getAttributeInstance(lvt_3_1_);
            if (lvt_4_1_ == null) continue;
            lvt_4_1_.flagForUpdate();
        }
    }

    public Set<IAttributeInstance> getAttributeInstanceSet() {
        return this.attributeInstanceSet;
    }

    public Collection<IAttributeInstance> getWatchedAttributes() {
        HashSet lvt_1_1_ = Sets.newHashSet();
        for (IAttributeInstance lvt_3_1_ : this.getAllAttributes()) {
            if (!lvt_3_1_.getAttribute().getShouldWatch()) continue;
            lvt_1_1_.add(lvt_3_1_);
        }
        return lvt_1_1_;
    }

    @Override
    public /* synthetic */ IAttributeInstance getAttributeInstanceByName(String p_getAttributeInstanceByName_1_) {
        return this.getAttributeInstanceByName(p_getAttributeInstanceByName_1_);
    }

    @Override
    public /* synthetic */ IAttributeInstance getAttributeInstance(IAttribute p_getAttributeInstance_1_) {
        return this.getAttributeInstance(p_getAttributeInstance_1_);
    }
}

