/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModifiableAttributeInstance
implements IAttributeInstance {
    private final AbstractAttributeMap attributeMap;
    private final IAttribute genericAttribute;
    private final Map<Integer, Set<AttributeModifier>> mapByOperation = Maps.newHashMap();
    private final Map<String, Set<AttributeModifier>> mapByName = Maps.newHashMap();
    private final Map<UUID, AttributeModifier> mapByUUID = Maps.newHashMap();
    private double baseValue;
    private boolean needsUpdate = true;
    private double cachedValue;

    public ModifiableAttributeInstance(AbstractAttributeMap p_i1608_1_, IAttribute p_i1608_2_) {
        this.attributeMap = p_i1608_1_;
        this.genericAttribute = p_i1608_2_;
        this.baseValue = p_i1608_2_.getDefaultValue();
        for (int lvt_3_1_ = 0; lvt_3_1_ < 3; ++lvt_3_1_) {
            this.mapByOperation.put(lvt_3_1_, Sets.newHashSet());
        }
    }

    @Override
    public IAttribute getAttribute() {
        return this.genericAttribute;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public void setBaseValue(double p_setBaseValue_1_) {
        if (p_setBaseValue_1_ == this.getBaseValue()) {
            return;
        }
        this.baseValue = p_setBaseValue_1_;
        this.flagForUpdate();
    }

    @Override
    public Collection<AttributeModifier> getModifiersByOperation(int p_getModifiersByOperation_1_) {
        return this.mapByOperation.get(p_getModifiersByOperation_1_);
    }

    @Override
    public Collection<AttributeModifier> getModifiers() {
        HashSet lvt_1_1_ = Sets.newHashSet();
        for (int lvt_2_1_ = 0; lvt_2_1_ < 3; ++lvt_2_1_) {
            lvt_1_1_.addAll(this.getModifiersByOperation(lvt_2_1_));
        }
        return lvt_1_1_;
    }

    @Override
    @Nullable
    public AttributeModifier getModifier(UUID p_getModifier_1_) {
        return this.mapByUUID.get(p_getModifier_1_);
    }

    @Override
    public boolean hasModifier(AttributeModifier p_hasModifier_1_) {
        return this.mapByUUID.get(p_hasModifier_1_.getID()) != null;
    }

    @Override
    public void applyModifier(AttributeModifier p_applyModifier_1_) {
        if (this.getModifier(p_applyModifier_1_.getID()) != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        HashSet lvt_2_1_ = this.mapByName.get(p_applyModifier_1_.getName());
        if (lvt_2_1_ == null) {
            lvt_2_1_ = Sets.newHashSet();
            this.mapByName.put(p_applyModifier_1_.getName(), lvt_2_1_);
        }
        this.mapByOperation.get(p_applyModifier_1_.getOperation()).add(p_applyModifier_1_);
        lvt_2_1_.add(p_applyModifier_1_);
        this.mapByUUID.put(p_applyModifier_1_.getID(), p_applyModifier_1_);
        this.flagForUpdate();
    }

    protected void flagForUpdate() {
        this.needsUpdate = true;
        this.attributeMap.onAttributeModified(this);
    }

    @Override
    public void removeModifier(AttributeModifier p_removeModifier_1_) {
        for (int lvt_2_1_ = 0; lvt_2_1_ < 3; ++lvt_2_1_) {
            Set<AttributeModifier> lvt_3_1_ = this.mapByOperation.get(lvt_2_1_);
            lvt_3_1_.remove(p_removeModifier_1_);
        }
        Set<AttributeModifier> lvt_2_2_ = this.mapByName.get(p_removeModifier_1_.getName());
        if (lvt_2_2_ != null) {
            lvt_2_2_.remove(p_removeModifier_1_);
            if (lvt_2_2_.isEmpty()) {
                this.mapByName.remove(p_removeModifier_1_.getName());
            }
        }
        this.mapByUUID.remove(p_removeModifier_1_.getID());
        this.flagForUpdate();
    }

    @Override
    public void removeModifier(UUID p_removeModifier_1_) {
        AttributeModifier lvt_2_1_ = this.getModifier(p_removeModifier_1_);
        if (lvt_2_1_ != null) {
            this.removeModifier(lvt_2_1_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void removeAllModifiers() {
        ArrayList lvt_1_1_ = this.getModifiers();
        if (lvt_1_1_ == null) {
            return;
        }
        lvt_1_1_ = Lists.newArrayList(lvt_1_1_);
        for (AttributeModifier lvt_3_1_ : lvt_1_1_) {
            this.removeModifier(lvt_3_1_);
        }
    }

    @Override
    public double getAttributeValue() {
        if (this.needsUpdate) {
            this.cachedValue = this.computeValue();
            this.needsUpdate = false;
        }
        return this.cachedValue;
    }

    private double computeValue() {
        double lvt_1_1_ = this.getBaseValue();
        for (AttributeModifier lvt_4_1_ : this.getAppliedModifiers(0)) {
            lvt_1_1_ += lvt_4_1_.getAmount();
        }
        double lvt_3_1_ = lvt_1_1_;
        for (AttributeModifier lvt_6_1_ : this.getAppliedModifiers(1)) {
            lvt_3_1_ += lvt_1_1_ * lvt_6_1_.getAmount();
        }
        for (AttributeModifier lvt_6_2_ : this.getAppliedModifiers(2)) {
            lvt_3_1_ *= 1.0 + lvt_6_2_.getAmount();
        }
        return this.genericAttribute.clampValue(lvt_3_1_);
    }

    private Collection<AttributeModifier> getAppliedModifiers(int p_getAppliedModifiers_1_) {
        HashSet lvt_2_1_ = Sets.newHashSet(this.getModifiersByOperation(p_getAppliedModifiers_1_));
        for (IAttribute lvt_3_1_ = this.genericAttribute.getParent(); lvt_3_1_ != null; lvt_3_1_ = lvt_3_1_.getParent()) {
            IAttributeInstance lvt_4_1_ = this.attributeMap.getAttributeInstance(lvt_3_1_);
            if (lvt_4_1_ == null) continue;
            lvt_2_1_.addAll(lvt_4_1_.getModifiersByOperation(p_getAppliedModifiers_1_));
        }
        return lvt_2_1_;
    }
}

