/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWither
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.createKey(EntityWither.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.createKey(EntityWither.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.createKey(EntityWither.class, DataSerializers.VARINT);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.createKey(EntityWither.class, DataSerializers.VARINT);
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int blockBreakCounter;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.getDisplayName(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).setDarkenSky(true);
    private static final Predicate<Entity> NOT_UNDEAD = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_apply_1_).getCreatureAttribute() != EnumCreatureAttribute.UNDEAD && ((EntityLivingBase)p_apply_1_).attackable();
        }
    };

    public EntityWither(World p_i1701_1_) {
        super(p_i1701_1_);
        this.setHealth(this.getMaxHealth());
        this.setSize(0.9f, 3.5f);
        this.isImmuneToFire = true;
        ((PathNavigateGround)this.getNavigator()).setCanSwim(true);
        this.experienceValue = 50;
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(0, new AIDoNothing());
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, new EntityAIAttackRanged(this, 1.0, 40, 20.0f));
        this.tasks.addTask(5, new EntityAIWanderAvoidWater(this, 1.0));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<Entity>(this, EntityLiving.class, 0, false, false, NOT_UNDEAD));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(FIRST_HEAD_TARGET, 0);
        this.dataManager.register(SECOND_HEAD_TARGET, 0);
        this.dataManager.register(THIRD_HEAD_TARGET, 0);
        this.dataManager.register(INVULNERABILITY_TIME, 0);
    }

    public static void registerFixesWither(DataFixer p_registerFixesWither_0_) {
        EntityLiving.registerFixesMob(p_registerFixesWither_0_, EntityWither.class);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("Invul", this.getInvulTime());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setInvulTime(p_readEntityFromNBT_1_.getInteger("Invul"));
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    @Override
    public void setCustomNameTag(String p_setCustomNameTag_1_) {
        super.setCustomNameTag(p_setCustomNameTag_1_);
        this.bossInfo.setName(this.getDisplayName());
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_WITHER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_WITHER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITHER_DEATH;
    }

    @Override
    public void onLivingUpdate() {
        Entity entity;
        this.motionY *= (double)0.6f;
        if (!this.world.isRemote && this.getWatchedTargetId(0) > 0 && (entity = this.world.getEntityByID(this.getWatchedTargetId(0))) != null) {
            double d1;
            double d0;
            double d3;
            if (this.posY < entity.posY || !this.isArmored() && this.posY < entity.posY + 5.0) {
                if (this.motionY < 0.0) {
                    this.motionY = 0.0;
                }
                this.motionY += (0.5 - this.motionY) * (double)0.6f;
            }
            if ((d3 = (d0 = entity.posX - this.posX) * d0 + (d1 = entity.posZ - this.posZ) * d1) > 9.0) {
                double d5 = MathHelper.sqrt(d3);
                this.motionX += (d0 / d5 * 0.5 - this.motionX) * (double)0.6f;
                this.motionZ += (d1 / d5 * 0.5 - this.motionZ) * (double)0.6f;
            }
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > (double)0.05f) {
            this.rotationYaw = (float)MathHelper.atan2(this.motionZ, this.motionX) * 57.295776f - 90.0f;
        }
        super.onLivingUpdate();
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getWatchedTargetId(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.world.getEntityByID(k);
            }
            if (entity1 != null) {
                double d11 = this.getHeadX(j + 1);
                double d12 = this.getHeadY(j + 1);
                double d13 = this.getHeadZ(j + 1);
                double d6 = entity1.posX - d11;
                double d7 = entity1.posY + (double)entity1.getEyeHeight() - d12;
                double d8 = entity1.posZ - d13;
                double d9 = MathHelper.sqrt(d6 * d6 + d8 * d8);
                float f = (float)(MathHelper.atan2(d8, d6) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.atan2(d7, d9) * 57.29577951308232));
                this.xRotationHeads[j] = this.rotlerp(this.xRotationHeads[j], f1, 40.0f);
                this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], f, 10.0f);
                continue;
            }
            this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], this.renderYawOffset, 10.0f);
        }
        boolean flag = this.isArmored();
        for (int l = 0; l < 3; ++l) {
            double d10 = this.getHeadX(l);
            double d2 = this.getHeadY(l);
            double d4 = this.getHeadZ(l);
            this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d10 + this.rand.nextGaussian() * (double)0.3f, d2 + this.rand.nextGaussian() * (double)0.3f, d4 + this.rand.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
            if (!flag || this.world.rand.nextInt(4) != 0) continue;
            this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, d10 + this.rand.nextGaussian() * (double)0.3f, d2 + this.rand.nextGaussian() * (double)0.3f, d4 + this.rand.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + this.rand.nextGaussian(), this.posY + (double)(this.rand.nextFloat() * 3.3f), this.posZ + this.rand.nextGaussian(), (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
    }

    @Override
    protected void updateAITasks() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.world.newExplosion(this, this.posX, this.posY + (double)this.getEyeHeight(), this.posZ, 7.0f, false, this.world.getGameRules().getBoolean("mobGriefing"));
                this.world.playBroadcastSound(1023, new BlockPos(this), 0);
            }
            this.setInvulTime(j1);
            if (this.ticksExisted % 10 == 0) {
                this.heal(10.0f);
            }
        } else {
            super.updateAITasks();
            block0: for (int i = 1; i < 3; ++i) {
                int k1;
                if (this.ticksExisted < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.ticksExisted + 10 + this.rand.nextInt(10);
                if (this.world.getDifficulty() == EnumDifficulty.NORMAL || this.world.getDifficulty() == EnumDifficulty.HARD) {
                    int j3 = i - 1;
                    int k3 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[j3] = this.idleHeadUpdates[i - 1] + 1;
                    if (k3 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.nextDouble(this.rand, this.posX - 10.0, this.posX + 10.0);
                        double d1 = MathHelper.nextDouble(this.rand, this.posY - 5.0, this.posY + 5.0);
                        double d2 = MathHelper.nextDouble(this.rand, this.posZ - 10.0, this.posZ + 10.0);
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((k1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.world.getEntityByID(k1);
                    if (entity != null && entity.isEntityAlive() && this.getDistanceSqToEntity(entity) <= 900.0 && this.canEntityBeSeen(entity)) {
                        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.disableDamage) {
                            this.updateWatchedTargetId(i, 0);
                            continue;
                        }
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.nextHeadUpdate[i - 1] = this.ticksExisted + 40 + this.rand.nextInt(20);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List<EntityLivingBase> list = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expand(20.0, 8.0, 20.0), Predicates.and(NOT_UNDEAD, EntitySelectors.NOT_SPECTATING));
                for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                    EntityLivingBase entitylivingbase = list.get(this.rand.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.isEntityAlive() && this.canEntityBeSeen(entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).capabilities.disableDamage) continue block0;
                            this.updateWatchedTargetId(i, entitylivingbase.getEntityId());
                            continue block0;
                        }
                        this.updateWatchedTargetId(i, entitylivingbase.getEntityId());
                        continue block0;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.getAttackTarget() != null) {
                this.updateWatchedTargetId(0, this.getAttackTarget().getEntityId());
            } else {
                this.updateWatchedTargetId(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.world.getGameRules().getBoolean("mobGriefing")) {
                    int i1 = MathHelper.floor(this.posY);
                    int l1 = MathHelper.floor(this.posX);
                    int i2 = MathHelper.floor(this.posZ);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i1 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.world.getBlockState(blockpos);
                                Block block = iblockstate.getBlock();
                                if (block.isAir(iblockstate, this.world, blockpos) || !block.canEntityDestroy(iblockstate, this.world, blockpos, this)) continue;
                                flag = this.world.destroyBlock(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.world.playEvent(null, 1022, new BlockPos(this), 0);
                    }
                }
            }
            if (this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
        }
    }

    public static boolean canDestroyBlock(Block p_canDestroyBlock_0_) {
        return p_canDestroyBlock_0_ != Blocks.BEDROCK && p_canDestroyBlock_0_ != Blocks.END_PORTAL && p_canDestroyBlock_0_ != Blocks.END_PORTAL_FRAME && p_canDestroyBlock_0_ != Blocks.COMMAND_BLOCK && p_canDestroyBlock_0_ != Blocks.REPEATING_COMMAND_BLOCK && p_canDestroyBlock_0_ != Blocks.CHAIN_COMMAND_BLOCK && p_canDestroyBlock_0_ != Blocks.BARRIER && p_canDestroyBlock_0_ != Blocks.STRUCTURE_BLOCK && p_canDestroyBlock_0_ != Blocks.STRUCTURE_VOID;
    }

    public void ignite() {
        this.setInvulTime(220);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void setInWeb() {
    }

    @Override
    public void addTrackingPlayer(EntityPlayerMP p_addTrackingPlayer_1_) {
        super.addTrackingPlayer(p_addTrackingPlayer_1_);
        this.bossInfo.addPlayer(p_addTrackingPlayer_1_);
    }

    @Override
    public void removeTrackingPlayer(EntityPlayerMP p_removeTrackingPlayer_1_) {
        super.removeTrackingPlayer(p_removeTrackingPlayer_1_);
        this.bossInfo.removePlayer(p_removeTrackingPlayer_1_);
    }

    private double getHeadX(int p_getHeadX_1_) {
        if (p_getHeadX_1_ <= 0) {
            return this.posX;
        }
        float f = (this.renderYawOffset + (float)(180 * (p_getHeadX_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.cos(f);
        return this.posX + (double)f1 * 1.3;
    }

    private double getHeadY(int p_getHeadY_1_) {
        return p_getHeadY_1_ <= 0 ? this.posY + 3.0 : this.posY + 2.2;
    }

    private double getHeadZ(int p_getHeadZ_1_) {
        if (p_getHeadZ_1_ <= 0) {
            return this.posZ;
        }
        float f = (this.renderYawOffset + (float)(180 * (p_getHeadZ_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.sin(f);
        return this.posZ + (double)f1 * 1.3;
    }

    private float rotlerp(float p_rotlerp_1_, float p_rotlerp_2_, float p_rotlerp_3_) {
        float f = MathHelper.wrapDegrees(p_rotlerp_2_ - p_rotlerp_1_);
        if (f > p_rotlerp_3_) {
            f = p_rotlerp_3_;
        }
        if (f < -p_rotlerp_3_) {
            f = -p_rotlerp_3_;
        }
        return p_rotlerp_1_ + f;
    }

    private void launchWitherSkullToEntity(int p_launchWitherSkullToEntity_1_, EntityLivingBase p_launchWitherSkullToEntity_2_) {
        this.launchWitherSkullToCoords(p_launchWitherSkullToEntity_1_, p_launchWitherSkullToEntity_2_.posX, p_launchWitherSkullToEntity_2_.posY + (double)p_launchWitherSkullToEntity_2_.getEyeHeight() * 0.5, p_launchWitherSkullToEntity_2_.posZ, p_launchWitherSkullToEntity_1_ == 0 && this.rand.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_launchWitherSkullToCoords_1_, double p_launchWitherSkullToCoords_2_, double p_launchWitherSkullToCoords_4_, double p_launchWitherSkullToCoords_6_, boolean p_launchWitherSkullToCoords_8_) {
        this.world.playEvent(null, 1024, new BlockPos(this), 0);
        double d0 = this.getHeadX(p_launchWitherSkullToCoords_1_);
        double d1 = this.getHeadY(p_launchWitherSkullToCoords_1_);
        double d2 = this.getHeadZ(p_launchWitherSkullToCoords_1_);
        double d3 = p_launchWitherSkullToCoords_2_ - d0;
        double d4 = p_launchWitherSkullToCoords_4_ - d1;
        double d5 = p_launchWitherSkullToCoords_6_ - d2;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.world, this, d3, d4, d5);
        if (p_launchWitherSkullToCoords_8_) {
            entitywitherskull.setInvulnerable(true);
        }
        entitywitherskull.posY = d1;
        entitywitherskull.posX = d0;
        entitywitherskull.posZ = d2;
        this.world.spawnEntity(entitywitherskull);
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase p_attackEntityWithRangedAttack_1_, float p_attackEntityWithRangedAttack_2_) {
        this.launchWitherSkullToEntity(0, p_attackEntityWithRangedAttack_1_);
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (p_attackEntityFrom_1_ != DamageSource.DROWN && !(p_attackEntityFrom_1_.getEntity() instanceof EntityWither)) {
            Entity entity;
            if (this.getInvulTime() > 0 && p_attackEntityFrom_1_ != DamageSource.OUT_OF_WORLD) {
                return false;
            }
            if (this.isArmored() && (entity = p_attackEntityFrom_1_.getSourceOfDamage()) instanceof EntityArrow) {
                return false;
            }
            Entity entity1 = p_attackEntityFrom_1_.getEntity();
            if (entity1 != null && !(entity1 instanceof EntityPlayer) && entity1 instanceof EntityLivingBase && ((EntityLivingBase)entity1).getCreatureAttribute() == this.getCreatureAttribute()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
        }
        return false;
    }

    @Override
    protected void dropFewItems(boolean p_dropFewItems_1_, int p_dropFewItems_2_) {
        EntityItem entityitem = this.dropItem(Items.NETHER_STAR, 1);
        if (entityitem != null) {
            entityitem.setNoDespawn();
        }
        if (!this.world.isRemote) {
            for (EntityPlayer entityplayer : this.world.getEntitiesWithinAABB(EntityPlayer.class, this.getEntityBoundingBox().expand(50.0, 100.0, 50.0))) {
                entityplayer.addStat(AchievementList.KILL_WITHER);
            }
        }
    }

    @Override
    protected void despawnEntity() {
        this.entityAge = 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
    }

    @Override
    public void addPotionEffect(PotionEffect p_addPotionEffect_1_) {
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(300.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.6f);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.ARMOR).setBaseValue(4.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadYRotation(int p_getHeadYRotation_1_) {
        return this.yRotationHeads[p_getHeadYRotation_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadXRotation(int p_getHeadXRotation_1_) {
        return this.xRotationHeads[p_getHeadXRotation_1_];
    }

    public int getInvulTime() {
        return this.dataManager.get(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int p_setInvulTime_1_) {
        this.dataManager.set(INVULNERABILITY_TIME, p_setInvulTime_1_);
    }

    public int getWatchedTargetId(int p_getWatchedTargetId_1_) {
        return this.dataManager.get(HEAD_TARGETS[p_getWatchedTargetId_1_]);
    }

    public void updateWatchedTargetId(int p_updateWatchedTargetId_1_, int p_updateWatchedTargetId_2_) {
        this.dataManager.set(HEAD_TARGETS[p_updateWatchedTargetId_1_], p_updateWatchedTargetId_2_);
    }

    public boolean isArmored() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected boolean canBeRidden(Entity p_canBeRidden_1_) {
        return false;
    }

    @Override
    public boolean isNonBoss() {
        return false;
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.setMutexBits(7);
        }

        @Override
        public boolean shouldExecute() {
            return EntityWither.this.getInvulTime() > 0;
        }
    }
}

