/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import javax.annotation.Nullable;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseDying
extends PhaseBase {
    private Vec3d targetLocation;
    private int time;

    public PhaseDying(EntityDragon p_i46792_1_) {
        super(p_i46792_1_);
    }

    @Override
    public void doClientRenderEffects() {
        if (this.time++ % 10 == 0) {
            float lvt_1_1_ = (this.dragon.getRNG().nextFloat() - 0.5f) * 8.0f;
            float lvt_2_1_ = (this.dragon.getRNG().nextFloat() - 0.5f) * 4.0f;
            float lvt_3_1_ = (this.dragon.getRNG().nextFloat() - 0.5f) * 8.0f;
            this.dragon.world.spawnParticle(EnumParticleTypes.EXPLOSION_HUGE, this.dragon.posX + (double)lvt_1_1_, this.dragon.posY + 2.0 + (double)lvt_2_1_, this.dragon.posZ + (double)lvt_3_1_, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void doLocalUpdate() {
        double lvt_1_2_;
        ++this.time;
        if (this.targetLocation == null) {
            BlockPos lvt_1_1_ = this.dragon.world.getHeight(WorldGenEndPodium.END_PODIUM_LOCATION);
            this.targetLocation = new Vec3d(lvt_1_1_.getX(), lvt_1_1_.getY(), lvt_1_1_.getZ());
        }
        if ((lvt_1_2_ = this.targetLocation.squareDistanceTo(this.dragon.posX, this.dragon.posY, this.dragon.posZ)) < 100.0 || lvt_1_2_ > 22500.0 || this.dragon.isCollidedHorizontally || this.dragon.isCollidedVertically) {
            this.dragon.setHealth(0.0f);
        } else {
            this.dragon.setHealth(1.0f);
        }
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.time = 0;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseList<PhaseDying> getPhaseList() {
        return PhaseList.DYING;
    }
}

