/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import javax.annotation.Nullable;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseHoldingPattern
extends PhaseBase {
    private Path currentPath;
    private Vec3d targetLocation;
    private boolean clockwise;

    public PhaseHoldingPattern(EntityDragon p_i46791_1_) {
        super(p_i46791_1_);
    }

    public PhaseList<PhaseHoldingPattern> getPhaseList() {
        return PhaseList.HOLDING_PATTERN;
    }

    @Override
    public void doLocalUpdate() {
        double lvt_1_1_;
        double d = lvt_1_1_ = this.targetLocation == null ? 0.0 : this.targetLocation.squareDistanceTo(this.dragon.posX, this.dragon.posY, this.dragon.posZ);
        if (lvt_1_1_ < 100.0 || lvt_1_1_ > 22500.0 || this.dragon.isCollidedHorizontally || this.dragon.isCollidedVertically) {
            this.findNewTarget();
        }
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        if (this.currentPath != null && this.currentPath.isFinished()) {
            int lvt_2_1_;
            BlockPos lvt_1_1_ = this.dragon.world.getTopSolidOrLiquidBlock(new BlockPos(WorldGenEndPodium.END_PODIUM_LOCATION));
            int n = lvt_2_1_ = this.dragon.getFightManager() == null ? 0 : this.dragon.getFightManager().getNumAliveCrystals();
            if (this.dragon.getRNG().nextInt(lvt_2_1_ + 3) == 0) {
                this.dragon.getPhaseManager().setPhase(PhaseList.LANDING_APPROACH);
                return;
            }
            double lvt_3_1_ = 64.0;
            EntityPlayer lvt_5_1_ = this.dragon.world.getNearestAttackablePlayer(lvt_1_1_, lvt_3_1_, lvt_3_1_);
            if (lvt_5_1_ != null) {
                lvt_3_1_ = lvt_5_1_.getDistanceSqToCenter(lvt_1_1_) / 512.0;
            }
            if (lvt_5_1_ != null && (this.dragon.getRNG().nextInt(MathHelper.abs((int)lvt_3_1_) + 2) == 0 || this.dragon.getRNG().nextInt(lvt_2_1_ + 2) == 0)) {
                this.strafePlayer(lvt_5_1_);
                return;
            }
        }
        if (this.currentPath == null || this.currentPath.isFinished()) {
            int lvt_1_2_;
            int lvt_2_2_ = lvt_1_2_ = this.dragon.initPathPoints();
            if (this.dragon.getRNG().nextInt(8) == 0) {
                this.clockwise = !this.clockwise;
                lvt_2_2_ += 6;
            }
            lvt_2_2_ = this.clockwise ? ++lvt_2_2_ : --lvt_2_2_;
            if (this.dragon.getFightManager() == null || this.dragon.getFightManager().getNumAliveCrystals() < 0) {
                lvt_2_2_ -= 12;
                lvt_2_2_ &= 7;
                lvt_2_2_ += 12;
            } else if ((lvt_2_2_ %= 12) < 0) {
                lvt_2_2_ += 12;
            }
            this.currentPath = this.dragon.findPath(lvt_1_2_, lvt_2_2_, null);
            if (this.currentPath != null) {
                this.currentPath.incrementPathIndex();
            }
        }
        this.navigateToNextPathNode();
    }

    private void strafePlayer(EntityPlayer p_strafePlayer_1_) {
        this.dragon.getPhaseManager().setPhase(PhaseList.STRAFE_PLAYER);
        this.dragon.getPhaseManager().getPhase(PhaseList.STRAFE_PLAYER).setTarget(p_strafePlayer_1_);
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isFinished()) {
            double lvt_6_1_;
            Vec3d lvt_1_1_ = this.currentPath.getCurrentPos();
            this.currentPath.incrementPathIndex();
            double lvt_2_1_ = lvt_1_1_.xCoord;
            double lvt_4_1_ = lvt_1_1_.zCoord;
            while ((lvt_6_1_ = lvt_1_1_.yCoord + (double)(this.dragon.getRNG().nextFloat() * 20.0f)) < lvt_1_1_.yCoord) {
            }
            this.targetLocation = new Vec3d(lvt_2_1_, lvt_6_1_, lvt_4_1_);
        }
    }

    @Override
    public void onCrystalDestroyed(EntityEnderCrystal p_onCrystalDestroyed_1_, BlockPos p_onCrystalDestroyed_2_, DamageSource p_onCrystalDestroyed_3_, EntityPlayer p_onCrystalDestroyed_4_) {
        if (p_onCrystalDestroyed_4_ != null && !p_onCrystalDestroyed_4_.capabilities.disableDamage) {
            this.strafePlayer(p_onCrystalDestroyed_4_);
        }
    }
}

