/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import javax.annotation.Nullable;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseLanding
extends PhaseBase {
    private Vec3d targetLocation;

    public PhaseLanding(EntityDragon p_i46788_1_) {
        super(p_i46788_1_);
    }

    @Override
    public void doClientRenderEffects() {
        Vec3d lvt_1_1_ = this.dragon.getHeadLookVec(1.0f).normalize();
        lvt_1_1_.rotateYaw(-0.7853982f);
        double lvt_2_1_ = this.dragon.dragonPartHead.posX;
        double lvt_4_1_ = this.dragon.dragonPartHead.posY + (double)(this.dragon.dragonPartHead.height / 2.0f);
        double lvt_6_1_ = this.dragon.dragonPartHead.posZ;
        for (int lvt_8_1_ = 0; lvt_8_1_ < 8; ++lvt_8_1_) {
            double lvt_9_1_ = lvt_2_1_ + this.dragon.getRNG().nextGaussian() / 2.0;
            double lvt_11_1_ = lvt_4_1_ + this.dragon.getRNG().nextGaussian() / 2.0;
            double lvt_13_1_ = lvt_6_1_ + this.dragon.getRNG().nextGaussian() / 2.0;
            this.dragon.world.spawnParticle(EnumParticleTypes.DRAGON_BREATH, lvt_9_1_, lvt_11_1_, lvt_13_1_, -lvt_1_1_.xCoord * (double)0.08f + this.dragon.motionX, -lvt_1_1_.yCoord * (double)0.3f + this.dragon.motionY, -lvt_1_1_.zCoord * (double)0.08f + this.dragon.motionZ, new int[0]);
            lvt_1_1_.rotateYaw(0.19634955f);
        }
    }

    @Override
    public void doLocalUpdate() {
        if (this.targetLocation == null) {
            this.targetLocation = new Vec3d(this.dragon.world.getTopSolidOrLiquidBlock(WorldGenEndPodium.END_PODIUM_LOCATION));
        }
        if (this.targetLocation.squareDistanceTo(this.dragon.posX, this.dragon.posY, this.dragon.posZ) < 1.0) {
            this.dragon.getPhaseManager().getPhase(PhaseList.SITTING_FLAMING).resetFlameCount();
            this.dragon.getPhaseManager().setPhase(PhaseList.SITTING_SCANNING);
        }
    }

    @Override
    public float getMaxRiseOrFall() {
        return 1.5f;
    }

    @Override
    public float getYawFactor() {
        float lvt_1_1_ = MathHelper.sqrt(this.dragon.motionX * this.dragon.motionX + this.dragon.motionZ * this.dragon.motionZ) + 1.0f;
        float lvt_2_1_ = Math.min(lvt_1_1_, 40.0f);
        return lvt_2_1_ / lvt_1_1_;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseList<PhaseLanding> getPhaseList() {
        return PhaseList.LANDING;
    }
}

