/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import javax.annotation.Nullable;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseLandingApproach
extends PhaseBase {
    private Path currentPath;
    private Vec3d targetLocation;

    public PhaseLandingApproach(EntityDragon p_i46789_1_) {
        super(p_i46789_1_);
    }

    public PhaseList<PhaseLandingApproach> getPhaseList() {
        return PhaseList.LANDING_APPROACH;
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    public void doLocalUpdate() {
        double lvt_1_1_;
        double d = lvt_1_1_ = this.targetLocation == null ? 0.0 : this.targetLocation.squareDistanceTo(this.dragon.posX, this.dragon.posY, this.dragon.posZ);
        if (lvt_1_1_ < 100.0 || lvt_1_1_ > 22500.0 || this.dragon.isCollidedHorizontally || this.dragon.isCollidedVertically) {
            this.findNewTarget();
        }
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.isFinished()) {
            int lvt_4_2_;
            int lvt_1_1_ = this.dragon.initPathPoints();
            BlockPos lvt_2_1_ = this.dragon.world.getTopSolidOrLiquidBlock(WorldGenEndPodium.END_PODIUM_LOCATION);
            EntityPlayer lvt_3_1_ = this.dragon.world.getNearestAttackablePlayer(lvt_2_1_, 128.0, 128.0);
            if (lvt_3_1_ != null) {
                Vec3d lvt_5_1_ = new Vec3d(lvt_3_1_.posX, 0.0, lvt_3_1_.posZ).normalize();
                int lvt_4_1_ = this.dragon.getNearestPpIdx(-lvt_5_1_.xCoord * 40.0, 105.0, -lvt_5_1_.zCoord * 40.0);
            } else {
                lvt_4_2_ = this.dragon.getNearestPpIdx(40.0, lvt_2_1_.getY(), 0.0);
            }
            PathPoint lvt_5_2_ = new PathPoint(lvt_2_1_.getX(), lvt_2_1_.getY(), lvt_2_1_.getZ());
            this.currentPath = this.dragon.findPath(lvt_1_1_, lvt_4_2_, lvt_5_2_);
            if (this.currentPath != null) {
                this.currentPath.incrementPathIndex();
            }
        }
        this.navigateToNextPathNode();
        if (this.currentPath != null && this.currentPath.isFinished()) {
            this.dragon.getPhaseManager().setPhase(PhaseList.LANDING);
        }
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isFinished()) {
            double lvt_6_1_;
            Vec3d lvt_1_1_ = this.currentPath.getCurrentPos();
            this.currentPath.incrementPathIndex();
            double lvt_2_1_ = lvt_1_1_.xCoord;
            double lvt_4_1_ = lvt_1_1_.zCoord;
            while ((lvt_6_1_ = lvt_1_1_.yCoord + (double)(this.dragon.getRNG().nextFloat() * 20.0f)) < lvt_1_1_.yCoord) {
            }
            this.targetLocation = new Vec3d(lvt_2_1_, lvt_6_1_, lvt_4_1_);
        }
    }
}

