/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseChargingPlayer;
import net.minecraft.entity.boss.dragon.phase.PhaseDying;
import net.minecraft.entity.boss.dragon.phase.PhaseHoldingPattern;
import net.minecraft.entity.boss.dragon.phase.PhaseHover;
import net.minecraft.entity.boss.dragon.phase.PhaseLanding;
import net.minecraft.entity.boss.dragon.phase.PhaseLandingApproach;
import net.minecraft.entity.boss.dragon.phase.PhaseSittingAttacking;
import net.minecraft.entity.boss.dragon.phase.PhaseSittingFlaming;
import net.minecraft.entity.boss.dragon.phase.PhaseSittingScanning;
import net.minecraft.entity.boss.dragon.phase.PhaseStrafePlayer;
import net.minecraft.entity.boss.dragon.phase.PhaseTakeoff;

public class PhaseList<T extends IPhase> {
    private static PhaseList<?>[] phases = new PhaseList[0];
    public static final PhaseList<PhaseHoldingPattern> HOLDING_PATTERN = PhaseList.create(PhaseHoldingPattern.class, "HoldingPattern");
    public static final PhaseList<PhaseStrafePlayer> STRAFE_PLAYER = PhaseList.create(PhaseStrafePlayer.class, "StrafePlayer");
    public static final PhaseList<PhaseLandingApproach> LANDING_APPROACH = PhaseList.create(PhaseLandingApproach.class, "LandingApproach");
    public static final PhaseList<PhaseLanding> LANDING = PhaseList.create(PhaseLanding.class, "Landing");
    public static final PhaseList<PhaseTakeoff> TAKEOFF = PhaseList.create(PhaseTakeoff.class, "Takeoff");
    public static final PhaseList<PhaseSittingFlaming> SITTING_FLAMING = PhaseList.create(PhaseSittingFlaming.class, "SittingFlaming");
    public static final PhaseList<PhaseSittingScanning> SITTING_SCANNING = PhaseList.create(PhaseSittingScanning.class, "SittingScanning");
    public static final PhaseList<PhaseSittingAttacking> SITTING_ATTACKING = PhaseList.create(PhaseSittingAttacking.class, "SittingAttacking");
    public static final PhaseList<PhaseChargingPlayer> CHARGING_PLAYER = PhaseList.create(PhaseChargingPlayer.class, "ChargingPlayer");
    public static final PhaseList<PhaseDying> DYING = PhaseList.create(PhaseDying.class, "Dying");
    public static final PhaseList<PhaseHover> HOVER = PhaseList.create(PhaseHover.class, "Hover");
    private final Class<? extends IPhase> clazz;
    private final int id;
    private final String name;

    private PhaseList(int p_i46782_1_, Class<? extends IPhase> p_i46782_2_, String p_i46782_3_) {
        this.id = p_i46782_1_;
        this.clazz = p_i46782_2_;
        this.name = p_i46782_3_;
    }

    public IPhase createPhase(EntityDragon p_createPhase_1_) {
        try {
            Constructor<IPhase> lvt_2_1_ = this.getConstructor();
            return lvt_2_1_.newInstance(p_createPhase_1_);
        }
        catch (Exception lvt_2_2_) {
            throw new Error(lvt_2_2_);
        }
    }

    protected Constructor<? extends IPhase> getConstructor() throws NoSuchMethodException {
        return this.clazz.getConstructor(EntityDragon.class);
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name + " (#" + this.id + ")";
    }

    public static PhaseList<?> getById(int p_getById_0_) {
        if (p_getById_0_ < 0 || p_getById_0_ >= phases.length) {
            return HOLDING_PATTERN;
        }
        return phases[p_getById_0_];
    }

    public static int getTotalPhases() {
        return phases.length;
    }

    private static <T extends IPhase> PhaseList<T> create(Class<T> p_create_0_, String p_create_1_) {
        PhaseList<T> lvt_2_1_ = new PhaseList<T>(phases.length, p_create_0_, p_create_1_);
        phases = Arrays.copyOf(phases, phases.length + 1);
        PhaseList.phases[lvt_2_1_.getId()] = lvt_2_1_;
        return lvt_2_1_;
    }
}

