/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityDragon dragon;
    private final IPhase[] phases = new IPhase[PhaseList.getTotalPhases()];
    private IPhase phase;

    public PhaseManager(EntityDragon p_i46781_1_) {
        this.dragon = p_i46781_1_;
        this.setPhase(PhaseList.HOVER);
    }

    public void setPhase(PhaseList<?> p_setPhase_1_) {
        if (this.phase != null && p_setPhase_1_ == this.phase.getPhaseList()) {
            return;
        }
        if (this.phase != null) {
            this.phase.removeAreaEffect();
        }
        this.phase = this.getPhase(p_setPhase_1_);
        if (!this.dragon.world.isRemote) {
            this.dragon.getDataManager().set(EntityDragon.PHASE, p_setPhase_1_.getId());
        }
        LOGGER.debug("Dragon is now in phase {} on the {}", new Object[]{p_setPhase_1_, this.dragon.world.isRemote ? "client" : "server"});
        this.phase.initPhase();
    }

    public IPhase getCurrentPhase() {
        return this.phase;
    }

    public <T extends IPhase> T getPhase(PhaseList<T> p_getPhase_1_) {
        int lvt_2_1_ = p_getPhase_1_.getId();
        if (this.phases[lvt_2_1_] == null) {
            this.phases[lvt_2_1_] = p_getPhase_1_.createPhase(this.dragon);
        }
        return (T)this.phases[lvt_2_1_];
    }
}

