/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.boss.dragon.phase.PhaseSittingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class PhaseSittingScanning
extends PhaseSittingBase {
    private int scanningTime;

    public PhaseSittingScanning(EntityDragon p_i46785_1_) {
        super(p_i46785_1_);
    }

    @Override
    public void doLocalUpdate() {
        ++this.scanningTime;
        EntityPlayer lvt_1_1_ = this.dragon.world.getNearestAttackablePlayer(this.dragon, 20.0, 10.0);
        if (lvt_1_1_ != null) {
            if (this.scanningTime > 25) {
                this.dragon.getPhaseManager().setPhase(PhaseList.SITTING_ATTACKING);
            } else {
                Vec3d lvt_2_1_ = new Vec3d(lvt_1_1_.posX - this.dragon.posX, 0.0, lvt_1_1_.posZ - this.dragon.posZ).normalize();
                Vec3d lvt_3_1_ = new Vec3d(MathHelper.sin(this.dragon.rotationYaw * ((float)Math.PI / 180)), 0.0, -MathHelper.cos(this.dragon.rotationYaw * ((float)Math.PI / 180))).normalize();
                float lvt_4_1_ = (float)lvt_3_1_.dotProduct(lvt_2_1_);
                float lvt_5_1_ = (float)(Math.acos(lvt_4_1_) * 57.2957763671875) + 0.5f;
                if (lvt_5_1_ < 0.0f || lvt_5_1_ > 10.0f) {
                    float lvt_12_1_;
                    double lvt_6_1_ = lvt_1_1_.posX - this.dragon.dragonPartHead.posX;
                    double lvt_8_1_ = lvt_1_1_.posZ - this.dragon.dragonPartHead.posZ;
                    double lvt_10_1_ = MathHelper.clamp(MathHelper.wrapDegrees(180.0 - MathHelper.atan2(lvt_6_1_, lvt_8_1_) * 57.2957763671875 - (double)this.dragon.rotationYaw), -100.0, 100.0);
                    this.dragon.randomYawVelocity *= 0.8f;
                    float lvt_13_1_ = lvt_12_1_ = MathHelper.sqrt(lvt_6_1_ * lvt_6_1_ + lvt_8_1_ * lvt_8_1_) + 1.0f;
                    if (lvt_12_1_ > 40.0f) {
                        lvt_12_1_ = 40.0f;
                    }
                    this.dragon.randomYawVelocity = (float)((double)this.dragon.randomYawVelocity + lvt_10_1_ * (double)(0.7f / lvt_12_1_ / lvt_13_1_));
                    this.dragon.rotationYaw += this.dragon.randomYawVelocity;
                }
            }
        } else if (this.scanningTime >= 100) {
            lvt_1_1_ = this.dragon.world.getNearestAttackablePlayer(this.dragon, 150.0, 150.0);
            this.dragon.getPhaseManager().setPhase(PhaseList.TAKEOFF);
            if (lvt_1_1_ != null) {
                this.dragon.getPhaseManager().setPhase(PhaseList.CHARGING_PLAYER);
                this.dragon.getPhaseManager().getPhase(PhaseList.CHARGING_PLAYER).setTarget(new Vec3d(lvt_1_1_.posX, lvt_1_1_.posY, lvt_1_1_.posZ));
            }
        }
    }

    @Override
    public void initPhase() {
        this.scanningTime = 0;
    }

    public PhaseList<PhaseSittingScanning> getPhaseList() {
        return PhaseList.SITTING_SCANNING;
    }
}

