/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseStrafePlayer
extends PhaseBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private int fireballCharge;
    private Path currentPath;
    private Vec3d targetLocation;
    private EntityLivingBase attackTarget;
    private boolean holdingPatternClockwise;

    public PhaseStrafePlayer(EntityDragon p_i46784_1_) {
        super(p_i46784_1_);
    }

    @Override
    public void doLocalUpdate() {
        double lvt_1_2_;
        if (this.attackTarget == null) {
            LOGGER.warn("Skipping player strafe phase because no player was found");
            this.dragon.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
            return;
        }
        if (this.currentPath != null && this.currentPath.isFinished()) {
            double lvt_1_1_ = this.attackTarget.posX;
            double lvt_3_1_ = this.attackTarget.posZ;
            double lvt_5_1_ = lvt_1_1_ - this.dragon.posX;
            double lvt_7_1_ = lvt_3_1_ - this.dragon.posZ;
            double lvt_9_1_ = MathHelper.sqrt(lvt_5_1_ * lvt_5_1_ + lvt_7_1_ * lvt_7_1_);
            double lvt_11_1_ = Math.min((double)0.4f + lvt_9_1_ / 80.0 - 1.0, 10.0);
            this.targetLocation = new Vec3d(lvt_1_1_, this.attackTarget.posY + lvt_11_1_, lvt_3_1_);
        }
        double d = lvt_1_2_ = this.targetLocation == null ? 0.0 : this.targetLocation.squareDistanceTo(this.dragon.posX, this.dragon.posY, this.dragon.posZ);
        if (lvt_1_2_ < 100.0 || lvt_1_2_ > 22500.0) {
            this.findNewTarget();
        }
        double lvt_3_2_ = 64.0;
        if (this.attackTarget.getDistanceSqToEntity(this.dragon) < 4096.0) {
            if (this.dragon.canEntityBeSeen(this.attackTarget)) {
                ++this.fireballCharge;
                Vec3d lvt_5_2_ = new Vec3d(this.attackTarget.posX - this.dragon.posX, 0.0, this.attackTarget.posZ - this.dragon.posZ).normalize();
                Vec3d lvt_6_1_ = new Vec3d(MathHelper.sin(this.dragon.rotationYaw * ((float)Math.PI / 180)), 0.0, -MathHelper.cos(this.dragon.rotationYaw * ((float)Math.PI / 180))).normalize();
                float lvt_7_2_ = (float)lvt_6_1_.dotProduct(lvt_5_2_);
                float lvt_8_1_ = (float)(Math.acos(lvt_7_2_) * 57.2957763671875);
                lvt_8_1_ += 0.5f;
                if (this.fireballCharge >= 5 && lvt_8_1_ >= 0.0f && lvt_8_1_ < 10.0f) {
                    double lvt_9_2_ = 1.0;
                    Vec3d lvt_11_2_ = this.dragon.getLook(1.0f);
                    double lvt_12_1_ = this.dragon.dragonPartHead.posX - lvt_11_2_.xCoord * 1.0;
                    double lvt_14_1_ = this.dragon.dragonPartHead.posY + (double)(this.dragon.dragonPartHead.height / 2.0f) + 0.5;
                    double lvt_16_1_ = this.dragon.dragonPartHead.posZ - lvt_11_2_.zCoord * 1.0;
                    double lvt_18_1_ = this.attackTarget.posX - lvt_12_1_;
                    double lvt_20_1_ = this.attackTarget.posY + (double)(this.attackTarget.height / 2.0f) - (lvt_14_1_ + (double)(this.dragon.dragonPartHead.height / 2.0f));
                    double lvt_22_1_ = this.attackTarget.posZ - lvt_16_1_;
                    this.dragon.world.playEvent(null, 1017, new BlockPos(this.dragon), 0);
                    EntityDragonFireball lvt_24_1_ = new EntityDragonFireball(this.dragon.world, this.dragon, lvt_18_1_, lvt_20_1_, lvt_22_1_);
                    lvt_24_1_.setLocationAndAngles(lvt_12_1_, lvt_14_1_, lvt_16_1_, 0.0f, 0.0f);
                    this.dragon.world.spawnEntity(lvt_24_1_);
                    this.fireballCharge = 0;
                    if (this.currentPath != null) {
                        while (!this.currentPath.isFinished()) {
                            this.currentPath.incrementPathIndex();
                        }
                    }
                    this.dragon.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
                }
            } else if (this.fireballCharge > 0) {
                --this.fireballCharge;
            }
        } else if (this.fireballCharge > 0) {
            --this.fireballCharge;
        }
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.isFinished()) {
            int lvt_1_1_;
            int lvt_2_1_ = lvt_1_1_ = this.dragon.initPathPoints();
            if (this.dragon.getRNG().nextInt(8) == 0) {
                this.holdingPatternClockwise = !this.holdingPatternClockwise;
                lvt_2_1_ += 6;
            }
            lvt_2_1_ = this.holdingPatternClockwise ? ++lvt_2_1_ : --lvt_2_1_;
            if (this.dragon.getFightManager() == null || this.dragon.getFightManager().getNumAliveCrystals() <= 0) {
                lvt_2_1_ -= 12;
                lvt_2_1_ &= 7;
                lvt_2_1_ += 12;
            } else if ((lvt_2_1_ %= 12) < 0) {
                lvt_2_1_ += 12;
            }
            this.currentPath = this.dragon.findPath(lvt_1_1_, lvt_2_1_, null);
            if (this.currentPath != null) {
                this.currentPath.incrementPathIndex();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isFinished()) {
            double lvt_4_1_;
            Vec3d lvt_1_1_ = this.currentPath.getCurrentPos();
            this.currentPath.incrementPathIndex();
            double lvt_2_1_ = lvt_1_1_.xCoord;
            double lvt_6_1_ = lvt_1_1_.zCoord;
            while ((lvt_4_1_ = lvt_1_1_.yCoord + (double)(this.dragon.getRNG().nextFloat() * 20.0f)) < lvt_1_1_.yCoord) {
            }
            this.targetLocation = new Vec3d(lvt_2_1_, lvt_4_1_, lvt_6_1_);
        }
    }

    @Override
    public void initPhase() {
        this.fireballCharge = 0;
        this.targetLocation = null;
        this.currentPath = null;
        this.attackTarget = null;
    }

    public void setTarget(EntityLivingBase p_setTarget_1_) {
        this.attackTarget = p_setTarget_1_;
        int lvt_2_1_ = this.dragon.initPathPoints();
        int lvt_3_1_ = this.dragon.getNearestPpIdx(this.attackTarget.posX, this.attackTarget.posY, this.attackTarget.posZ);
        int lvt_4_1_ = MathHelper.floor(this.attackTarget.posX);
        int lvt_5_1_ = MathHelper.floor(this.attackTarget.posZ);
        double lvt_6_1_ = (double)lvt_4_1_ - this.dragon.posX;
        double lvt_8_1_ = (double)lvt_5_1_ - this.dragon.posZ;
        double lvt_10_1_ = MathHelper.sqrt(lvt_6_1_ * lvt_6_1_ + lvt_8_1_ * lvt_8_1_);
        double lvt_12_1_ = Math.min((double)0.4f + lvt_10_1_ / 80.0 - 1.0, 10.0);
        int lvt_14_1_ = MathHelper.floor(this.attackTarget.posY + lvt_12_1_);
        PathPoint lvt_15_1_ = new PathPoint(lvt_4_1_, lvt_14_1_, lvt_5_1_);
        this.currentPath = this.dragon.findPath(lvt_2_1_, lvt_3_1_, lvt_15_1_);
        if (this.currentPath != null) {
            this.currentPath.incrementPathIndex();
            this.navigateToNextPathNode();
        }
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseList<PhaseStrafePlayer> getPhaseList() {
        return PhaseList.STRAFE_PLAYER;
    }
}

