/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import javax.annotation.Nullable;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseBase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseTakeoff
extends PhaseBase {
    private boolean firstTick;
    private Path currentPath;
    private Vec3d targetLocation;

    public PhaseTakeoff(EntityDragon p_i46783_1_) {
        super(p_i46783_1_);
    }

    @Override
    public void doLocalUpdate() {
        if (this.firstTick || this.currentPath == null) {
            this.firstTick = false;
            this.findNewTarget();
        } else {
            BlockPos lvt_1_1_ = this.dragon.world.getTopSolidOrLiquidBlock(WorldGenEndPodium.END_PODIUM_LOCATION);
            double lvt_2_1_ = this.dragon.getDistanceSqToCenter(lvt_1_1_);
            if (lvt_2_1_ > 100.0) {
                this.dragon.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
            }
        }
    }

    @Override
    public void initPhase() {
        this.firstTick = true;
        this.currentPath = null;
        this.targetLocation = null;
    }

    private void findNewTarget() {
        int lvt_1_1_ = this.dragon.initPathPoints();
        Vec3d lvt_2_1_ = this.dragon.getHeadLookVec(1.0f);
        int lvt_3_1_ = this.dragon.getNearestPpIdx(-lvt_2_1_.xCoord * 40.0, 105.0, -lvt_2_1_.zCoord * 40.0);
        if (this.dragon.getFightManager() == null || this.dragon.getFightManager().getNumAliveCrystals() <= 0) {
            lvt_3_1_ -= 12;
            lvt_3_1_ &= 7;
            lvt_3_1_ += 12;
        } else if ((lvt_3_1_ %= 12) < 0) {
            lvt_3_1_ += 12;
        }
        this.currentPath = this.dragon.findPath(lvt_1_1_, lvt_3_1_, null);
        if (this.currentPath != null) {
            this.currentPath.incrementPathIndex();
            this.navigateToNextPathNode();
        }
    }

    private void navigateToNextPathNode() {
        double lvt_2_1_;
        Vec3d lvt_1_1_ = this.currentPath.getCurrentPos();
        this.currentPath.incrementPathIndex();
        while ((lvt_2_1_ = lvt_1_1_.yCoord + (double)(this.dragon.getRNG().nextFloat() * 20.0f)) < lvt_1_1_.yCoord) {
        }
        this.targetLocation = new Vec3d(lvt_1_1_.xCoord, lvt_2_1_, lvt_1_1_.zCoord);
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseList<PhaseTakeoff> getPhaseList() {
        return PhaseList.TAKEOFF;
    }
}

