/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBoat
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.createKey(EntityBoat.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.createKey(EntityBoat.class, DataSerializers.VARINT);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.createKey(EntityBoat.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.createKey(EntityBoat.class, DataSerializers.VARINT);
    private static final DataParameter<Boolean>[] DATA_ID_PADDLE = new DataParameter[]{EntityDataManager.createKey(EntityBoat.class, DataSerializers.BOOLEAN), EntityDataManager.createKey(EntityBoat.class, DataSerializers.BOOLEAN)};
    private final float[] paddlePositions = new float[2];
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double boatPitch;
    private double lerpY;
    private double lerpZ;
    private double boatYaw;
    private double lerpXRot;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private double waterLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;

    public EntityBoat(World p_i1704_1_) {
        super(p_i1704_1_);
        this.preventEntitySpawning = true;
        this.setSize(1.375f, 0.5625f);
    }

    public EntityBoat(World p_i1705_1_, double p_i1705_2_, double p_i1705_4_, double p_i1705_6_) {
        this(p_i1705_1_);
        this.setPosition(p_i1705_2_, p_i1705_4_, p_i1705_6_);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = p_i1705_2_;
        this.prevPosY = p_i1705_4_;
        this.prevPosZ = p_i1705_6_;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(TIME_SINCE_HIT, 0);
        this.dataManager.register(FORWARD_DIRECTION, 1);
        this.dataManager.register(DAMAGE_TAKEN, Float.valueOf(0.0f));
        this.dataManager.register(BOAT_TYPE, Type.OAK.ordinal());
        for (DataParameter<Boolean> lvt_4_1_ : DATA_ID_PADDLE) {
            this.dataManager.register(lvt_4_1_, false);
        }
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBox(Entity p_getCollisionBox_1_) {
        if (p_getCollisionBox_1_.canBePushed()) {
            return p_getCollisionBox_1_.getEntityBoundingBox();
        }
        return null;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.getEntityBoundingBox();
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    @Override
    public double getMountedYOffset() {
        return -0.1;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        boolean lvt_3_1_;
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (this.world.isRemote || this.isDead) {
            return true;
        }
        if (p_attackEntityFrom_1_ instanceof EntityDamageSourceIndirect && p_attackEntityFrom_1_.getEntity() != null && this.isPassenger(p_attackEntityFrom_1_.getEntity())) {
            return false;
        }
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() + p_attackEntityFrom_2_ * 10.0f);
        this.setBeenAttacked();
        boolean bl = lvt_3_1_ = p_attackEntityFrom_1_.getEntity() instanceof EntityPlayer && ((EntityPlayer)p_attackEntityFrom_1_.getEntity()).capabilities.isCreativeMode;
        if (lvt_3_1_ || this.getDamageTaken() > 40.0f) {
            if (!lvt_3_1_ && this.world.getGameRules().getBoolean("doEntityDrops")) {
                this.dropItemWithOffset(this.getItemBoat(), 1, 0.0f);
            }
            this.setDead();
        }
        return true;
    }

    @Override
    public void applyEntityCollision(Entity p_applyEntityCollision_1_) {
        if (p_applyEntityCollision_1_ instanceof EntityBoat) {
            if (p_applyEntityCollision_1_.getEntityBoundingBox().minY < this.getEntityBoundingBox().maxY) {
                super.applyEntityCollision(p_applyEntityCollision_1_);
            }
        } else if (p_applyEntityCollision_1_.getEntityBoundingBox().minY <= this.getEntityBoundingBox().minY) {
            super.applyEntityCollision(p_applyEntityCollision_1_);
        }
    }

    public Item getItemBoat() {
        switch (this.getBoatType()) {
            default: {
                return Items.BOAT;
            }
            case SPRUCE: {
                return Items.SPRUCE_BOAT;
            }
            case BIRCH: {
                return Items.BIRCH_BOAT;
            }
            case JUNGLE: {
                return Items.JUNGLE_BOAT;
            }
            case ACACIA: {
                return Items.ACACIA_BOAT;
            }
            case DARK_OAK: 
        }
        return Items.DARK_OAK_BOAT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.boatPitch = p_setPositionAndRotationDirect_1_;
        this.lerpY = p_setPositionAndRotationDirect_3_;
        this.lerpZ = p_setPositionAndRotationDirect_5_;
        this.boatYaw = p_setPositionAndRotationDirect_7_;
        this.lerpXRot = p_setPositionAndRotationDirect_8_;
        this.lerpSteps = 10;
    }

    @Override
    public EnumFacing getAdjustedHorizontalFacing() {
        return this.getHorizontalFacing().rotateY();
    }

    @Override
    public void onUpdate() {
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlTicks = this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER ? (this.outOfControlTicks += 1.0f) : 0.0f;
        if (!this.world.isRemote && this.outOfControlTicks >= 60.0f) {
            this.removePassengers();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        super.onUpdate();
        this.tickLerp();
        if (this.canPassengerSteer()) {
            if (this.getPassengers().size() == 0 || !(this.getPassengers().get(0) instanceof EntityPlayer)) {
                this.setPaddleState(false, false);
            }
            this.updateMotion();
            if (this.world.isRemote) {
                this.controlBoat();
                this.world.sendPacketToServer(new CPacketSteerBoat(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        } else {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
        for (int lvt_1_1_ = 0; lvt_1_1_ <= 1; ++lvt_1_1_) {
            if (this.getPaddleState(lvt_1_1_)) {
                int n = lvt_1_1_;
                this.paddlePositions[n] = (float)((double)this.paddlePositions[n] + 0.01);
                continue;
            }
            this.paddlePositions[lvt_1_1_] = 0.0f;
        }
        this.doBlockCollisions();
        List<Entity> lvt_1_2_ = this.world.getEntitiesInAABBexcluding(this, this.getEntityBoundingBox().expand(0.2f, -0.01f, 0.2f), EntitySelectors.getTeamCollisionPredicate(this));
        if (!lvt_1_2_.isEmpty()) {
            boolean lvt_2_1_ = !this.world.isRemote && !(this.getControllingPassenger() instanceof EntityPlayer);
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_1_2_.size(); ++lvt_3_1_) {
                Entity lvt_4_1_ = lvt_1_2_.get(lvt_3_1_);
                if (lvt_4_1_.isPassenger(this)) continue;
                if (lvt_2_1_ && this.getPassengers().size() < 2 && !lvt_4_1_.isRiding() && lvt_4_1_.width < this.width && lvt_4_1_ instanceof EntityLivingBase && !(lvt_4_1_ instanceof EntityWaterMob) && !(lvt_4_1_ instanceof EntityPlayer)) {
                    lvt_4_1_.startRiding(this);
                    continue;
                }
                this.applyEntityCollision(lvt_4_1_);
            }
        }
    }

    private void tickLerp() {
        if (this.lerpSteps <= 0 || this.canPassengerSteer()) {
            return;
        }
        double lvt_1_1_ = this.posX + (this.boatPitch - this.posX) / (double)this.lerpSteps;
        double lvt_3_1_ = this.posY + (this.lerpY - this.posY) / (double)this.lerpSteps;
        double lvt_5_1_ = this.posZ + (this.lerpZ - this.posZ) / (double)this.lerpSteps;
        double lvt_7_1_ = MathHelper.wrapDegrees(this.boatYaw - (double)this.rotationYaw);
        this.rotationYaw = (float)((double)this.rotationYaw + lvt_7_1_ / (double)this.lerpSteps);
        this.rotationPitch = (float)((double)this.rotationPitch + (this.lerpXRot - (double)this.rotationPitch) / (double)this.lerpSteps);
        --this.lerpSteps;
        this.setPosition(lvt_1_1_, lvt_3_1_, lvt_5_1_);
        this.setRotation(this.rotationYaw, this.rotationPitch);
    }

    public void setPaddleState(boolean p_setPaddleState_1_, boolean p_setPaddleState_2_) {
        this.dataManager.set(DATA_ID_PADDLE[0], p_setPaddleState_1_);
        this.dataManager.set(DATA_ID_PADDLE[1], p_setPaddleState_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public float getRowingTime(int p_getRowingTime_1_, float p_getRowingTime_2_) {
        if (this.getPaddleState(p_getRowingTime_1_)) {
            return (float)MathHelper.clampedLerp((double)this.paddlePositions[p_getRowingTime_1_] - 0.01, this.paddlePositions[p_getRowingTime_1_], p_getRowingTime_2_);
        }
        return 0.0f;
    }

    private Status getBoatStatus() {
        Status lvt_1_1_ = this.getUnderwaterStatus();
        if (lvt_1_1_ != null) {
            this.waterLevel = this.getEntityBoundingBox().maxY;
            return lvt_1_1_;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float lvt_2_1_ = this.getBoatGlide();
        if (lvt_2_1_ > 0.0f) {
            this.boatGlide = lvt_2_1_;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getWaterLevelAbove() {
        AxisAlignedBB lvt_1_1_ = this.getEntityBoundingBox();
        int lvt_2_1_ = MathHelper.floor(lvt_1_1_.minX);
        int lvt_3_1_ = MathHelper.ceil(lvt_1_1_.maxX);
        int lvt_4_1_ = MathHelper.floor(lvt_1_1_.maxY);
        int lvt_5_1_ = MathHelper.ceil(lvt_1_1_.maxY - this.lastYd);
        int lvt_6_1_ = MathHelper.floor(lvt_1_1_.minZ);
        int lvt_7_1_ = MathHelper.ceil(lvt_1_1_.maxZ);
        BlockPos.PooledMutableBlockPos lvt_8_1_ = BlockPos.PooledMutableBlockPos.retain();
        try {
            block4: for (int lvt_9_1_ = lvt_4_1_; lvt_9_1_ < lvt_5_1_; ++lvt_9_1_) {
                float lvt_10_1_ = 0.0f;
                for (int lvt_11_1_ = lvt_2_1_; lvt_11_1_ < lvt_3_1_; ++lvt_11_1_) {
                    for (int lvt_12_1_ = lvt_6_1_; lvt_12_1_ < lvt_7_1_; ++lvt_12_1_) {
                        lvt_8_1_.setPos(lvt_11_1_, lvt_9_1_, lvt_12_1_);
                        IBlockState lvt_13_1_ = this.world.getBlockState(lvt_8_1_);
                        if (lvt_13_1_.getMaterial() == Material.WATER) {
                            lvt_10_1_ = Math.max(lvt_10_1_, BlockLiquid.getBlockLiquidHeight(lvt_13_1_, this.world, lvt_8_1_));
                        }
                        if (lvt_10_1_ >= 1.0f) continue block4;
                    }
                }
                if (!(lvt_10_1_ < 1.0f)) continue;
                float f = (float)lvt_8_1_.getY() + lvt_10_1_;
                return f;
            }
            float f = lvt_5_1_ + 1;
            return f;
        }
        finally {
            lvt_8_1_.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getBoatGlide() {
        AxisAlignedBB lvt_1_1_ = this.getEntityBoundingBox();
        AxisAlignedBB lvt_2_1_ = new AxisAlignedBB(lvt_1_1_.minX, lvt_1_1_.minY - 0.001, lvt_1_1_.minZ, lvt_1_1_.maxX, lvt_1_1_.minY, lvt_1_1_.maxZ);
        int lvt_3_1_ = MathHelper.floor(lvt_2_1_.minX) - 1;
        int lvt_4_1_ = MathHelper.ceil(lvt_2_1_.maxX) + 1;
        int lvt_5_1_ = MathHelper.floor(lvt_2_1_.minY) - 1;
        int lvt_6_1_ = MathHelper.ceil(lvt_2_1_.maxY) + 1;
        int lvt_7_1_ = MathHelper.floor(lvt_2_1_.minZ) - 1;
        int lvt_8_1_ = MathHelper.ceil(lvt_2_1_.maxZ) + 1;
        ArrayList lvt_9_1_ = Lists.newArrayList();
        float lvt_10_1_ = 0.0f;
        int lvt_11_1_ = 0;
        BlockPos.PooledMutableBlockPos lvt_12_1_ = BlockPos.PooledMutableBlockPos.retain();
        try {
            for (int lvt_13_1_ = lvt_3_1_; lvt_13_1_ < lvt_4_1_; ++lvt_13_1_) {
                for (int lvt_14_1_ = lvt_7_1_; lvt_14_1_ < lvt_8_1_; ++lvt_14_1_) {
                    int lvt_15_1_ = (lvt_13_1_ == lvt_3_1_ || lvt_13_1_ == lvt_4_1_ - 1 ? 1 : 0) + (lvt_14_1_ == lvt_7_1_ || lvt_14_1_ == lvt_8_1_ - 1 ? 1 : 0);
                    if (lvt_15_1_ == 2) continue;
                    for (int lvt_16_1_ = lvt_5_1_; lvt_16_1_ < lvt_6_1_; ++lvt_16_1_) {
                        if (lvt_15_1_ > 0 && (lvt_16_1_ == lvt_5_1_ || lvt_16_1_ == lvt_6_1_ - 1)) continue;
                        lvt_12_1_.setPos(lvt_13_1_, lvt_16_1_, lvt_14_1_);
                        IBlockState lvt_17_1_ = this.world.getBlockState(lvt_12_1_);
                        lvt_17_1_.addCollisionBoxToList(this.world, lvt_12_1_, lvt_2_1_, lvt_9_1_, this, false);
                        if (!lvt_9_1_.isEmpty()) {
                            lvt_10_1_ += lvt_17_1_.getBlock().slipperiness;
                            ++lvt_11_1_;
                        }
                        lvt_9_1_.clear();
                    }
                }
            }
        }
        finally {
            lvt_12_1_.release();
        }
        return lvt_10_1_ / (float)lvt_11_1_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInWater() {
        AxisAlignedBB lvt_1_1_ = this.getEntityBoundingBox();
        int lvt_2_1_ = MathHelper.floor(lvt_1_1_.minX);
        int lvt_3_1_ = MathHelper.ceil(lvt_1_1_.maxX);
        int lvt_4_1_ = MathHelper.floor(lvt_1_1_.minY);
        int lvt_5_1_ = MathHelper.ceil(lvt_1_1_.minY + 0.001);
        int lvt_6_1_ = MathHelper.floor(lvt_1_1_.minZ);
        int lvt_7_1_ = MathHelper.ceil(lvt_1_1_.maxZ);
        boolean lvt_8_1_ = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos lvt_9_1_ = BlockPos.PooledMutableBlockPos.retain();
        try {
            for (int lvt_10_1_ = lvt_2_1_; lvt_10_1_ < lvt_3_1_; ++lvt_10_1_) {
                for (int lvt_11_1_ = lvt_4_1_; lvt_11_1_ < lvt_5_1_; ++lvt_11_1_) {
                    for (int lvt_12_1_ = lvt_6_1_; lvt_12_1_ < lvt_7_1_; ++lvt_12_1_) {
                        lvt_9_1_.setPos(lvt_10_1_, lvt_11_1_, lvt_12_1_);
                        IBlockState lvt_13_1_ = this.world.getBlockState(lvt_9_1_);
                        if (lvt_13_1_.getMaterial() != Material.WATER) continue;
                        float lvt_14_1_ = BlockLiquid.getLiquidHeight(lvt_13_1_, this.world, lvt_9_1_);
                        this.waterLevel = Math.max((double)lvt_14_1_, this.waterLevel);
                        lvt_8_1_ |= lvt_1_1_.minY < (double)lvt_14_1_;
                    }
                }
            }
        }
        finally {
            lvt_9_1_.release();
        }
        return lvt_8_1_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Status getUnderwaterStatus() {
        AxisAlignedBB lvt_1_1_ = this.getEntityBoundingBox();
        double lvt_2_1_ = lvt_1_1_.maxY + 0.001;
        int lvt_4_1_ = MathHelper.floor(lvt_1_1_.minX);
        int lvt_5_1_ = MathHelper.ceil(lvt_1_1_.maxX);
        int lvt_6_1_ = MathHelper.floor(lvt_1_1_.maxY);
        int lvt_7_1_ = MathHelper.ceil(lvt_2_1_);
        int lvt_8_1_ = MathHelper.floor(lvt_1_1_.minZ);
        int lvt_9_1_ = MathHelper.ceil(lvt_1_1_.maxZ);
        boolean lvt_10_1_ = false;
        BlockPos.PooledMutableBlockPos lvt_11_1_ = BlockPos.PooledMutableBlockPos.retain();
        try {
            for (int lvt_12_1_ = lvt_4_1_; lvt_12_1_ < lvt_5_1_; ++lvt_12_1_) {
                for (int lvt_13_1_ = lvt_6_1_; lvt_13_1_ < lvt_7_1_; ++lvt_13_1_) {
                    for (int lvt_14_1_ = lvt_8_1_; lvt_14_1_ < lvt_9_1_; ++lvt_14_1_) {
                        lvt_11_1_.setPos(lvt_12_1_, lvt_13_1_, lvt_14_1_);
                        IBlockState lvt_15_1_ = this.world.getBlockState(lvt_11_1_);
                        if (lvt_15_1_.getMaterial() != Material.WATER || !(lvt_2_1_ < (double)BlockLiquid.getLiquidHeight(lvt_15_1_, this.world, lvt_11_1_))) continue;
                        if (lvt_15_1_.getValue(BlockLiquid.LEVEL) == 0) {
                            lvt_10_1_ = true;
                            continue;
                        }
                        Status status = Status.UNDER_FLOWING_WATER;
                        return status;
                    }
                }
            }
        }
        finally {
            lvt_11_1_.release();
        }
        return lvt_10_1_ ? Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double lvt_1_1_ = -0.04f;
        double lvt_3_1_ = this.hasNoGravity() ? 0.0 : (double)-0.04f;
        double lvt_5_1_ = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.getEntityBoundingBox().minY + (double)this.height;
            this.setPosition(this.posX, (double)(this.getWaterLevelAbove() - this.height) + 0.101, this.posZ);
            this.motionY = 0.0;
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                lvt_5_1_ = (this.waterLevel - this.getEntityBoundingBox().minY) / (double)this.height;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                lvt_3_1_ = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                lvt_5_1_ = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.momentum = this.boatGlide;
                if (this.getControllingPassenger() instanceof EntityPlayer) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.motionX *= (double)this.momentum;
            this.motionZ *= (double)this.momentum;
            this.deltaRotation *= this.momentum;
            this.motionY += lvt_3_1_;
            if (lvt_5_1_ > 0.0) {
                double lvt_7_1_ = 0.65;
                this.motionY += lvt_5_1_ * 0.06153846016296973;
                double lvt_9_1_ = 0.75;
                this.motionY *= 0.75;
            }
        }
    }

    private void controlBoat() {
        if (!this.isBeingRidden()) {
            return;
        }
        float lvt_1_1_ = 0.0f;
        if (this.leftInputDown) {
            this.deltaRotation += -1.0f;
        }
        if (this.rightInputDown) {
            this.deltaRotation += 1.0f;
        }
        if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
            lvt_1_1_ += 0.005f;
        }
        this.rotationYaw += this.deltaRotation;
        if (this.forwardInputDown) {
            lvt_1_1_ += 0.04f;
        }
        if (this.backInputDown) {
            lvt_1_1_ -= 0.005f;
        }
        this.motionX += (double)(MathHelper.sin(-this.rotationYaw * ((float)Math.PI / 180)) * lvt_1_1_);
        this.motionZ += (double)(MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)) * lvt_1_1_);
        this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
    }

    @Override
    public void updatePassenger(Entity p_updatePassenger_1_) {
        if (!this.isPassenger(p_updatePassenger_1_)) {
            return;
        }
        float lvt_2_1_ = 0.0f;
        float lvt_3_1_ = (float)((this.isDead ? (double)0.01f : this.getMountedYOffset()) + p_updatePassenger_1_.getYOffset());
        if (this.getPassengers().size() > 1) {
            int lvt_4_1_ = this.getPassengers().indexOf(p_updatePassenger_1_);
            lvt_2_1_ = lvt_4_1_ == 0 ? 0.2f : -0.6f;
            if (p_updatePassenger_1_ instanceof EntityAnimal) {
                lvt_2_1_ = (float)((double)lvt_2_1_ + 0.2);
            }
        }
        Vec3d lvt_4_2_ = new Vec3d(lvt_2_1_, 0.0, 0.0).rotateYaw(-this.rotationYaw * ((float)Math.PI / 180) - 1.5707964f);
        p_updatePassenger_1_.setPosition(this.posX + lvt_4_2_.xCoord, this.posY + (double)lvt_3_1_, this.posZ + lvt_4_2_.zCoord);
        p_updatePassenger_1_.rotationYaw += this.deltaRotation;
        p_updatePassenger_1_.setRotationYawHead(p_updatePassenger_1_.getRotationYawHead() + this.deltaRotation);
        this.applyYawToEntity(p_updatePassenger_1_);
        if (p_updatePassenger_1_ instanceof EntityAnimal && this.getPassengers().size() > 1) {
            int lvt_5_1_ = p_updatePassenger_1_.getEntityId() % 2 == 0 ? 90 : 270;
            p_updatePassenger_1_.setRenderYawOffset(((EntityAnimal)p_updatePassenger_1_).renderYawOffset + (float)lvt_5_1_);
            p_updatePassenger_1_.setRotationYawHead(p_updatePassenger_1_.getRotationYawHead() + (float)lvt_5_1_);
        }
    }

    protected void applyYawToEntity(Entity p_applyYawToEntity_1_) {
        p_applyYawToEntity_1_.setRenderYawOffset(this.rotationYaw);
        float lvt_2_1_ = MathHelper.wrapDegrees(p_applyYawToEntity_1_.rotationYaw - this.rotationYaw);
        float lvt_3_1_ = MathHelper.clamp(lvt_2_1_, -105.0f, 105.0f);
        p_applyYawToEntity_1_.prevRotationYaw += lvt_3_1_ - lvt_2_1_;
        p_applyYawToEntity_1_.rotationYaw += lvt_3_1_ - lvt_2_1_;
        p_applyYawToEntity_1_.setRotationYawHead(p_applyYawToEntity_1_.rotationYaw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void applyOrientationToEntity(Entity p_applyOrientationToEntity_1_) {
        this.applyYawToEntity(p_applyOrientationToEntity_1_);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setString("Type", this.getBoatType().getName());
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        if (p_readEntityFromNBT_1_.hasKey("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(p_readEntityFromNBT_1_.getString("Type")));
        }
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        if (p_processInitialInteract_1_.isSneaking()) {
            return false;
        }
        if (!this.world.isRemote && this.outOfControlTicks < 60.0f) {
            p_processInitialInteract_1_.startRiding(this);
        }
        return true;
    }

    @Override
    protected void updateFallState(double p_updateFallState_1_, boolean p_updateFallState_3_, IBlockState p_updateFallState_4_, BlockPos p_updateFallState_5_) {
        this.lastYd = this.motionY;
        if (this.isRiding()) {
            return;
        }
        if (p_updateFallState_3_) {
            if (this.fallDistance > 3.0f) {
                if (this.status != Status.ON_LAND) {
                    this.fallDistance = 0.0f;
                    return;
                }
                this.fall(this.fallDistance, 1.0f);
                if (!this.world.isRemote && !this.isDead) {
                    this.setDead();
                    if (this.world.getGameRules().getBoolean("doEntityDrops")) {
                        for (int lvt_6_1_ = 0; lvt_6_1_ < 3; ++lvt_6_1_) {
                            this.entityDropItem(new ItemStack(Item.getItemFromBlock(Blocks.PLANKS), 1, this.getBoatType().getMetadata()), 0.0f);
                        }
                        for (int lvt_6_2_ = 0; lvt_6_2_ < 2; ++lvt_6_2_) {
                            this.dropItemWithOffset(Items.STICK, 1, 0.0f);
                        }
                    }
                }
            }
            this.fallDistance = 0.0f;
        } else if (this.world.getBlockState(new BlockPos(this).down()).getMaterial() != Material.WATER && p_updateFallState_1_ < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - p_updateFallState_1_);
        }
    }

    public boolean getPaddleState(int p_getPaddleState_1_) {
        return this.dataManager.get(DATA_ID_PADDLE[p_getPaddleState_1_]) != false && this.getControllingPassenger() != null;
    }

    public void setDamageTaken(float p_setDamageTaken_1_) {
        this.dataManager.set(DAMAGE_TAKEN, Float.valueOf(p_setDamageTaken_1_));
    }

    public float getDamageTaken() {
        return this.dataManager.get(DAMAGE_TAKEN).floatValue();
    }

    public void setTimeSinceHit(int p_setTimeSinceHit_1_) {
        this.dataManager.set(TIME_SINCE_HIT, p_setTimeSinceHit_1_);
    }

    public int getTimeSinceHit() {
        return this.dataManager.get(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int p_setForwardDirection_1_) {
        this.dataManager.set(FORWARD_DIRECTION, p_setForwardDirection_1_);
    }

    public int getForwardDirection() {
        return this.dataManager.get(FORWARD_DIRECTION);
    }

    public void setBoatType(Type p_setBoatType_1_) {
        this.dataManager.set(BOAT_TYPE, p_setBoatType_1_.ordinal());
    }

    public Type getBoatType() {
        return Type.byId(this.dataManager.get(BOAT_TYPE));
    }

    @Override
    protected boolean canFitPassenger(Entity p_canFitPassenger_1_) {
        return this.getPassengers().size() < 2;
    }

    @Override
    @Nullable
    public Entity getControllingPassenger() {
        List<Entity> lvt_1_1_ = this.getPassengers();
        return lvt_1_1_.isEmpty() ? null : lvt_1_1_.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateInputs(boolean p_updateInputs_1_, boolean p_updateInputs_2_, boolean p_updateInputs_3_, boolean p_updateInputs_4_) {
        this.leftInputDown = p_updateInputs_1_;
        this.rightInputDown = p_updateInputs_2_;
        this.forwardInputDown = p_updateInputs_3_;
        this.backInputDown = p_updateInputs_4_;
    }

    public static enum Type {
        OAK(BlockPlanks.EnumType.OAK.getMetadata(), "oak"),
        SPRUCE(BlockPlanks.EnumType.SPRUCE.getMetadata(), "spruce"),
        BIRCH(BlockPlanks.EnumType.BIRCH.getMetadata(), "birch"),
        JUNGLE(BlockPlanks.EnumType.JUNGLE.getMetadata(), "jungle"),
        ACACIA(BlockPlanks.EnumType.ACACIA.getMetadata(), "acacia"),
        DARK_OAK(BlockPlanks.EnumType.DARK_OAK.getMetadata(), "dark_oak");

        private final String name;
        private final int metadata;

        private Type(int p_i47028_3_, String p_i47028_4_) {
            this.name = p_i47028_4_;
            this.metadata = p_i47028_3_;
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int p_byId_0_) {
            if (p_byId_0_ < 0 || p_byId_0_ >= Type.values().length) {
                p_byId_0_ = 0;
            }
            return Type.values()[p_byId_0_];
        }

        public static Type getTypeFromString(String p_getTypeFromString_0_) {
            for (int lvt_1_1_ = 0; lvt_1_1_ < Type.values().length; ++lvt_1_1_) {
                if (!Type.values()[lvt_1_1_].getName().equals(p_getTypeFromString_0_)) continue;
                return Type.values()[lvt_1_1_];
            }
            return Type.values()[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

