/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnderCrystal
extends Entity {
    private static final DataParameter<Optional<BlockPos>> BEAM_TARGET = EntityDataManager.createKey(EntityEnderCrystal.class, DataSerializers.OPTIONAL_BLOCK_POS);
    private static final DataParameter<Boolean> SHOW_BOTTOM = EntityDataManager.createKey(EntityEnderCrystal.class, DataSerializers.BOOLEAN);
    public int innerRotation;

    public EntityEnderCrystal(World p_i1698_1_) {
        super(p_i1698_1_);
        this.preventEntitySpawning = true;
        this.setSize(2.0f, 2.0f);
        this.innerRotation = this.rand.nextInt(100000);
    }

    public EntityEnderCrystal(World p_i1699_1_, double p_i1699_2_, double p_i1699_4_, double p_i1699_6_) {
        this(p_i1699_1_);
        this.setPosition(p_i1699_2_, p_i1699_4_, p_i1699_6_);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(BEAM_TARGET, Optional.absent());
        this.getDataManager().register(SHOW_BOTTOM, true);
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.innerRotation;
        if (!this.world.isRemote) {
            BlockPos lvt_1_1_ = new BlockPos(this);
            if (this.world.provider instanceof WorldProviderEnd && this.world.getBlockState(lvt_1_1_).getBlock() != Blocks.FIRE) {
                this.world.setBlockState(lvt_1_1_, Blocks.FIRE.getDefaultState());
            }
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        if (this.getBeamTarget() != null) {
            p_writeEntityToNBT_1_.setTag("BeamTarget", NBTUtil.createPosTag(this.getBeamTarget()));
        }
        p_writeEntityToNBT_1_.setBoolean("ShowBottom", this.shouldShowBottom());
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        if (p_readEntityFromNBT_1_.hasKey("BeamTarget", 10)) {
            this.setBeamTarget(NBTUtil.getPosFromTag(p_readEntityFromNBT_1_.getCompoundTag("BeamTarget")));
        }
        if (p_readEntityFromNBT_1_.hasKey("ShowBottom", 1)) {
            this.setShowBottom(p_readEntityFromNBT_1_.getBoolean("ShowBottom"));
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (p_attackEntityFrom_1_.getEntity() instanceof EntityDragon) {
            return false;
        }
        if (!this.isDead && !this.world.isRemote) {
            this.setDead();
            if (!this.world.isRemote) {
                this.world.createExplosion(null, this.posX, this.posY, this.posZ, 6.0f, true);
                this.onCrystalDestroyed(p_attackEntityFrom_1_);
            }
        }
        return true;
    }

    @Override
    public void onKillCommand() {
        this.onCrystalDestroyed(DamageSource.GENERIC);
        super.onKillCommand();
    }

    private void onCrystalDestroyed(DamageSource p_onCrystalDestroyed_1_) {
        WorldProviderEnd lvt_2_1_;
        DragonFightManager lvt_3_1_;
        if (this.world.provider instanceof WorldProviderEnd && (lvt_3_1_ = (lvt_2_1_ = (WorldProviderEnd)this.world.provider).getDragonFightManager()) != null) {
            lvt_3_1_.onCrystalDestroyed(this, p_onCrystalDestroyed_1_);
        }
    }

    public void setBeamTarget(BlockPos p_setBeamTarget_1_) {
        this.getDataManager().set(BEAM_TARGET, Optional.fromNullable((Object)p_setBeamTarget_1_));
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return (BlockPos)this.getDataManager().get(BEAM_TARGET).orNull();
    }

    public void setShowBottom(boolean p_setShowBottom_1_) {
        this.getDataManager().set(SHOW_BOTTOM, p_setShowBottom_1_);
    }

    public boolean shouldShowBottom() {
        return this.getDataManager().get(SHOW_BOTTOM);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        return super.isInRangeToRenderDist(p_isInRangeToRenderDist_1_) || this.getBeamTarget() != null;
    }
}

