/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnderEye
extends Entity {
    private double targetX;
    private double targetY;
    private double targetZ;
    private int despawnTimer;
    private boolean shatterOrDrop;

    public EntityEnderEye(World p_i1757_1_) {
        super(p_i1757_1_);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double lvt_3_1_ = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(lvt_3_1_)) {
            lvt_3_1_ = 4.0;
        }
        return p_isInRangeToRenderDist_1_ < (lvt_3_1_ *= 64.0) * lvt_3_1_;
    }

    public EntityEnderEye(World p_i1758_1_, double p_i1758_2_, double p_i1758_4_, double p_i1758_6_) {
        super(p_i1758_1_);
        this.despawnTimer = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(p_i1758_2_, p_i1758_4_, p_i1758_6_);
    }

    public void moveTowards(BlockPos p_moveTowards_1_) {
        double lvt_2_1_ = p_moveTowards_1_.getX();
        int lvt_4_1_ = p_moveTowards_1_.getY();
        double lvt_7_1_ = lvt_2_1_ - this.posX;
        double lvt_5_1_ = p_moveTowards_1_.getZ();
        double lvt_9_1_ = lvt_5_1_ - this.posZ;
        float lvt_11_1_ = MathHelper.sqrt(lvt_7_1_ * lvt_7_1_ + lvt_9_1_ * lvt_9_1_);
        if (lvt_11_1_ > 12.0f) {
            this.targetX = this.posX + lvt_7_1_ / (double)lvt_11_1_ * 12.0;
            this.targetZ = this.posZ + lvt_9_1_ / (double)lvt_11_1_ * 12.0;
            this.targetY = this.posY + 8.0;
        } else {
            this.targetX = lvt_2_1_;
            this.targetY = lvt_4_1_;
            this.targetZ = lvt_5_1_;
        }
        this.despawnTimer = 0;
        this.shatterOrDrop = this.rand.nextInt(5) > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float lvt_7_1_ = MathHelper.sqrt(p_setVelocity_1_ * p_setVelocity_1_ + p_setVelocity_5_ * p_setVelocity_5_);
            this.rotationYaw = (float)(MathHelper.atan2(p_setVelocity_1_, p_setVelocity_5_) * 57.2957763671875);
            this.rotationPitch = (float)(MathHelper.atan2(p_setVelocity_3_, lvt_7_1_) * 57.2957763671875);
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
        }
    }

    @Override
    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float lvt_1_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_1_1_) * 57.2957763671875);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        if (!this.world.isRemote) {
            double lvt_2_1_ = this.targetX - this.posX;
            double lvt_4_1_ = this.targetZ - this.posZ;
            float lvt_6_1_ = (float)Math.sqrt(lvt_2_1_ * lvt_2_1_ + lvt_4_1_ * lvt_4_1_);
            float lvt_7_1_ = (float)MathHelper.atan2(lvt_4_1_, lvt_2_1_);
            double lvt_8_1_ = (double)lvt_1_1_ + (double)(lvt_6_1_ - lvt_1_1_) * 0.0025;
            if (lvt_6_1_ < 1.0f) {
                lvt_8_1_ *= 0.8;
                this.motionY *= 0.8;
            }
            this.motionX = Math.cos(lvt_7_1_) * lvt_8_1_;
            this.motionZ = Math.sin(lvt_7_1_) * lvt_8_1_;
            this.motionY = this.posY < this.targetY ? (this.motionY += (1.0 - this.motionY) * (double)0.015f) : (this.motionY += (-1.0 - this.motionY) * (double)0.015f);
        }
        float lvt_2_2_ = 0.25f;
        if (this.isInWater()) {
            for (int lvt_3_1_ = 0; lvt_3_1_ < 4; ++lvt_3_1_) {
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * 0.25, this.posY - this.motionY * 0.25, this.posZ - this.motionZ * 0.25, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
        } else {
            this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX - this.motionX * 0.25 + this.rand.nextDouble() * 0.6 - 0.3, this.posY - this.motionY * 0.25 - 0.5, this.posZ - this.motionZ * 0.25 + this.rand.nextDouble() * 0.6 - 0.3, this.motionX, this.motionY, this.motionZ, new int[0]);
        }
        if (!this.world.isRemote) {
            this.setPosition(this.posX, this.posY, this.posZ);
            ++this.despawnTimer;
            if (this.despawnTimer > 80 && !this.world.isRemote) {
                this.setDead();
                if (this.shatterOrDrop) {
                    this.world.spawnEntity(new EntityItem(this.world, this.posX, this.posY, this.posZ, new ItemStack(Items.ENDER_EYE)));
                } else {
                    this.world.playEvent(2003, new BlockPos(this), 0);
                }
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
    }

    @Override
    public float getBrightness(float p_getBrightness_1_) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }
}

