/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnderPearl
extends EntityThrowable {
    private EntityLivingBase thrower;

    public EntityEnderPearl(World p_i46455_1_) {
        super(p_i46455_1_);
    }

    public EntityEnderPearl(World p_i1783_1_, EntityLivingBase p_i1783_2_) {
        super(p_i1783_1_, p_i1783_2_);
        this.thrower = p_i1783_2_;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityEnderPearl(World p_i1784_1_, double p_i1784_2_, double p_i1784_4_, double p_i1784_6_) {
        super(p_i1784_1_, p_i1784_2_, p_i1784_4_, p_i1784_6_);
    }

    public static void registerFixesEnderPearl(DataFixer p_registerFixesEnderPearl_0_) {
        EntityThrowable.registerFixesThrowable(p_registerFixesEnderPearl_0_, "ThrownEnderpearl");
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        BlockPos blockpos;
        TileEntity tileentity;
        EntityLivingBase entitylivingbase = this.getThrower();
        if (p_onImpact_1_.entityHit != null) {
            if (p_onImpact_1_.entityHit == this.thrower) {
                return;
            }
            p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, entitylivingbase), 0.0f);
        }
        if (p_onImpact_1_.typeOfHit == RayTraceResult.Type.BLOCK && (tileentity = this.world.getTileEntity(blockpos = p_onImpact_1_.getBlockPos())) instanceof TileEntityEndGateway) {
            TileEntityEndGateway tileentityendgateway = (TileEntityEndGateway)tileentity;
            if (entitylivingbase != null) {
                tileentityendgateway.teleportEntity(entitylivingbase);
                this.setDead();
                return;
            }
            tileentityendgateway.teleportEntity(this);
            return;
        }
        for (int i = 0; i < 32; ++i) {
            this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX, this.posY + this.rand.nextDouble() * 2.0, this.posZ, this.rand.nextGaussian(), 0.0, this.rand.nextGaussian(), new int[0]);
        }
        if (!this.world.isRemote) {
            if (entitylivingbase instanceof EntityPlayerMP) {
                EnderTeleportEvent event;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)entitylivingbase;
                if (entityplayermp.connection.getNetworkManager().isChannelOpen() && entityplayermp.world == this.world && !entityplayermp.isPlayerSleeping() && !MinecraftForge.EVENT_BUS.post(event = new EnderTeleportEvent(entityplayermp, this.posX, this.posY, this.posZ, 5.0f))) {
                    if (this.rand.nextFloat() < 0.05f && this.world.getGameRules().getBoolean("doMobSpawning")) {
                        EntityEndermite entityendermite = new EntityEndermite(this.world);
                        entityendermite.setSpawnedByPlayer(true);
                        entityendermite.setLocationAndAngles(entitylivingbase.posX, entitylivingbase.posY, entitylivingbase.posZ, entitylivingbase.rotationYaw, entitylivingbase.rotationPitch);
                        this.world.spawnEntity(entityendermite);
                    }
                    if (entitylivingbase.isRiding()) {
                        entitylivingbase.dismountRidingEntity();
                    }
                    entitylivingbase.setPositionAndUpdate(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    entitylivingbase.fallDistance = 0.0f;
                    entitylivingbase.attackEntityFrom(DamageSource.FALL, event.getAttackDamage());
                }
            } else if (entitylivingbase != null) {
                entitylivingbase.setPositionAndUpdate(this.posX, this.posY, this.posZ);
                entitylivingbase.fallDistance = 0.0f;
            }
            this.setDead();
        }
    }

    @Override
    public void onUpdate() {
        EntityLivingBase entitylivingbase = this.getThrower();
        if (entitylivingbase != null && entitylivingbase instanceof EntityPlayer && !entitylivingbase.isEntityAlive()) {
            this.setDead();
        } else {
            super.onUpdate();
        }
    }
}

