/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFallingBlock
extends Entity {
    private IBlockState fallTile;
    public int fallTime;
    public boolean shouldDropItem = true;
    private boolean dontSetBlock;
    private boolean hurtEntities;
    private int fallHurtMax = 40;
    private float fallHurtAmount = 2.0f;
    public NBTTagCompound tileEntityData;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.createKey(EntityFallingBlock.class, DataSerializers.BLOCK_POS);

    public EntityFallingBlock(World p_i1706_1_) {
        super(p_i1706_1_);
    }

    public EntityFallingBlock(World p_i45848_1_, double p_i45848_2_, double p_i45848_4_, double p_i45848_6_, IBlockState p_i45848_8_) {
        super(p_i45848_1_);
        this.fallTile = p_i45848_8_;
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.setPosition(p_i45848_2_, p_i45848_4_ + (double)((1.0f - this.height) / 2.0f), p_i45848_6_);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = p_i45848_2_;
        this.prevPosY = p_i45848_4_;
        this.prevPosZ = p_i45848_6_;
        this.setOrigin(new BlockPos(this));
    }

    public void setOrigin(BlockPos p_setOrigin_1_) {
        this.dataManager.set(ORIGIN, p_setOrigin_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOrigin() {
        return this.dataManager.get(ORIGIN);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(ORIGIN, BlockPos.ORIGIN);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void onUpdate() {
        Block block = this.fallTile.getBlock();
        if (this.fallTile.getMaterial() == Material.AIR) {
            this.setDead();
        } else {
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            if (this.fallTime++ == 0) {
                BlockPos blockpos = new BlockPos(this);
                if (this.world.getBlockState(blockpos).getBlock() == block) {
                    this.world.setBlockToAir(blockpos);
                } else if (!this.world.isRemote) {
                    this.setDead();
                    return;
                }
            }
            if (!this.hasNoGravity()) {
                this.motionY -= (double)0.04f;
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
            if (!this.world.isRemote) {
                BlockPos blockpos1 = new BlockPos(this);
                if (this.onGround) {
                    IBlockState iblockstate = this.world.getBlockState(blockpos1);
                    if (this.world.isAirBlock(new BlockPos(this.posX, this.posY - (double)0.01f, this.posZ)) && BlockFalling.canFallThrough(this.world.getBlockState(new BlockPos(this.posX, this.posY - (double)0.01f, this.posZ)))) {
                        this.onGround = false;
                        return;
                    }
                    this.motionX *= (double)0.7f;
                    this.motionZ *= (double)0.7f;
                    this.motionY *= -0.5;
                    if (iblockstate.getBlock() != Blocks.PISTON_EXTENSION) {
                        this.setDead();
                        if (!this.dontSetBlock) {
                            if (this.world.mayPlace(block, blockpos1, true, EnumFacing.UP, null) && !BlockFalling.canFallThrough(this.world.getBlockState(blockpos1.down())) && this.world.setBlockState(blockpos1, this.fallTile, 3)) {
                                TileEntity tileentity;
                                if (block instanceof BlockFalling) {
                                    ((BlockFalling)block).onEndFalling(this.world, blockpos1);
                                }
                                if (this.tileEntityData != null && block instanceof ITileEntityProvider && (tileentity = this.world.getTileEntity(blockpos1)) != null) {
                                    NBTTagCompound nbttagcompound = tileentity.writeToNBT(new NBTTagCompound());
                                    for (String s : this.tileEntityData.getKeySet()) {
                                        NBTBase nbtbase = this.tileEntityData.getTag(s);
                                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                        nbttagcompound.setTag(s, nbtbase.copy());
                                    }
                                    tileentity.readFromNBT(nbttagcompound);
                                    tileentity.markDirty();
                                }
                            } else if (this.shouldDropItem && this.world.getGameRules().getBoolean("doEntityDrops")) {
                                this.entityDropItem(new ItemStack(block, 1, block.damageDropped(this.fallTile)), 0.0f);
                            }
                        } else if (block instanceof BlockFalling) {
                            ((BlockFalling)block).onBroken(this.world, blockpos1);
                        }
                    }
                } else if (this.fallTime > 100 && !this.world.isRemote && (blockpos1.getY() < 1 || blockpos1.getY() > 256) || this.fallTime > 600) {
                    if (this.shouldDropItem && this.world.getGameRules().getBoolean("doEntityDrops")) {
                        this.entityDropItem(new ItemStack(block, 1, block.damageDropped(this.fallTile)), 0.0f);
                    }
                    this.setDead();
                }
            }
        }
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        int i;
        Block block = this.fallTile.getBlock();
        if (this.hurtEntities && (i = MathHelper.ceil(p_fall_1_ - 1.0f)) > 0) {
            ArrayList list = Lists.newArrayList(this.world.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox()));
            boolean flag = block == Blocks.ANVIL;
            DamageSource damagesource = flag ? DamageSource.ANVIL : DamageSource.FALLING_BLOCK;
            for (Entity entity : list) {
                entity.attackEntityFrom(damagesource, Math.min(MathHelper.floor((float)i * this.fallHurtAmount), this.fallHurtMax));
            }
            if (flag && (double)this.rand.nextFloat() < (double)0.05f + (double)i * 0.05) {
                int j = this.fallTile.getValue(BlockAnvil.DAMAGE);
                if (++j > 2) {
                    this.dontSetBlock = true;
                } else {
                    this.fallTile = this.fallTile.withProperty(BlockAnvil.DAMAGE, j);
                }
            }
        }
    }

    public static void registerFixesFallingBlock(DataFixer p_registerFixesFallingBlock_0_) {
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        Block block = this.fallTile != null ? this.fallTile.getBlock() : Blocks.AIR;
        ResourceLocation resourcelocation = Block.REGISTRY.getNameForObject(block);
        p_writeEntityToNBT_1_.setString("Block", resourcelocation == null ? "" : resourcelocation.toString());
        p_writeEntityToNBT_1_.setByte("Data", (byte)block.getMetaFromState(this.fallTile));
        p_writeEntityToNBT_1_.setInteger("Time", this.fallTime);
        p_writeEntityToNBT_1_.setBoolean("DropItem", this.shouldDropItem);
        p_writeEntityToNBT_1_.setBoolean("HurtEntities", this.hurtEntities);
        p_writeEntityToNBT_1_.setFloat("FallHurtAmount", this.fallHurtAmount);
        p_writeEntityToNBT_1_.setInteger("FallHurtMax", this.fallHurtMax);
        if (this.tileEntityData != null) {
            p_writeEntityToNBT_1_.setTag("TileEntityData", this.tileEntityData);
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        int i = p_readEntityFromNBT_1_.getByte("Data") & 0xFF;
        this.fallTile = p_readEntityFromNBT_1_.hasKey("Block", 8) ? Block.getBlockFromName(p_readEntityFromNBT_1_.getString("Block")).getStateFromMeta(i) : (p_readEntityFromNBT_1_.hasKey("TileID", 99) ? Block.getBlockById(p_readEntityFromNBT_1_.getInteger("TileID")).getStateFromMeta(i) : Block.getBlockById(p_readEntityFromNBT_1_.getByte("Tile") & 0xFF).getStateFromMeta(i));
        this.fallTime = p_readEntityFromNBT_1_.getInteger("Time");
        Block block = this.fallTile.getBlock();
        if (p_readEntityFromNBT_1_.hasKey("HurtEntities", 99)) {
            this.hurtEntities = p_readEntityFromNBT_1_.getBoolean("HurtEntities");
            this.fallHurtAmount = p_readEntityFromNBT_1_.getFloat("FallHurtAmount");
            this.fallHurtMax = p_readEntityFromNBT_1_.getInteger("FallHurtMax");
        } else if (block == Blocks.ANVIL) {
            this.hurtEntities = true;
        }
        if (p_readEntityFromNBT_1_.hasKey("DropItem", 99)) {
            this.shouldDropItem = p_readEntityFromNBT_1_.getBoolean("DropItem");
        }
        if (p_readEntityFromNBT_1_.hasKey("TileEntityData", 10)) {
            this.tileEntityData = p_readEntityFromNBT_1_.getCompoundTag("TileEntityData");
        }
        if (block == null || block.getDefaultState().getMaterial() == Material.AIR) {
            this.fallTile = Blocks.SAND.getDefaultState();
        }
    }

    public void setHurtEntities(boolean p_setHurtEntities_1_) {
        this.hurtEntities = p_setHurtEntities_1_;
    }

    @Override
    public void addEntityCrashInfo(CrashReportCategory p_addEntityCrashInfo_1_) {
        super.addEntityCrashInfo(p_addEntityCrashInfo_1_);
        if (this.fallTile != null) {
            Block block = this.fallTile.getBlock();
            p_addEntityCrashInfo_1_.addCrashSection("Immitating block ID", Block.getIdFromBlock(block));
            p_addEntityCrashInfo_1_.addCrashSection("Immitating block data", block.getMetaFromState(this.fallTile));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public World getWorldObj() {
        return this.world;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderOnFire() {
        return false;
    }

    @Nullable
    public IBlockState getBlock() {
        return this.fallTile;
    }

    @Override
    public boolean ignoreItemEntityData() {
        return true;
    }
}

