/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFireworkRocket
extends Entity {
    private static final DataParameter<ItemStack> FIREWORK_ITEM = EntityDataManager.createKey(EntityFireworkRocket.class, DataSerializers.OPTIONAL_ITEM_STACK);
    private static final DataParameter<Integer> field_191512_b = EntityDataManager.createKey(EntityFireworkRocket.class, DataSerializers.VARINT);
    private int fireworkAge;
    private int lifetime;
    private EntityLivingBase field_191513_e;

    public EntityFireworkRocket(World p_i1762_1_) {
        super(p_i1762_1_);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(FIREWORK_ITEM, ItemStack.EMPTY);
        this.dataManager.register(field_191512_b, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        return p_isInRangeToRenderDist_1_ < 4096.0 && !this.func_191511_j();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRender3d(double p_isInRangeToRender3d_1_, double p_isInRangeToRender3d_3_, double p_isInRangeToRender3d_5_) {
        return super.isInRangeToRender3d(p_isInRangeToRender3d_1_, p_isInRangeToRender3d_3_, p_isInRangeToRender3d_5_) && !this.func_191511_j();
    }

    public EntityFireworkRocket(World p_i1763_1_, double p_i1763_2_, double p_i1763_4_, double p_i1763_6_, ItemStack p_i1763_8_) {
        super(p_i1763_1_);
        this.fireworkAge = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(p_i1763_2_, p_i1763_4_, p_i1763_6_);
        int lvt_9_1_ = 1;
        if (!p_i1763_8_.isEmpty() && p_i1763_8_.hasTagCompound()) {
            this.dataManager.set(FIREWORK_ITEM, p_i1763_8_.copy());
            NBTTagCompound lvt_10_1_ = p_i1763_8_.getTagCompound();
            NBTTagCompound lvt_11_1_ = lvt_10_1_.getCompoundTag("Fireworks");
            lvt_9_1_ += lvt_11_1_.getByte("Flight");
        }
        this.motionX = this.rand.nextGaussian() * 0.001;
        this.motionZ = this.rand.nextGaussian() * 0.001;
        this.motionY = 0.05;
        this.lifetime = 10 * lvt_9_1_ + this.rand.nextInt(6) + this.rand.nextInt(7);
    }

    public EntityFireworkRocket(World p_i47367_1_, ItemStack p_i47367_2_, EntityLivingBase p_i47367_3_) {
        this(p_i47367_1_, p_i47367_3_.posX, p_i47367_3_.posY, p_i47367_3_.posZ, p_i47367_2_);
        this.dataManager.set(field_191512_b, p_i47367_3_.getEntityId());
        this.field_191513_e = p_i47367_3_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float lvt_7_1_ = MathHelper.sqrt(p_setVelocity_1_ * p_setVelocity_1_ + p_setVelocity_5_ * p_setVelocity_5_);
            this.rotationYaw = (float)(MathHelper.atan2(p_setVelocity_1_, p_setVelocity_5_) * 57.2957763671875);
            this.rotationPitch = (float)(MathHelper.atan2(p_setVelocity_3_, lvt_7_1_) * 57.2957763671875);
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
        }
    }

    @Override
    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        if (this.func_191511_j()) {
            Entity lvt_1_1_;
            if (this.field_191513_e == null && (lvt_1_1_ = this.world.getEntityByID(this.dataManager.get(field_191512_b))) instanceof EntityLivingBase) {
                this.field_191513_e = (EntityLivingBase)lvt_1_1_;
            }
            if (this.field_191513_e != null) {
                if (this.field_191513_e.isElytraFlying()) {
                    Vec3d lvt_1_2_ = this.field_191513_e.getLookVec();
                    double lvt_2_1_ = 1.5;
                    double lvt_4_1_ = 0.1;
                    this.field_191513_e.motionX += lvt_1_2_.xCoord * 0.1 + (lvt_1_2_.xCoord * 1.5 - this.field_191513_e.motionX) * 0.5;
                    this.field_191513_e.motionY += lvt_1_2_.yCoord * 0.1 + (lvt_1_2_.yCoord * 1.5 - this.field_191513_e.motionY) * 0.5;
                    this.field_191513_e.motionZ += lvt_1_2_.zCoord * 0.1 + (lvt_1_2_.zCoord * 1.5 - this.field_191513_e.motionZ) * 0.5;
                }
                this.setPosition(this.field_191513_e.posX, this.field_191513_e.posY, this.field_191513_e.posZ);
                this.motionX = this.field_191513_e.motionX;
                this.motionY = this.field_191513_e.motionY;
                this.motionZ = this.field_191513_e.motionZ;
            }
        } else {
            this.motionX *= 1.15;
            this.motionZ *= 1.15;
            this.motionY += 0.04;
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        }
        float lvt_1_3_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(MathHelper.atan2(this.motionX, this.motionZ) * 57.2957763671875);
        this.rotationPitch = (float)(MathHelper.atan2(this.motionY, lvt_1_3_) * 57.2957763671875);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        if (this.fireworkAge == 0 && !this.isSilent()) {
            this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_FIREWORK_LAUNCH, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.fireworkAge;
        if (this.world.isRemote && this.fireworkAge % 2 < 2) {
            this.world.spawnParticle(EnumParticleTypes.FIREWORKS_SPARK, this.posX, this.posY - 0.3, this.posZ, this.rand.nextGaussian() * 0.05, -this.motionY * 0.5, this.rand.nextGaussian() * 0.05, new int[0]);
        }
        if (!this.world.isRemote && this.fireworkAge > this.lifetime) {
            this.world.setEntityState(this, (byte)17);
            this.func_191510_k();
            this.setDead();
        }
    }

    private void func_191510_k() {
        NBTTagList lvt_4_1_;
        float lvt_1_1_ = 0.0f;
        ItemStack lvt_2_1_ = this.dataManager.get(FIREWORK_ITEM);
        NBTTagCompound lvt_3_1_ = lvt_2_1_.isEmpty() ? null : lvt_2_1_.getSubCompound("Fireworks");
        NBTTagList nBTTagList = lvt_4_1_ = lvt_3_1_ != null ? lvt_3_1_.getTagList("Explosions", 10) : null;
        if (lvt_4_1_ != null && !lvt_4_1_.hasNoTags()) {
            lvt_1_1_ = 5 + lvt_4_1_.tagCount() * 2;
        }
        if (lvt_1_1_ > 0.0f) {
            if (this.field_191513_e != null) {
                this.field_191513_e.attackEntityFrom(DamageSource.field_191552_t, 5 + lvt_4_1_.tagCount() * 2);
            }
            double lvt_5_1_ = 5.0;
            Vec3d lvt_7_1_ = new Vec3d(this.posX, this.posY, this.posZ);
            List<EntityLivingBase> lvt_8_1_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expandXyz(5.0));
            for (EntityLivingBase lvt_10_1_ : lvt_8_1_) {
                if (lvt_10_1_ == this.field_191513_e || this.getDistanceSqToEntity(lvt_10_1_) > 25.0) continue;
                boolean lvt_11_1_ = false;
                for (int lvt_12_1_ = 0; lvt_12_1_ < 2; ++lvt_12_1_) {
                    RayTraceResult lvt_13_1_ = this.world.rayTraceBlocks(lvt_7_1_, new Vec3d(lvt_10_1_.posX, lvt_10_1_.posY + (double)lvt_10_1_.height * 0.5 * (double)lvt_12_1_, lvt_10_1_.posZ), false, true, false);
                    if (lvt_13_1_ != null && lvt_13_1_.typeOfHit != RayTraceResult.Type.MISS) continue;
                    lvt_11_1_ = true;
                    break;
                }
                if (!lvt_11_1_) continue;
                float lvt_12_2_ = lvt_1_1_ * (float)Math.sqrt((5.0 - (double)this.getDistanceToEntity(lvt_10_1_)) / 5.0);
                lvt_10_1_.attackEntityFrom(DamageSource.field_191552_t, lvt_12_2_);
            }
        }
    }

    public boolean func_191511_j() {
        return this.dataManager.get(field_191512_b) > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 17 && this.world.isRemote) {
            ItemStack lvt_2_1_ = this.dataManager.get(FIREWORK_ITEM);
            NBTTagCompound lvt_3_1_ = lvt_2_1_.isEmpty() ? null : lvt_2_1_.getSubCompound("Fireworks");
            this.world.makeFireworks(this.posX, this.posY, this.posZ, this.motionX, this.motionY, this.motionZ, lvt_3_1_);
        }
        super.handleStatusUpdate(p_handleStatusUpdate_1_);
    }

    public static void registerFixesFireworkRocket(DataFixer p_registerFixesFireworkRocket_0_) {
        p_registerFixesFireworkRocket_0_.registerWalker(FixTypes.ENTITY, new ItemStackData(EntityFireworkRocket.class, "FireworksItem"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setInteger("Life", this.fireworkAge);
        p_writeEntityToNBT_1_.setInteger("LifeTime", this.lifetime);
        ItemStack lvt_2_1_ = this.dataManager.get(FIREWORK_ITEM);
        if (!lvt_2_1_.isEmpty()) {
            p_writeEntityToNBT_1_.setTag("FireworksItem", lvt_2_1_.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        ItemStack lvt_3_1_;
        this.fireworkAge = p_readEntityFromNBT_1_.getInteger("Life");
        this.lifetime = p_readEntityFromNBT_1_.getInteger("LifeTime");
        NBTTagCompound lvt_2_1_ = p_readEntityFromNBT_1_.getCompoundTag("FireworksItem");
        if (lvt_2_1_ != null && !(lvt_3_1_ = new ItemStack(lvt_2_1_)).isEmpty()) {
            this.dataManager.set(FIREWORK_ITEM, lvt_3_1_);
        }
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }
}

