/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityItem
extends Entity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.createKey(EntityItem.class, DataSerializers.OPTIONAL_ITEM_STACK);
    private int age;
    private int delayBeforeCanPickup;
    private int health = 5;
    private String thrower;
    private String owner;
    public float hoverStart = (float)(Math.random() * Math.PI * 2.0);
    public int lifespan = 6000;

    public EntityItem(World p_i1709_1_, double p_i1709_2_, double p_i1709_4_, double p_i1709_6_) {
        super(p_i1709_1_);
        this.setSize(0.25f, 0.25f);
        this.setPosition(p_i1709_2_, p_i1709_4_, p_i1709_6_);
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motionY = 0.2f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    public EntityItem(World p_i1710_1_, double p_i1710_2_, double p_i1710_4_, double p_i1710_6_, ItemStack p_i1710_8_) {
        this(p_i1710_1_, p_i1710_2_, p_i1710_4_, p_i1710_6_);
        this.setEntityItemStack(p_i1710_8_);
        this.lifespan = p_i1710_8_.getItem() == null ? 6000 : p_i1710_8_.getItem().getEntityLifespan(p_i1710_8_, p_i1710_1_);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    public EntityItem(World p_i1711_1_) {
        super(p_i1711_1_);
        this.setSize(0.25f, 0.25f);
        this.setEntityItemStack(ItemStack.EMPTY);
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(ITEM, ItemStack.EMPTY);
    }

    @Override
    public void onUpdate() {
        if (this.getEntityItem().getItem().onEntityItemUpdate(this)) {
            return;
        }
        if (this.getEntityItem().isEmpty()) {
            this.setDead();
        } else {
            double d5;
            double d4;
            double d3;
            double d6;
            boolean flag;
            super.onUpdate();
            if (this.delayBeforeCanPickup > 0 && this.delayBeforeCanPickup != Short.MAX_VALUE) {
                --this.delayBeforeCanPickup;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            double d0 = this.motionX;
            double d1 = this.motionY;
            double d2 = this.motionZ;
            if (!this.hasNoGravity()) {
                this.motionY -= (double)0.04f;
            }
            this.noClip = this.world.isRemote ? false : this.pushOutOfBlocks(this.posX, (this.getEntityBoundingBox().minY + this.getEntityBoundingBox().maxY) / 2.0, this.posZ);
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            boolean bl = flag = (int)this.prevPosX != (int)this.posX || (int)this.prevPosY != (int)this.posY || (int)this.prevPosZ != (int)this.posZ;
            if (flag || this.ticksExisted % 25 == 0) {
                if (this.world.getBlockState(new BlockPos(this)).getMaterial() == Material.LAVA) {
                    this.motionY = 0.2f;
                    this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
                    this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
                    this.playSound(SoundEvents.ENTITY_GENERIC_BURN, 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
                }
                if (!this.world.isRemote) {
                    this.searchForOtherItemsNearby();
                }
            }
            float f = 0.98f;
            if (this.onGround) {
                f = this.world.getBlockState((BlockPos)new BlockPos((int)MathHelper.floor((double)this.posX), (int)(MathHelper.floor((double)this.getEntityBoundingBox().minY) - 1), (int)MathHelper.floor((double)this.posZ))).getBlock().slipperiness * 0.98f;
            }
            this.motionX *= (double)f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)f;
            if (this.onGround) {
                this.motionY *= -0.5;
            }
            if (this.age != Short.MIN_VALUE) {
                ++this.age;
            }
            this.handleWaterMovement();
            if (!this.world.isRemote && (d6 = (d3 = this.motionX - d0) * d3 + (d4 = this.motionY - d1) * d4 + (d5 = this.motionZ - d2) * d5) > 0.01) {
                this.isAirBorne = true;
            }
            ItemStack item = this.getEntityItem();
            if (!this.world.isRemote && this.age >= this.lifespan) {
                int hook = ForgeEventFactory.onItemExpire(this, item);
                if (hook < 0) {
                    this.setDead();
                } else {
                    this.lifespan += hook;
                }
            }
            if (item.isEmpty()) {
                this.setDead();
            }
        }
    }

    private void searchForOtherItemsNearby() {
        for (EntityItem entityitem : this.world.getEntitiesWithinAABB(EntityItem.class, this.getEntityBoundingBox().expand(0.5, 0.0, 0.5))) {
            this.combineItems(entityitem);
        }
    }

    private boolean combineItems(EntityItem p_combineItems_1_) {
        if (p_combineItems_1_ == this) {
            return false;
        }
        if (p_combineItems_1_.isEntityAlive() && this.isEntityAlive()) {
            ItemStack itemstack = this.getEntityItem();
            ItemStack itemstack1 = p_combineItems_1_.getEntityItem();
            if (this.delayBeforeCanPickup != Short.MAX_VALUE && p_combineItems_1_.delayBeforeCanPickup != Short.MAX_VALUE) {
                if (this.age != Short.MIN_VALUE && p_combineItems_1_.age != Short.MIN_VALUE) {
                    if (itemstack1.getItem() != itemstack.getItem()) {
                        return false;
                    }
                    if (itemstack1.hasTagCompound() ^ itemstack.hasTagCompound()) {
                        return false;
                    }
                    if (itemstack1.hasTagCompound() && !itemstack1.getTagCompound().equals(itemstack.getTagCompound())) {
                        return false;
                    }
                    if (itemstack1.getItem() == null) {
                        return false;
                    }
                    if (itemstack1.getItem().getHasSubtypes() && itemstack1.getMetadata() != itemstack.getMetadata()) {
                        return false;
                    }
                    if (itemstack1.getCount() < itemstack.getCount()) {
                        return p_combineItems_1_.combineItems(this);
                    }
                    if (itemstack1.getCount() + itemstack.getCount() > itemstack1.getMaxStackSize()) {
                        return false;
                    }
                    if (!itemstack.areCapsCompatible(itemstack1)) {
                        return false;
                    }
                    itemstack1.grow(itemstack.getCount());
                    p_combineItems_1_.delayBeforeCanPickup = Math.max(p_combineItems_1_.delayBeforeCanPickup, this.delayBeforeCanPickup);
                    p_combineItems_1_.age = Math.min(p_combineItems_1_.age, this.age);
                    p_combineItems_1_.setEntityItemStack(itemstack1);
                    this.setDead();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void setAgeToCreativeDespawnTime() {
        this.age = 4800;
    }

    @Override
    public boolean handleWaterMovement() {
        if (this.world.handleMaterialAcceleration(this.getEntityBoundingBox(), Material.WATER, this)) {
            if (!this.inWater && !this.firstUpdate) {
                this.resetHeight();
            }
            this.inWater = true;
        } else {
            this.inWater = false;
        }
        return this.inWater;
    }

    @Override
    protected void dealFireDamage(int p_dealFireDamage_1_) {
        this.attackEntityFrom(DamageSource.IN_FIRE, p_dealFireDamage_1_);
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (!this.getEntityItem().isEmpty() && this.getEntityItem().getItem() == Items.NETHER_STAR && p_attackEntityFrom_1_.isExplosion()) {
            return false;
        }
        this.setBeenAttacked();
        this.health = (int)((float)this.health - p_attackEntityFrom_2_);
        if (this.health <= 0) {
            this.setDead();
        }
        return false;
    }

    public static void registerFixesItem(DataFixer p_registerFixesItem_0_) {
        p_registerFixesItem_0_.registerWalker(FixTypes.ENTITY, new ItemStackData(EntityItem.class, "Item"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setShort("Health", (short)this.health);
        p_writeEntityToNBT_1_.setShort("Age", (short)this.age);
        p_writeEntityToNBT_1_.setShort("PickupDelay", (short)this.delayBeforeCanPickup);
        p_writeEntityToNBT_1_.setInteger("Lifespan", this.lifespan);
        if (this.getThrower() != null) {
            p_writeEntityToNBT_1_.setString("Thrower", this.thrower);
        }
        if (this.getOwner() != null) {
            p_writeEntityToNBT_1_.setString("Owner", this.owner);
        }
        if (!this.getEntityItem().isEmpty()) {
            p_writeEntityToNBT_1_.setTag("Item", this.getEntityItem().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.health = p_readEntityFromNBT_1_.getShort("Health");
        this.age = p_readEntityFromNBT_1_.getShort("Age");
        if (p_readEntityFromNBT_1_.hasKey("PickupDelay")) {
            this.delayBeforeCanPickup = p_readEntityFromNBT_1_.getShort("PickupDelay");
        }
        if (p_readEntityFromNBT_1_.hasKey("Owner")) {
            this.owner = p_readEntityFromNBT_1_.getString("Owner");
        }
        if (p_readEntityFromNBT_1_.hasKey("Thrower")) {
            this.thrower = p_readEntityFromNBT_1_.getString("Thrower");
        }
        NBTTagCompound nbttagcompound = p_readEntityFromNBT_1_.getCompoundTag("Item");
        this.setEntityItemStack(new ItemStack(nbttagcompound));
        if (this.getEntityItem().isEmpty()) {
            this.setDead();
        }
        if (p_readEntityFromNBT_1_.hasKey("Lifespan")) {
            this.lifespan = p_readEntityFromNBT_1_.getInteger("Lifespan");
        }
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer p_onCollideWithPlayer_1_) {
        if (!this.world.isRemote) {
            if (this.delayBeforeCanPickup > 0) {
                return;
            }
            ItemStack itemstack = this.getEntityItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            int hook = ForgeEventFactory.onItemPickup(this, p_onCollideWithPlayer_1_, itemstack);
            if (hook < 0) {
                return;
            }
            if (this.delayBeforeCanPickup <= 0 && (this.owner == null || this.lifespan - this.age <= 200 || this.owner.equals(p_onCollideWithPlayer_1_.getName())) && (hook == 1 || i <= 0 || p_onCollideWithPlayer_1_.inventory.addItemStackToInventory(itemstack))) {
                EntityPlayer entityplayer;
                if (item == Item.getItemFromBlock(Blocks.LOG)) {
                    p_onCollideWithPlayer_1_.addStat(AchievementList.MINE_WOOD);
                }
                if (item == Item.getItemFromBlock(Blocks.LOG2)) {
                    p_onCollideWithPlayer_1_.addStat(AchievementList.MINE_WOOD);
                }
                if (item == Items.LEATHER) {
                    p_onCollideWithPlayer_1_.addStat(AchievementList.KILL_COW);
                }
                if (item == Items.DIAMOND) {
                    p_onCollideWithPlayer_1_.addStat(AchievementList.DIAMONDS);
                }
                if (item == Items.BLAZE_ROD) {
                    p_onCollideWithPlayer_1_.addStat(AchievementList.BLAZE_ROD);
                }
                if (item == Items.DIAMOND && this.getThrower() != null && (entityplayer = this.world.getPlayerEntityByName(this.getThrower())) != null && entityplayer != p_onCollideWithPlayer_1_) {
                    entityplayer.addStat(AchievementList.DIAMONDS_TO_YOU);
                }
                FMLCommonHandler.instance().firePlayerItemPickupEvent(p_onCollideWithPlayer_1_, this);
                p_onCollideWithPlayer_1_.onItemPickup(this, i);
                if (itemstack.isEmpty()) {
                    this.setDead();
                    itemstack.setCount(i);
                }
                p_onCollideWithPlayer_1_.addStat(StatList.getObjectsPickedUpStats(item), i);
            }
        }
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getCustomNameTag() : I18n.translateToLocal("item." + this.getEntityItem().getUnlocalizedName());
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(int p_changeDimension_1_) {
        Entity entity = super.changeDimension(p_changeDimension_1_);
        if (!this.world.isRemote && entity instanceof EntityItem) {
            ((EntityItem)entity).searchForOtherItemsNearby();
        }
        return entity;
    }

    public ItemStack getEntityItem() {
        return this.getDataManager().get(ITEM);
    }

    public void setEntityItemStack(ItemStack p_setEntityItemStack_1_) {
        this.getDataManager().set(ITEM, p_setEntityItemStack_1_);
        this.getDataManager().setDirty(ITEM);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String p_setOwner_1_) {
        this.owner = p_setOwner_1_;
    }

    public String getThrower() {
        return this.thrower;
    }

    public void setThrower(String p_setThrower_1_) {
        this.thrower = p_setThrower_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAge() {
        return this.age;
    }

    public void setDefaultPickupDelay() {
        this.delayBeforeCanPickup = 10;
    }

    public void setNoPickupDelay() {
        this.delayBeforeCanPickup = 0;
    }

    public void setInfinitePickupDelay() {
        this.delayBeforeCanPickup = Short.MAX_VALUE;
    }

    public void setPickupDelay(int p_setPickupDelay_1_) {
        this.delayBeforeCanPickup = p_setPickupDelay_1_;
    }

    public boolean cannotPickup() {
        return this.delayBeforeCanPickup > 0;
    }

    public void setNoDespawn() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
        this.age = this.getEntityItem().getItem().getEntityLifespan(this.getEntityItem(), this.world) - 1;
    }
}

