/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityItemFrame
extends EntityHanging {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.createKey(EntityItemFrame.class, DataSerializers.OPTIONAL_ITEM_STACK);
    private static final DataParameter<Integer> ROTATION = EntityDataManager.createKey(EntityItemFrame.class, DataSerializers.VARINT);
    private float itemDropChance = 1.0f;

    public EntityItemFrame(World p_i1590_1_) {
        super(p_i1590_1_);
    }

    public EntityItemFrame(World p_i45852_1_, BlockPos p_i45852_2_, EnumFacing p_i45852_3_) {
        super(p_i45852_1_, p_i45852_2_);
        this.updateFacingWithBoundingBox(p_i45852_3_);
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(ITEM, ItemStack.EMPTY);
        this.getDataManager().register(ROTATION, 0);
    }

    @Override
    public float getCollisionBorderSize() {
        return 0.0f;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (!p_attackEntityFrom_1_.isExplosion() && !this.getDisplayedItem().isEmpty()) {
            if (!this.world.isRemote) {
                this.dropItemOrSelf(p_attackEntityFrom_1_.getEntity(), false);
                this.playSound(SoundEvents.ENTITY_ITEMFRAME_REMOVE_ITEM, 1.0f, 1.0f);
                this.setDisplayedItem(ItemStack.EMPTY);
            }
            return true;
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public int getWidthPixels() {
        return 12;
    }

    @Override
    public int getHeightPixels() {
        return 12;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double d0 = 16.0;
        return p_isInRangeToRenderDist_1_ < (d0 = d0 * 64.0 * EntityItemFrame.getRenderDistanceWeight()) * d0;
    }

    @Override
    public void onBroken(Entity p_onBroken_1_) {
        this.playSound(SoundEvents.ENTITY_ITEMFRAME_BREAK, 1.0f, 1.0f);
        this.dropItemOrSelf(p_onBroken_1_, true);
    }

    @Override
    public void playPlaceSound() {
        this.playSound(SoundEvents.ENTITY_ITEMFRAME_PLACE, 1.0f, 1.0f);
    }

    public void dropItemOrSelf(Entity p_dropItemOrSelf_1_, boolean p_dropItemOrSelf_2_) {
        if (this.world.getGameRules().getBoolean("doEntityDrops")) {
            ItemStack itemstack = this.getDisplayedItem();
            if (p_dropItemOrSelf_1_ instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)p_dropItemOrSelf_1_;
                if (entityplayer.capabilities.isCreativeMode) {
                    this.removeFrameFromMap(itemstack);
                    return;
                }
            }
            if (p_dropItemOrSelf_2_) {
                this.entityDropItem(new ItemStack(Items.ITEM_FRAME), 0.0f);
            }
            if (!itemstack.isEmpty() && this.rand.nextFloat() < this.itemDropChance) {
                itemstack = itemstack.copy();
                this.removeFrameFromMap(itemstack);
                this.entityDropItem(itemstack, 0.0f);
            }
        }
    }

    private void removeFrameFromMap(ItemStack p_removeFrameFromMap_1_) {
        if (!p_removeFrameFromMap_1_.isEmpty()) {
            if (p_removeFrameFromMap_1_.getItem() instanceof ItemMap) {
                MapData mapdata = ((ItemMap)p_removeFrameFromMap_1_.getItem()).getMapData(p_removeFrameFromMap_1_, this.world);
                mapdata.mapDecorations.remove("frame-" + this.getEntityId());
            }
            p_removeFrameFromMap_1_.setItemFrame(null);
        }
    }

    public ItemStack getDisplayedItem() {
        return this.getDataManager().get(ITEM);
    }

    public void setDisplayedItem(ItemStack p_setDisplayedItem_1_) {
        this.setDisplayedItemWithUpdate(p_setDisplayedItem_1_, true);
    }

    private void setDisplayedItemWithUpdate(ItemStack p_setDisplayedItemWithUpdate_1_, boolean p_setDisplayedItemWithUpdate_2_) {
        if (!p_setDisplayedItemWithUpdate_1_.isEmpty()) {
            p_setDisplayedItemWithUpdate_1_ = p_setDisplayedItemWithUpdate_1_.copy();
            p_setDisplayedItemWithUpdate_1_.setCount(1);
            p_setDisplayedItemWithUpdate_1_.setItemFrame(this);
        }
        this.getDataManager().set(ITEM, p_setDisplayedItemWithUpdate_1_);
        this.getDataManager().setDirty(ITEM);
        if (!p_setDisplayedItemWithUpdate_1_.isEmpty()) {
            this.playSound(SoundEvents.ENTITY_ITEMFRAME_ADD_ITEM, 1.0f, 1.0f);
        }
        if (p_setDisplayedItemWithUpdate_2_ && this.hangingPosition != null) {
            this.world.updateComparatorOutputLevel(this.hangingPosition, Blocks.AIR);
        }
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        ItemStack itemstack;
        if (p_notifyDataManagerChange_1_.equals(ITEM) && !(itemstack = this.getDisplayedItem()).isEmpty() && itemstack.getItemFrame() != this) {
            itemstack.setItemFrame(this);
        }
    }

    public int getRotation() {
        return this.getDataManager().get(ROTATION);
    }

    public void setItemRotation(int p_setItemRotation_1_) {
        this.setRotation(p_setItemRotation_1_, true);
    }

    private void setRotation(int p_setRotation_1_, boolean p_setRotation_2_) {
        this.getDataManager().set(ROTATION, p_setRotation_1_ % 8);
        if (p_setRotation_2_ && this.hangingPosition != null) {
            this.world.updateComparatorOutputLevel(this.hangingPosition, Blocks.AIR);
        }
    }

    public static void registerFixesItemFrame(DataFixer p_registerFixesItemFrame_0_) {
        p_registerFixesItemFrame_0_.registerWalker(FixTypes.ENTITY, new ItemStackData(EntityItemFrame.class, "Item"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        if (!this.getDisplayedItem().isEmpty()) {
            p_writeEntityToNBT_1_.setTag("Item", this.getDisplayedItem().writeToNBT(new NBTTagCompound()));
            p_writeEntityToNBT_1_.setByte("ItemRotation", (byte)this.getRotation());
            p_writeEntityToNBT_1_.setFloat("ItemDropChance", this.itemDropChance);
        }
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        NBTTagCompound nbttagcompound = p_readEntityFromNBT_1_.getCompoundTag("Item");
        if (nbttagcompound != null && !nbttagcompound.hasNoTags()) {
            this.setDisplayedItemWithUpdate(new ItemStack(nbttagcompound), false);
            this.setRotation(p_readEntityFromNBT_1_.getByte("ItemRotation"), false);
            if (p_readEntityFromNBT_1_.hasKey("ItemDropChance", 99)) {
                this.itemDropChance = p_readEntityFromNBT_1_.getFloat("ItemDropChance");
            }
        }
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        ItemStack itemstack = p_processInitialInteract_1_.getHeldItem(p_processInitialInteract_2_);
        if (!this.world.isRemote) {
            if (this.getDisplayedItem().isEmpty()) {
                if (!itemstack.isEmpty()) {
                    this.setDisplayedItem(itemstack);
                    if (!p_processInitialInteract_1_.capabilities.isCreativeMode) {
                        itemstack.shrink(1);
                    }
                }
            } else {
                this.playSound(SoundEvents.ENTITY_ITEMFRAME_ROTATE_ITEM, 1.0f, 1.0f);
                this.setItemRotation(this.getRotation() + 1);
            }
        }
        return true;
    }

    public int getAnalogOutput() {
        return this.getDisplayedItem().isEmpty() ? 0 : this.getRotation() % 8 + 1;
    }
}

