/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMinecart
extends Entity
implements IWorldNameable {
    private static final DataParameter<Integer> ROLLING_AMPLITUDE = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> ROLLING_DIRECTION = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> DISPLAY_TILE = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> DISPLAY_TILE_OFFSET = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.VARINT);
    private static final DataParameter<Boolean> SHOW_BLOCK = EntityDataManager.createKey(EntityMinecart.class, DataSerializers.BOOLEAN);
    private boolean isInReverse;
    private static final int[][][] MATRIX = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    public static float defaultMaxSpeedAirLateral = 0.4f;
    public static float defaultMaxSpeedAirVertical = -1.0f;
    public static double defaultDragAir = 0.95f;
    protected boolean canUseRail = true;
    protected boolean canBePushed = true;
    private static IMinecartCollisionHandler collisionHandler = null;
    private float currentSpeedRail = this.getMaxCartSpeedOnRail();
    protected float maxSpeedAirLateral = defaultMaxSpeedAirLateral;
    protected float maxSpeedAirVertical = defaultMaxSpeedAirVertical;
    protected double dragAir = defaultDragAir;

    public EntityMinecart(World p_i1712_1_) {
        super(p_i1712_1_);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
    }

    public static EntityMinecart create(World p_create_0_, double p_create_1_, double p_create_3_, double p_create_5_, Type p_create_7_) {
        switch (p_create_7_) {
            case CHEST: {
                return new EntityMinecartChest(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
            }
            case FURNACE: {
                return new EntityMinecartFurnace(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
            }
            case TNT: {
                return new EntityMinecartTNT(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
            }
            case SPAWNER: {
                return new EntityMinecartMobSpawner(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
            }
            case HOPPER: {
                return new EntityMinecartHopper(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
            }
            case COMMAND_BLOCK: {
                return new EntityMinecartCommandBlock(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
            }
        }
        return new EntityMinecartEmpty(p_create_0_, p_create_1_, p_create_3_, p_create_5_);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(ROLLING_AMPLITUDE, 0);
        this.dataManager.register(ROLLING_DIRECTION, 1);
        this.dataManager.register(DAMAGE, Float.valueOf(0.0f));
        this.dataManager.register(DISPLAY_TILE, 0);
        this.dataManager.register(DISPLAY_TILE_OFFSET, 6);
        this.dataManager.register(SHOW_BLOCK, false);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBox(Entity p_getCollisionBox_1_) {
        if (EntityMinecart.getCollisionHandler() != null) {
            return EntityMinecart.getCollisionHandler().getCollisionBox(this, p_getCollisionBox_1_);
        }
        return p_getCollisionBox_1_.canBePushed() ? p_getCollisionBox_1_.getEntityBoundingBox() : null;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        if (EntityMinecart.getCollisionHandler() != null) {
            return EntityMinecart.getCollisionHandler().getBoundingBox(this);
        }
        return null;
    }

    @Override
    public boolean canBePushed() {
        return this.canBePushed;
    }

    public EntityMinecart(World p_i1713_1_, double p_i1713_2_, double p_i1713_4_, double p_i1713_6_) {
        this(p_i1713_1_);
        this.setPosition(p_i1713_2_, p_i1713_4_, p_i1713_6_);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = p_i1713_2_;
        this.prevPosY = p_i1713_4_;
        this.prevPosZ = p_i1713_6_;
    }

    @Override
    public double getMountedYOffset() {
        return 0.0;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (!this.world.isRemote && !this.isDead) {
            boolean flag;
            if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
                return false;
            }
            this.setRollingDirection(-this.getRollingDirection());
            this.setRollingAmplitude(10);
            this.setBeenAttacked();
            this.setDamage(this.getDamage() + p_attackEntityFrom_2_ * 10.0f);
            boolean bl = flag = p_attackEntityFrom_1_.getEntity() instanceof EntityPlayer && ((EntityPlayer)p_attackEntityFrom_1_.getEntity()).capabilities.isCreativeMode;
            if (flag || this.getDamage() > 40.0f) {
                this.removePassengers();
                if (flag && !this.hasCustomName()) {
                    this.setDead();
                } else {
                    this.killMinecart(p_attackEntityFrom_1_);
                }
            }
            return true;
        }
        return true;
    }

    public void killMinecart(DamageSource p_killMinecart_1_) {
        this.setDead();
        if (this.world.getGameRules().getBoolean("doEntityDrops")) {
            ItemStack itemstack = new ItemStack(Items.MINECART, 1);
            if (this.hasCustomName()) {
                itemstack.setStackDisplayName(this.getCustomNameTag());
            }
            this.entityDropItem(itemstack, 0.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
        this.setRollingDirection(-this.getRollingDirection());
        this.setRollingAmplitude(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public EnumFacing getAdjustedHorizontalFacing() {
        return this.isInReverse ? this.getHorizontalFacing().getOpposite().rotateY() : this.getHorizontalFacing().rotateY();
    }

    @Override
    public void onUpdate() {
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.world.isRemote && this.world instanceof WorldServer) {
            this.world.theProfiler.startSection("portal");
            MinecraftServer minecraftserver = this.world.getMinecraftServer();
            int i = this.getMaxInPortalTime();
            if (this.inPortal) {
                if (minecraftserver.getAllowNether()) {
                    if (!this.isRiding() && this.portalCounter++ >= i) {
                        this.portalCounter = i;
                        this.timeUntilPortal = this.getPortalCooldown();
                        int j = this.world.provider.getDimensionType().getId() == -1 ? 0 : -1;
                        this.changeDimension(j);
                    }
                    this.inPortal = false;
                }
            } else {
                if (this.portalCounter > 0) {
                    this.portalCounter -= 4;
                }
                if (this.portalCounter < 0) {
                    this.portalCounter = 0;
                }
            }
            if (this.timeUntilPortal > 0) {
                --this.timeUntilPortal;
            }
            this.world.theProfiler.endSection();
        }
        if (this.world.isRemote) {
            if (this.turnProgress > 0) {
                double d4 = this.posX + (this.minecartX - this.posX) / (double)this.turnProgress;
                double d5 = this.posY + (this.minecartY - this.posY) / (double)this.turnProgress;
                double d6 = this.posZ + (this.minecartZ - this.posZ) / (double)this.turnProgress;
                double d1 = MathHelper.wrapDegrees(this.minecartYaw - (double)this.rotationYaw);
                this.rotationYaw = (float)((double)this.rotationYaw + d1 / (double)this.turnProgress);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.minecartPitch - (double)this.rotationPitch) / (double)this.turnProgress);
                --this.turnProgress;
                this.setPosition(d4, d5, d6);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
        } else {
            double d3;
            int i1;
            int l;
            int k;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            if (!this.hasNoGravity()) {
                this.motionY -= (double)0.04f;
            }
            if (BlockRailBase.isRailBlock(this.world, new BlockPos(k = MathHelper.floor(this.posX), (l = MathHelper.floor(this.posY)) - 1, i1 = MathHelper.floor(this.posZ)))) {
                --l;
            }
            BlockPos blockpos = new BlockPos(k, l, i1);
            IBlockState iblockstate = this.world.getBlockState(blockpos);
            if (this.canUseRail() && BlockRailBase.isRailBlock(iblockstate)) {
                this.moveAlongTrack(blockpos, iblockstate);
                if (iblockstate.getBlock() == Blocks.ACTIVATOR_RAIL) {
                    this.onActivatorRailPass(k, l, i1, iblockstate.getValue(BlockRailPowered.POWERED));
                }
            } else {
                this.moveDerailedMinecart();
            }
            this.doBlockCollisions();
            this.rotationPitch = 0.0f;
            double d0 = this.prevPosX - this.posX;
            double d2 = this.prevPosZ - this.posZ;
            if (d0 * d0 + d2 * d2 > 0.001) {
                this.rotationYaw = (float)(MathHelper.atan2(d2, d0) * 180.0 / Math.PI);
                if (this.isInReverse) {
                    this.rotationYaw += 180.0f;
                }
            }
            if ((d3 = (double)MathHelper.wrapDegrees(this.rotationYaw - this.prevRotationYaw)) < -170.0 || d3 >= 170.0) {
                this.rotationYaw += 180.0f;
                this.isInReverse = !this.isInReverse;
            }
            this.setRotation(this.rotationYaw, this.rotationPitch);
            AxisAlignedBB box = EntityMinecart.getCollisionHandler() != null ? EntityMinecart.getCollisionHandler().getMinecartCollisionBox(this) : this.getEntityBoundingBox().expand(0.2f, 0.0, 0.2f);
            if (this.canBeRidden() && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01) {
                List<Entity> list = this.world.getEntitiesInAABBexcluding(this, box, EntitySelectors.getTeamCollisionPredicate(this));
                if (!list.isEmpty()) {
                    for (int j1 = 0; j1 < list.size(); ++j1) {
                        Entity entity1 = list.get(j1);
                        if (!(entity1 instanceof EntityPlayer || entity1 instanceof EntityIronGolem || entity1 instanceof EntityMinecart || this.isBeingRidden() || entity1.isRiding())) {
                            entity1.startRiding(this);
                            continue;
                        }
                        entity1.applyEntityCollision(this);
                    }
                }
            } else {
                for (Entity entity : this.world.getEntitiesWithinAABBExcludingEntity(this, box)) {
                    if (this.isPassenger(entity) || !entity.canBePushed() || !(entity instanceof EntityMinecart)) continue;
                    entity.applyEntityCollision(this);
                }
            }
            this.handleWaterMovement();
            MinecraftForge.EVENT_BUS.post(new MinecartUpdateEvent(this, this.getCurrentRailPosition()));
        }
    }

    protected double getMaximumSpeed() {
        return 0.4;
    }

    public void onActivatorRailPass(int p_onActivatorRailPass_1_, int p_onActivatorRailPass_2_, int p_onActivatorRailPass_3_, boolean p_onActivatorRailPass_4_) {
    }

    protected void moveDerailedMinecart() {
        double d0 = this.onGround ? this.getMaximumSpeed() : (double)this.getMaxSpeedAirLateral();
        this.motionX = MathHelper.clamp(this.motionX, -d0, d0);
        this.motionZ = MathHelper.clamp(this.motionZ, -d0, d0);
        double moveY = this.motionY;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.motionY > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.motionX) < (double)0.3f && Math.abs(this.motionZ) < (double)0.3f) {
                this.motionY = moveY = (double)0.15f;
            }
        }
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.move(MoverType.SELF, this.motionX, moveY, this.motionZ);
        if (!this.onGround) {
            this.motionX *= this.getDragAir();
            this.motionY *= this.getDragAir();
            this.motionZ *= this.getDragAir();
        }
    }

    protected void moveAlongTrack(BlockPos p_moveAlongTrack_1_, IBlockState p_moveAlongTrack_2_) {
        double d10;
        double d6;
        Entity entity;
        double d5;
        this.fallDistance = 0.0f;
        Vec3d vec3d = this.getPos(this.posX, this.posY, this.posZ);
        this.posY = p_moveAlongTrack_1_.getY();
        boolean flag = false;
        boolean flag1 = false;
        BlockRailBase blockrailbase = (BlockRailBase)p_moveAlongTrack_2_.getBlock();
        if (blockrailbase == Blocks.GOLDEN_RAIL) {
            flag = p_moveAlongTrack_2_.getValue(BlockRailPowered.POWERED);
            flag1 = !flag;
        }
        double slopeAdjustment = this.getSlopeAdjustment();
        BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = blockrailbase.getRailDirection(this.world, p_moveAlongTrack_1_, p_moveAlongTrack_2_, this);
        switch (blockrailbase$enumraildirection) {
            case ASCENDING_EAST: {
                this.motionX -= slopeAdjustment;
                this.posY += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.motionX += slopeAdjustment;
                this.posY += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.motionZ += slopeAdjustment;
                this.posY += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.motionZ -= slopeAdjustment;
                this.posY += 1.0;
            }
        }
        int[][] aint = MATRIX[blockrailbase$enumraildirection.getMetadata()];
        double d1 = aint[1][0] - aint[0][0];
        double d2 = aint[1][2] - aint[0][2];
        double d3 = Math.sqrt(d1 * d1 + d2 * d2);
        double d4 = this.motionX * d1 + this.motionZ * d2;
        if (d4 < 0.0) {
            d1 = -d1;
            d2 = -d2;
        }
        if ((d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ)) > 2.0) {
            d5 = 2.0;
        }
        this.motionX = d5 * d1 / d3;
        this.motionZ = d5 * d2 / d3;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : this.getPassengers().get(0);
        if (entity instanceof EntityLivingBase && (d6 = (double)((EntityLivingBase)entity).moveForward) > 0.0) {
            double d7 = -Math.sin(entity.rotationYaw * ((float)Math.PI / 180));
            double d8 = Math.cos(entity.rotationYaw * ((float)Math.PI / 180));
            double d9 = this.motionX * this.motionX + this.motionZ * this.motionZ;
            if (d9 < 0.01) {
                this.motionX += d7 * 0.1;
                this.motionZ += d8 * 0.1;
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            double d17 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (d17 < 0.03) {
                this.motionX *= 0.0;
                this.motionY *= 0.0;
                this.motionZ *= 0.0;
            } else {
                this.motionX *= 0.5;
                this.motionY *= 0.0;
                this.motionZ *= 0.5;
            }
        }
        double d18 = (double)p_moveAlongTrack_1_.getX() + 0.5 + (double)aint[0][0] * 0.5;
        double d19 = (double)p_moveAlongTrack_1_.getZ() + 0.5 + (double)aint[0][2] * 0.5;
        double d20 = (double)p_moveAlongTrack_1_.getX() + 0.5 + (double)aint[1][0] * 0.5;
        double d21 = (double)p_moveAlongTrack_1_.getZ() + 0.5 + (double)aint[1][2] * 0.5;
        d1 = d20 - d18;
        d2 = d21 - d19;
        if (d1 == 0.0) {
            this.posX = (double)p_moveAlongTrack_1_.getX() + 0.5;
            d10 = this.posZ - (double)p_moveAlongTrack_1_.getZ();
        } else if (d2 == 0.0) {
            this.posZ = (double)p_moveAlongTrack_1_.getZ() + 0.5;
            d10 = this.posX - (double)p_moveAlongTrack_1_.getX();
        } else {
            double d11 = this.posX - d18;
            double d12 = this.posZ - d19;
            d10 = (d11 * d1 + d12 * d2) * 2.0;
        }
        this.posX = d18 + d1 * d10;
        this.posZ = d19 + d2 * d10;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.moveMinecartOnRail(p_moveAlongTrack_1_);
        if (aint[0][1] != 0 && MathHelper.floor(this.posX) - p_moveAlongTrack_1_.getX() == aint[0][0] && MathHelper.floor(this.posZ) - p_moveAlongTrack_1_.getZ() == aint[0][2]) {
            this.setPosition(this.posX, this.posY + (double)aint[0][1], this.posZ);
        } else if (aint[1][1] != 0 && MathHelper.floor(this.posX) - p_moveAlongTrack_1_.getX() == aint[1][0] && MathHelper.floor(this.posZ) - p_moveAlongTrack_1_.getZ() == aint[1][2]) {
            this.setPosition(this.posX, this.posY + (double)aint[1][1], this.posZ);
        }
        this.applyDrag();
        Vec3d vec3d1 = this.getPos(this.posX, this.posY, this.posZ);
        if (vec3d1 != null && vec3d != null) {
            double d14 = (vec3d.yCoord - vec3d1.yCoord) * 0.05;
            d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (d5 > 0.0) {
                this.motionX = this.motionX / d5 * (d5 + d14);
                this.motionZ = this.motionZ / d5 * (d5 + d14);
            }
            this.setPosition(this.posX, vec3d1.yCoord, this.posZ);
        }
        int j = MathHelper.floor(this.posX);
        int i = MathHelper.floor(this.posZ);
        if (j != p_moveAlongTrack_1_.getX() || i != p_moveAlongTrack_1_.getZ()) {
            d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.motionX = d5 * (double)(j - p_moveAlongTrack_1_.getX());
            this.motionZ = d5 * (double)(i - p_moveAlongTrack_1_.getZ());
        }
        if (this.shouldDoRailFunctions()) {
            ((BlockRailBase)p_moveAlongTrack_2_.getBlock()).onMinecartPass(this.world, this, p_moveAlongTrack_1_);
        }
        if (flag && this.shouldDoRailFunctions()) {
            double d15 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            if (d15 > 0.01) {
                double d16 = 0.06;
                this.motionX += this.motionX / d15 * 0.06;
                this.motionZ += this.motionZ / d15 * 0.06;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.EAST_WEST) {
                if (this.world.getBlockState(p_moveAlongTrack_1_.west()).isNormalCube()) {
                    this.motionX = 0.02;
                } else if (this.world.getBlockState(p_moveAlongTrack_1_.east()).isNormalCube()) {
                    this.motionX = -0.02;
                }
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                if (this.world.getBlockState(p_moveAlongTrack_1_.north()).isNormalCube()) {
                    this.motionZ = 0.02;
                } else if (this.world.getBlockState(p_moveAlongTrack_1_.south()).isNormalCube()) {
                    this.motionZ = -0.02;
                }
            }
        }
    }

    protected void applyDrag() {
        if (this.isBeingRidden()) {
            this.motionX *= (double)0.997f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.997f;
        } else {
            this.motionX *= (double)0.96f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.96f;
        }
    }

    @Override
    public void setPosition(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        this.posX = p_setPosition_1_;
        this.posY = p_setPosition_3_;
        this.posZ = p_setPosition_5_;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.setEntityBoundingBox(new AxisAlignedBB(p_setPosition_1_ - (double)f, p_setPosition_3_, p_setPosition_5_ - (double)f, p_setPosition_1_ + (double)f, p_setPosition_3_ + (double)f1, p_setPosition_5_ + (double)f));
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Vec3d getPosOffset(double p_getPosOffset_1_, double p_getPosOffset_3_, double p_getPosOffset_5_, double p_getPosOffset_7_) {
        IBlockState iblockstate;
        int k;
        int j;
        int i = MathHelper.floor(p_getPosOffset_1_);
        if (BlockRailBase.isRailBlock(this.world, new BlockPos(i, (j = MathHelper.floor(p_getPosOffset_3_)) - 1, k = MathHelper.floor(p_getPosOffset_5_)))) {
            --j;
        }
        if (BlockRailBase.isRailBlock(iblockstate = this.world.getBlockState(new BlockPos(i, j, k)))) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = ((BlockRailBase)iblockstate.getBlock()).getRailDirection(this.world, new BlockPos(i, j, k), iblockstate, this);
            p_getPosOffset_3_ = j;
            if (blockrailbase$enumraildirection.isAscending()) {
                p_getPosOffset_3_ = j + 1;
            }
            int[][] aint = MATRIX[blockrailbase$enumraildirection.getMetadata()];
            double d0 = aint[1][0] - aint[0][0];
            double d1 = aint[1][2] - aint[0][2];
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            if (aint[0][1] != 0 && MathHelper.floor(p_getPosOffset_1_ += (d0 /= d2) * p_getPosOffset_7_) - i == aint[0][0] && MathHelper.floor(p_getPosOffset_5_ += (d1 /= d2) * p_getPosOffset_7_) - k == aint[0][2]) {
                p_getPosOffset_3_ += (double)aint[0][1];
            } else if (aint[1][1] != 0 && MathHelper.floor(p_getPosOffset_1_) - i == aint[1][0] && MathHelper.floor(p_getPosOffset_5_) - k == aint[1][2]) {
                p_getPosOffset_3_ += (double)aint[1][1];
            }
            return this.getPos(p_getPosOffset_1_, p_getPosOffset_3_, p_getPosOffset_5_);
        }
        return null;
    }

    @Nullable
    public Vec3d getPos(double p_getPos_1_, double p_getPos_3_, double p_getPos_5_) {
        IBlockState iblockstate;
        int k;
        int j;
        int i = MathHelper.floor(p_getPos_1_);
        if (BlockRailBase.isRailBlock(this.world, new BlockPos(i, (j = MathHelper.floor(p_getPos_3_)) - 1, k = MathHelper.floor(p_getPos_5_)))) {
            --j;
        }
        if (BlockRailBase.isRailBlock(iblockstate = this.world.getBlockState(new BlockPos(i, j, k)))) {
            double d9;
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = ((BlockRailBase)iblockstate.getBlock()).getRailDirection(this.world, new BlockPos(i, j, k), iblockstate, this);
            int[][] aint = MATRIX[blockrailbase$enumraildirection.getMetadata()];
            double d0 = (double)i + 0.5 + (double)aint[0][0] * 0.5;
            double d1 = (double)j + 0.0625 + (double)aint[0][1] * 0.5;
            double d2 = (double)k + 0.5 + (double)aint[0][2] * 0.5;
            double d3 = (double)i + 0.5 + (double)aint[1][0] * 0.5;
            double d4 = (double)j + 0.0625 + (double)aint[1][1] * 0.5;
            double d5 = (double)k + 0.5 + (double)aint[1][2] * 0.5;
            double d6 = d3 - d0;
            double d7 = (d4 - d1) * 2.0;
            double d8 = d5 - d2;
            if (d6 == 0.0) {
                d9 = p_getPos_5_ - (double)k;
            } else if (d8 == 0.0) {
                d9 = p_getPos_1_ - (double)i;
            } else {
                double d10 = p_getPos_1_ - d0;
                double d11 = p_getPos_5_ - d2;
                d9 = (d10 * d6 + d11 * d8) * 2.0;
            }
            p_getPos_1_ = d0 + d6 * d9;
            p_getPos_3_ = d1 + d7 * d9;
            p_getPos_5_ = d2 + d8 * d9;
            if (d7 < 0.0) {
                p_getPos_3_ += 1.0;
            }
            if (d7 > 0.0) {
                p_getPos_3_ += 0.5;
            }
            return new Vec3d(p_getPos_1_, p_getPos_3_, p_getPos_5_);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
        return this.hasDisplayTile() ? axisalignedbb.expandXyz((double)Math.abs(this.getDisplayTileOffset()) / 16.0) : axisalignedbb;
    }

    public static void registerFixesMinecart(DataFixer p_registerFixesMinecart_0_, Class<?> p_registerFixesMinecart_1_) {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        if (p_readEntityFromNBT_1_.getBoolean("CustomDisplayTile")) {
            Block block = p_readEntityFromNBT_1_.hasKey("DisplayTile", 8) ? Block.getBlockFromName(p_readEntityFromNBT_1_.getString("DisplayTile")) : Block.getBlockById(p_readEntityFromNBT_1_.getInteger("DisplayTile"));
            int i = p_readEntityFromNBT_1_.getInteger("DisplayData");
            this.setDisplayTile(block == null ? Blocks.AIR.getDefaultState() : block.getStateFromMeta(i));
            this.setDisplayTileOffset(p_readEntityFromNBT_1_.getInteger("DisplayOffset"));
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        if (this.hasDisplayTile()) {
            p_writeEntityToNBT_1_.setBoolean("CustomDisplayTile", true);
            IBlockState iblockstate = this.getDisplayTile();
            ResourceLocation resourcelocation = Block.REGISTRY.getNameForObject(iblockstate.getBlock());
            p_writeEntityToNBT_1_.setString("DisplayTile", resourcelocation == null ? "" : resourcelocation.toString());
            p_writeEntityToNBT_1_.setInteger("DisplayData", iblockstate.getBlock().getMetaFromState(iblockstate));
            p_writeEntityToNBT_1_.setInteger("DisplayOffset", this.getDisplayTileOffset());
        }
    }

    @Override
    public void applyEntityCollision(Entity p_applyEntityCollision_1_) {
        double d1;
        double d0;
        double d2;
        MinecraftForge.EVENT_BUS.post(new MinecartCollisionEvent(this, p_applyEntityCollision_1_));
        if (EntityMinecart.getCollisionHandler() != null) {
            EntityMinecart.getCollisionHandler().onEntityCollision(this, p_applyEntityCollision_1_);
            return;
        }
        if (!(this.world.isRemote || p_applyEntityCollision_1_.noClip || this.noClip || this.isPassenger(p_applyEntityCollision_1_) || !((d2 = (d0 = p_applyEntityCollision_1_.posX - this.posX) * d0 + (d1 = p_applyEntityCollision_1_.posZ - this.posZ) * d1) >= (double)1.0E-4f))) {
            d2 = MathHelper.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= (double)(1.0f - this.entityCollisionReduction);
            d1 *= (double)(1.0f - this.entityCollisionReduction);
            d0 *= 0.5;
            d1 *= 0.5;
            if (p_applyEntityCollision_1_ instanceof EntityMinecart) {
                Vec3d vec3d1;
                double d4 = p_applyEntityCollision_1_.posX - this.posX;
                double d5 = p_applyEntityCollision_1_.posZ - this.posZ;
                Vec3d vec3d = new Vec3d(d4, 0.0, d5).normalize();
                double d6 = Math.abs(vec3d.dotProduct(vec3d1 = new Vec3d(MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)), 0.0, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180))).normalize()));
                if (d6 < (double)0.8f) {
                    return;
                }
                double d7 = p_applyEntityCollision_1_.motionX + this.motionX;
                double d8 = p_applyEntityCollision_1_.motionZ + this.motionZ;
                if (((EntityMinecart)p_applyEntityCollision_1_).isPoweredCart() && !this.isPoweredCart()) {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity(p_applyEntityCollision_1_.motionX - d0, 0.0, p_applyEntityCollision_1_.motionZ - d1);
                    p_applyEntityCollision_1_.motionX *= (double)0.95f;
                    p_applyEntityCollision_1_.motionZ *= (double)0.95f;
                } else if (!((EntityMinecart)p_applyEntityCollision_1_).isPoweredCart() && this.isPoweredCart()) {
                    p_applyEntityCollision_1_.motionX *= (double)0.2f;
                    p_applyEntityCollision_1_.motionZ *= (double)0.2f;
                    p_applyEntityCollision_1_.addVelocity(this.motionX + d0, 0.0, this.motionZ + d1);
                    this.motionX *= (double)0.95f;
                    this.motionZ *= (double)0.95f;
                } else {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity((d7 /= 2.0) - d0, 0.0, (d8 /= 2.0) - d1);
                    p_applyEntityCollision_1_.motionX *= (double)0.2f;
                    p_applyEntityCollision_1_.motionZ *= (double)0.2f;
                    p_applyEntityCollision_1_.addVelocity(d7 + d0, 0.0, d8 + d1);
                }
            } else {
                this.addVelocity(-d0, 0.0, -d1);
                p_applyEntityCollision_1_.addVelocity(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.minecartX = p_setPositionAndRotationDirect_1_;
        this.minecartY = p_setPositionAndRotationDirect_3_;
        this.minecartZ = p_setPositionAndRotationDirect_5_;
        this.minecartYaw = p_setPositionAndRotationDirect_7_;
        this.minecartPitch = p_setPositionAndRotationDirect_8_;
        this.turnProgress = p_setPositionAndRotationDirect_9_ + 2;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    public void setDamage(float p_setDamage_1_) {
        this.dataManager.set(DAMAGE, Float.valueOf(p_setDamage_1_));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
        this.velocityX = this.motionX;
        this.velocityY = this.motionY;
        this.velocityZ = this.motionZ;
    }

    public float getDamage() {
        return this.dataManager.get(DAMAGE).floatValue();
    }

    public void setRollingAmplitude(int p_setRollingAmplitude_1_) {
        this.dataManager.set(ROLLING_AMPLITUDE, p_setRollingAmplitude_1_);
    }

    public int getRollingAmplitude() {
        return this.dataManager.get(ROLLING_AMPLITUDE);
    }

    public void setRollingDirection(int p_setRollingDirection_1_) {
        this.dataManager.set(ROLLING_DIRECTION, p_setRollingDirection_1_);
    }

    public int getRollingDirection() {
        return this.dataManager.get(ROLLING_DIRECTION);
    }

    public abstract Type getType();

    public IBlockState getDisplayTile() {
        return !this.hasDisplayTile() ? this.getDefaultDisplayTile() : Block.getStateById(this.getDataManager().get(DISPLAY_TILE));
    }

    public IBlockState getDefaultDisplayTile() {
        return Blocks.AIR.getDefaultState();
    }

    public int getDisplayTileOffset() {
        return !this.hasDisplayTile() ? this.getDefaultDisplayTileOffset() : this.getDataManager().get(DISPLAY_TILE_OFFSET).intValue();
    }

    public int getDefaultDisplayTileOffset() {
        return 6;
    }

    public void setDisplayTile(IBlockState p_setDisplayTile_1_) {
        this.getDataManager().set(DISPLAY_TILE, Block.getStateId(p_setDisplayTile_1_));
        this.setHasDisplayTile(true);
    }

    public void setDisplayTileOffset(int p_setDisplayTileOffset_1_) {
        this.getDataManager().set(DISPLAY_TILE_OFFSET, p_setDisplayTileOffset_1_);
        this.setHasDisplayTile(true);
    }

    public boolean hasDisplayTile() {
        return this.getDataManager().get(SHOW_BLOCK);
    }

    public void setHasDisplayTile(boolean p_setHasDisplayTile_1_) {
        this.getDataManager().set(SHOW_BLOCK, p_setHasDisplayTile_1_);
    }

    private BlockPos getCurrentRailPosition() {
        int z;
        int y;
        int x = MathHelper.floor(this.posX);
        if (BlockRailBase.isRailBlock(this.world, new BlockPos(x, (y = MathHelper.floor(this.posY)) - 1, z = MathHelper.floor(this.posZ)))) {
            --y;
        }
        return new BlockPos(x, y, z);
    }

    protected double getMaxSpeed() {
        if (!this.canUseRail()) {
            return this.getMaximumSpeed();
        }
        BlockPos pos = this.getCurrentRailPosition();
        IBlockState state = this.world.getBlockState(pos);
        if (!BlockRailBase.isRailBlock(state)) {
            return this.getMaximumSpeed();
        }
        float railMaxSpeed = ((BlockRailBase)state.getBlock()).getRailMaxSpeed(this.world, this, pos);
        return Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
    }

    public void moveMinecartOnRail(BlockPos p_moveMinecartOnRail_1_) {
        double mX = this.motionX;
        double mZ = this.motionZ;
        if (this.isBeingRidden()) {
            mX *= 0.75;
            mZ *= 0.75;
        }
        double max = this.getMaxSpeed();
        mX = MathHelper.clamp(mX, -max, max);
        mZ = MathHelper.clamp(mZ, -max, max);
        this.move(MoverType.SELF, mX, 0.0, mZ);
    }

    public static IMinecartCollisionHandler getCollisionHandler() {
        return collisionHandler;
    }

    public static void setCollisionHandler(IMinecartCollisionHandler p_setCollisionHandler_0_) {
        collisionHandler = p_setCollisionHandler_0_;
    }

    public ItemStack getCartItem() {
        if (this instanceof EntityMinecartFurnace) {
            return new ItemStack(Items.FURNACE_MINECART);
        }
        if (this instanceof EntityMinecartChest) {
            return new ItemStack(Items.CHEST_MINECART);
        }
        if (this instanceof EntityMinecartTNT) {
            return new ItemStack(Items.TNT_MINECART);
        }
        if (this instanceof EntityMinecartHopper) {
            return new ItemStack(Items.HOPPER_MINECART);
        }
        if (this instanceof EntityMinecartCommandBlock) {
            return new ItemStack(Items.COMMAND_BLOCK_MINECART);
        }
        return new ItemStack(Items.MINECART);
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean p_setCanUseRail_1_) {
        this.canUseRail = p_setCanUseRail_1_;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    public boolean isPoweredCart() {
        return this.getType() == Type.FURNACE;
    }

    public boolean canBeRidden() {
        return this.getType() == Type.RIDEABLE;
    }

    public float getMaxCartSpeedOnRail() {
        return 1.2f;
    }

    public final float getCurrentCartSpeedCapOnRail() {
        return this.currentSpeedRail;
    }

    public final void setCurrentCartSpeedCapOnRail(float p_setCurrentCartSpeedCapOnRail_1_) {
        this.currentSpeedRail = p_setCurrentCartSpeedCapOnRail_1_ = Math.min(p_setCurrentCartSpeedCapOnRail_1_, this.getMaxCartSpeedOnRail());
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float p_setMaxSpeedAirLateral_1_) {
        this.maxSpeedAirLateral = p_setMaxSpeedAirLateral_1_;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float p_setMaxSpeedAirVertical_1_) {
        this.maxSpeedAirVertical = p_setMaxSpeedAirVertical_1_;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double p_setDragAir_1_) {
        this.dragAir = p_setDragAir_1_;
    }

    public double getSlopeAdjustment() {
        return 0.0078125;
    }

    public int getComparatorLevel() {
        return -1;
    }

    public static enum Type {
        RIDEABLE(0, "MinecartRideable"),
        CHEST(1, "MinecartChest"),
        FURNACE(2, "MinecartFurnace"),
        TNT(3, "MinecartTNT"),
        SPAWNER(4, "MinecartSpawner"),
        HOPPER(5, "MinecartHopper"),
        COMMAND_BLOCK(6, "MinecartCommandBlock");

        private static final Map<Integer, Type> BY_ID;
        private final int id;
        private final String name;

        private Type(int p_i47005_3_, String p_i47005_4_) {
            this.id = p_i47005_3_;
            this.name = p_i47005_4_;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @SideOnly(value=Side.CLIENT)
        public static Type getById(int p_getById_0_) {
            Type entityminecart$type = BY_ID.get(p_getById_0_);
            return entityminecart$type == null ? RIDEABLE : entityminecart$type;
        }

        static {
            BY_ID = Maps.newHashMap();
            for (Type entityminecart$type : Type.values()) {
                BY_ID.put(entityminecart$type.getId(), entityminecart$type);
            }
        }
    }
}

