/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMinecartCommandBlock
extends EntityMinecart {
    private static final DataParameter<String> COMMAND = EntityDataManager.createKey(EntityMinecartCommandBlock.class, DataSerializers.STRING);
    private static final DataParameter<ITextComponent> LAST_OUTPUT = EntityDataManager.createKey(EntityMinecartCommandBlock.class, DataSerializers.TEXT_COMPONENT);
    private final CommandBlockBaseLogic commandBlockLogic = new CommandBlockBaseLogic(){

        @Override
        public void updateCommand() {
            EntityMinecartCommandBlock.this.getDataManager().set(COMMAND, this.getCommand());
            EntityMinecartCommandBlock.this.getDataManager().set(LAST_OUTPUT, this.getLastOutput());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getCommandBlockType() {
            return 1;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void fillInInfo(ByteBuf p_fillInInfo_1_) {
            p_fillInInfo_1_.writeInt(EntityMinecartCommandBlock.this.getEntityId());
        }

        @Override
        public BlockPos getPosition() {
            return new BlockPos(EntityMinecartCommandBlock.this.posX, EntityMinecartCommandBlock.this.posY + 0.5, EntityMinecartCommandBlock.this.posZ);
        }

        @Override
        public Vec3d getPositionVector() {
            return new Vec3d(EntityMinecartCommandBlock.this.posX, EntityMinecartCommandBlock.this.posY, EntityMinecartCommandBlock.this.posZ);
        }

        @Override
        public World getEntityWorld() {
            return EntityMinecartCommandBlock.this.world;
        }

        @Override
        public Entity getCommandSenderEntity() {
            return EntityMinecartCommandBlock.this;
        }

        @Override
        public MinecraftServer getServer() {
            return EntityMinecartCommandBlock.this.world.getMinecraftServer();
        }
    };
    private int activatorRailCooldown;

    public EntityMinecartCommandBlock(World p_i46754_1_) {
        super(p_i46754_1_);
    }

    public EntityMinecartCommandBlock(World p_i46755_1_, double p_i46755_2_, double p_i46755_4_, double p_i46755_6_) {
        super(p_i46755_1_, p_i46755_2_, p_i46755_4_, p_i46755_6_);
    }

    public static void registerFixesMinecartCommand(DataFixer p_registerFixesMinecartCommand_0_) {
        EntityMinecart.registerFixesMinecart(p_registerFixesMinecartCommand_0_, EntityMinecartCommandBlock.class);
        p_registerFixesMinecartCommand_0_.registerWalker(FixTypes.ENTITY, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                if (TileEntity.getKey(TileEntityCommandBlock.class).equals(new ResourceLocation(p_process_2_.getString("id")))) {
                    p_process_2_.setString("id", "Control");
                    p_process_1_.process(FixTypes.BLOCK_ENTITY, p_process_2_, p_process_3_);
                    p_process_2_.setString("id", "MinecartCommandBlock");
                }
                return p_process_2_;
            }
        });
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataManager().register(COMMAND, "");
        this.getDataManager().register(LAST_OUTPUT, new TextComponentString(""));
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.commandBlockLogic.readDataFromNBT(p_readEntityFromNBT_1_);
        this.getDataManager().set(COMMAND, this.getCommandBlockLogic().getCommand());
        this.getDataManager().set(LAST_OUTPUT, this.getCommandBlockLogic().getLastOutput());
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        this.commandBlockLogic.writeToNBT(p_writeEntityToNBT_1_);
    }

    @Override
    public EntityMinecart.Type getType() {
        return EntityMinecart.Type.COMMAND_BLOCK;
    }

    @Override
    public IBlockState getDefaultDisplayTile() {
        return Blocks.COMMAND_BLOCK.getDefaultState();
    }

    public CommandBlockBaseLogic getCommandBlockLogic() {
        return this.commandBlockLogic;
    }

    @Override
    public void onActivatorRailPass(int p_onActivatorRailPass_1_, int p_onActivatorRailPass_2_, int p_onActivatorRailPass_3_, boolean p_onActivatorRailPass_4_) {
        if (p_onActivatorRailPass_4_ && this.ticksExisted - this.activatorRailCooldown >= 4) {
            this.getCommandBlockLogic().trigger(this.world);
            this.activatorRailCooldown = this.ticksExisted;
        }
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        if (MinecraftForge.EVENT_BUS.post(new MinecartInteractEvent(this, p_processInitialInteract_1_, p_processInitialInteract_2_))) {
            return true;
        }
        this.commandBlockLogic.tryOpenEditCommandBlock(p_processInitialInteract_1_);
        return false;
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
        if (LAST_OUTPUT.equals(p_notifyDataManagerChange_1_)) {
            try {
                this.commandBlockLogic.setLastOutput(this.getDataManager().get(LAST_OUTPUT));
            }
            catch (Throwable throwable) {}
        } else if (COMMAND.equals(p_notifyDataManagerChange_1_)) {
            this.commandBlockLogic.setCommand(this.getDataManager().get(COMMAND));
        }
    }

    @Override
    public boolean ignoreItemEntityData() {
        return true;
    }
}

