/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class EntityMinecartContainer
extends EntityMinecart
implements ILockableContainer,
ILootContainer {
    private NonNullList<ItemStack> minecartContainerItems = NonNullList.withSize(36, ItemStack.EMPTY);
    public boolean dropContentsWhenDead = true;
    private ResourceLocation lootTable;
    private long lootTableSeed;
    public IItemHandler itemHandler = new InvWrapper(this);

    public EntityMinecartContainer(World p_i1716_1_) {
        super(p_i1716_1_);
    }

    public EntityMinecartContainer(World p_i1717_1_, double p_i1717_2_, double p_i1717_4_, double p_i1717_6_) {
        super(p_i1717_1_, p_i1717_2_, p_i1717_4_, p_i1717_6_);
    }

    @Override
    public void killMinecart(DamageSource p_killMinecart_1_) {
        super.killMinecart(p_killMinecart_1_);
        if (this.world.getGameRules().getBoolean("doEntityDrops")) {
            InventoryHelper.dropInventoryItems(this.world, this, (IInventory)this);
        }
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.minecartContainerItems) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        this.addLoot(null);
        return this.minecartContainerItems.get(p_getStackInSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        this.addLoot(null);
        return ItemStackHelper.getAndSplit(this.minecartContainerItems, p_decrStackSize_1_, p_decrStackSize_2_);
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        this.addLoot(null);
        ItemStack itemstack = this.minecartContainerItems.get(p_removeStackFromSlot_1_);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.minecartContainerItems.set(p_removeStackFromSlot_1_, ItemStack.EMPTY);
        return itemstack;
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        this.addLoot(null);
        this.minecartContainerItems.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        if (!p_setInventorySlotContents_2_.isEmpty() && p_setInventorySlotContents_2_.getCount() > this.getInventoryStackLimit()) {
            p_setInventorySlotContents_2_.setCount(this.getInventoryStackLimit());
        }
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.isDead ? false : p_isUsableByPlayer_1_.getDistanceSqToEntity(this) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    @Nullable
    public Entity changeDimension(int p_changeDimension_1_) {
        this.dropContentsWhenDead = false;
        return super.changeDimension(p_changeDimension_1_);
    }

    @Override
    public void setDead() {
        if (this.dropContentsWhenDead) {
            InventoryHelper.dropInventoryItems(this.world, this, (IInventory)this);
        }
        super.setDead();
    }

    @Override
    public void setDropItemsWhenDead(boolean p_setDropItemsWhenDead_1_) {
        this.dropContentsWhenDead = p_setDropItemsWhenDead_1_;
    }

    public static void addDataFixers(DataFixer p_addDataFixers_0_, Class<?> p_addDataFixers_1_) {
        EntityMinecart.registerFixesMinecart(p_addDataFixers_0_, p_addDataFixers_1_);
        p_addDataFixers_0_.registerWalker(FixTypes.ENTITY, new ItemStackDataLists(p_addDataFixers_1_, "Items"));
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        if (this.lootTable != null) {
            p_writeEntityToNBT_1_.setString("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                p_writeEntityToNBT_1_.setLong("LootTableSeed", this.lootTableSeed);
            }
        } else {
            ItemStackHelper.saveAllItems(p_writeEntityToNBT_1_, this.minecartContainerItems);
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.minecartContainerItems = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        if (p_readEntityFromNBT_1_.hasKey("LootTable", 8)) {
            this.lootTable = new ResourceLocation(p_readEntityFromNBT_1_.getString("LootTable"));
            this.lootTableSeed = p_readEntityFromNBT_1_.getLong("LootTableSeed");
        } else {
            ItemStackHelper.loadAllItems(p_readEntityFromNBT_1_, this.minecartContainerItems);
        }
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        if (MinecraftForge.EVENT_BUS.post(new MinecartInteractEvent(this, p_processInitialInteract_1_, p_processInitialInteract_2_))) {
            return true;
        }
        if (!this.world.isRemote) {
            p_processInitialInteract_1_.displayGUIChest(this);
        }
        return true;
    }

    @Override
    protected void applyDrag() {
        float f = 0.98f;
        if (this.lootTable == null) {
            int i = 15 - Container.calcRedstoneFromInventory(this);
            f += (float)i * 0.001f;
        }
        this.motionX *= (double)f;
        this.motionY *= 0.0;
        this.motionZ *= (double)f;
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLockCode(LockCode p_setLockCode_1_) {
    }

    @Override
    public LockCode getLockCode() {
        return LockCode.EMPTY_CODE;
    }

    public void addLoot(EntityPlayer p_addLoot_1_) {
        if (this.lootTable != null) {
            LootTable loottable = this.world.getLootTableManager().getLootTableFromLocation(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.world);
            if (p_addLoot_1_ != null) {
                lootcontext$builder.withLuck(p_addLoot_1_.getLuck());
            }
            loottable.fillInventory(this, random, lootcontext$builder.build());
        }
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        if (p_getCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return super.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        return p_hasCapability_1_ == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }

    @Override
    public void clear() {
        this.addLoot(null);
        this.minecartContainerItems.clear();
    }

    public void setLootTable(ResourceLocation p_setLootTable_1_, long p_setLootTable_2_) {
        this.lootTable = p_setLootTable_1_;
        this.lootTableSeed = p_setLootTable_2_;
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }
}

