/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.block.BlockFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public class EntityMinecartFurnace
extends EntityMinecart {
    private static final DataParameter<Boolean> POWERED = EntityDataManager.createKey(EntityMinecartFurnace.class, DataSerializers.BOOLEAN);
    private int fuel;
    public double pushX;
    public double pushZ;

    public EntityMinecartFurnace(World p_i1718_1_) {
        super(p_i1718_1_);
    }

    public EntityMinecartFurnace(World p_i1719_1_, double p_i1719_2_, double p_i1719_4_, double p_i1719_6_) {
        super(p_i1719_1_, p_i1719_2_, p_i1719_4_, p_i1719_6_);
    }

    public static void registerFixesMinecartFurnace(DataFixer p_registerFixesMinecartFurnace_0_) {
        EntityMinecart.registerFixesMinecart(p_registerFixesMinecartFurnace_0_, EntityMinecartFurnace.class);
    }

    @Override
    public EntityMinecart.Type getType() {
        return EntityMinecart.Type.FURNACE;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(POWERED, false);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.fuel <= 0) {
            this.pushX = 0.0;
            this.pushZ = 0.0;
        }
        this.setMinecartPowered(this.fuel > 0);
        if (this.isMinecartPowered() && this.rand.nextInt(4) == 0) {
            this.world.spawnParticle(EnumParticleTypes.SMOKE_LARGE, this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected double getMaximumSpeed() {
        return 0.2;
    }

    @Override
    public void killMinecart(DamageSource p_killMinecart_1_) {
        super.killMinecart(p_killMinecart_1_);
        if (!p_killMinecart_1_.isExplosion() && this.world.getGameRules().getBoolean("doEntityDrops")) {
            this.entityDropItem(new ItemStack(Blocks.FURNACE, 1), 0.0f);
        }
    }

    @Override
    protected void moveAlongTrack(BlockPos p_moveAlongTrack_1_, IBlockState p_moveAlongTrack_2_) {
        super.moveAlongTrack(p_moveAlongTrack_1_, p_moveAlongTrack_2_);
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d0 > 1.0E-4 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.001) {
            d0 = MathHelper.sqrt(d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            if (this.pushX * this.motionX + this.pushZ * this.motionZ < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                double d1 = d0 / this.getMaximumSpeed();
                this.pushX *= d1;
                this.pushZ *= d1;
            }
        }
    }

    @Override
    protected void applyDrag() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d0 > 1.0E-4) {
            d0 = MathHelper.sqrt(d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d1 = 1.0;
            this.motionX *= (double)0.8f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.8f;
            this.motionX += this.pushX * 1.0;
            this.motionZ += this.pushZ * 1.0;
        } else {
            this.motionX *= (double)0.98f;
            this.motionY *= 0.0;
            this.motionZ *= (double)0.98f;
        }
        super.applyDrag();
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        ItemStack itemstack = p_processInitialInteract_1_.getHeldItem(p_processInitialInteract_2_);
        if (MinecraftForge.EVENT_BUS.post(new MinecartInteractEvent(this, p_processInitialInteract_1_, p_processInitialInteract_2_))) {
            return true;
        }
        if (itemstack.getItem() == Items.COAL && this.fuel + 3600 <= 32000) {
            if (!p_processInitialInteract_1_.capabilities.isCreativeMode) {
                itemstack.shrink(1);
            }
            this.fuel += 3600;
        }
        this.pushX = this.posX - p_processInitialInteract_1_.posX;
        this.pushZ = this.posZ - p_processInitialInteract_1_.posZ;
        return true;
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setDouble("PushX", this.pushX);
        p_writeEntityToNBT_1_.setDouble("PushZ", this.pushZ);
        p_writeEntityToNBT_1_.setShort("Fuel", (short)this.fuel);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.pushX = p_readEntityFromNBT_1_.getDouble("PushX");
        this.pushZ = p_readEntityFromNBT_1_.getDouble("PushZ");
        this.fuel = p_readEntityFromNBT_1_.getShort("Fuel");
    }

    protected boolean isMinecartPowered() {
        return this.dataManager.get(POWERED);
    }

    protected void setMinecartPowered(boolean p_setMinecartPowered_1_) {
        this.dataManager.set(POWERED, p_setMinecartPowered_1_);
    }

    @Override
    public IBlockState getDefaultDisplayTile() {
        return (this.isMinecartPowered() ? Blocks.LIT_FURNACE : Blocks.FURNACE).getDefaultState().withProperty(BlockFurnace.FACING, EnumFacing.NORTH);
    }
}

