/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public class EntityMinecartHopper
extends EntityMinecartContainer
implements IHopper {
    private boolean isBlocked = true;
    private int transferTicker = -1;
    private final BlockPos lastPosition = BlockPos.ORIGIN;

    public EntityMinecartHopper(World p_i1720_1_) {
        super(p_i1720_1_);
    }

    public EntityMinecartHopper(World p_i1721_1_, double p_i1721_2_, double p_i1721_4_, double p_i1721_6_) {
        super(p_i1721_1_, p_i1721_2_, p_i1721_4_, p_i1721_6_);
    }

    @Override
    public EntityMinecart.Type getType() {
        return EntityMinecart.Type.HOPPER;
    }

    @Override
    public IBlockState getDefaultDisplayTile() {
        return Blocks.HOPPER.getDefaultState();
    }

    @Override
    public int getDefaultDisplayTileOffset() {
        return 1;
    }

    @Override
    public int getSizeInventory() {
        return 5;
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        if (MinecraftForge.EVENT_BUS.post(new MinecartInteractEvent(this, p_processInitialInteract_1_, p_processInitialInteract_2_))) {
            return true;
        }
        if (!this.world.isRemote) {
            p_processInitialInteract_1_.displayGUIChest(this);
        }
        return true;
    }

    @Override
    public void onActivatorRailPass(int p_onActivatorRailPass_1_, int p_onActivatorRailPass_2_, int p_onActivatorRailPass_3_, boolean p_onActivatorRailPass_4_) {
        boolean flag;
        boolean bl = flag = !p_onActivatorRailPass_4_;
        if (flag != this.getBlocked()) {
            this.setBlocked(flag);
        }
    }

    public boolean getBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean p_setBlocked_1_) {
        this.isBlocked = p_setBlocked_1_;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public double getXPos() {
        return this.posX;
    }

    @Override
    public double getYPos() {
        return this.posY + 0.5;
    }

    @Override
    public double getZPos() {
        return this.posZ;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote && this.isEntityAlive() && this.getBlocked()) {
            BlockPos blockpos = new BlockPos(this);
            if (blockpos.equals(this.lastPosition)) {
                --this.transferTicker;
            } else {
                this.setTransferTicker(0);
            }
            if (!this.canTransfer()) {
                this.setTransferTicker(0);
                if (this.captureDroppedItems()) {
                    this.setTransferTicker(4);
                    this.markDirty();
                }
            }
        }
    }

    public boolean captureDroppedItems() {
        if (TileEntityHopper.captureDroppedItems(this)) {
            return true;
        }
        List<Entity> list = this.world.getEntitiesWithinAABB(EntityItem.class, this.getEntityBoundingBox().expand(0.25, 0.0, 0.25), EntitySelectors.IS_ALIVE);
        if (!list.isEmpty()) {
            TileEntityHopper.putDropInInventoryAllSlots(null, this, (EntityItem)list.get(0));
        }
        return false;
    }

    @Override
    public void killMinecart(DamageSource p_killMinecart_1_) {
        super.killMinecart(p_killMinecart_1_);
        if (this.world.getGameRules().getBoolean("doEntityDrops")) {
            this.dropItemWithOffset(Item.getItemFromBlock(Blocks.HOPPER), 1, 0.0f);
        }
    }

    public static void registerFixesMinecartHopper(DataFixer p_registerFixesMinecartHopper_0_) {
        EntityMinecartContainer.addDataFixers(p_registerFixesMinecartHopper_0_, EntityMinecartHopper.class);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("TransferCooldown", this.transferTicker);
        p_writeEntityToNBT_1_.setBoolean("Enabled", this.isBlocked);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.transferTicker = p_readEntityFromNBT_1_.getInteger("TransferCooldown");
        this.isBlocked = p_readEntityFromNBT_1_.hasKey("Enabled") ? p_readEntityFromNBT_1_.getBoolean("Enabled") : true;
    }

    public void setTransferTicker(int p_setTransferTicker_1_) {
        this.transferTicker = p_setTransferTicker_1_;
    }

    public boolean canTransfer() {
        return this.transferTicker > 0;
    }

    @Override
    public String getGuiID() {
        return "minecraft:hopper";
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerHopper(p_createContainer_1_, this, p_createContainer_2_);
    }
}

