/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMinecartMobSpawner
extends EntityMinecart {
    private final MobSpawnerBaseLogic mobSpawnerLogic = new MobSpawnerBaseLogic(){

        @Override
        public void broadcastEvent(int p_broadcastEvent_1_) {
            EntityMinecartMobSpawner.this.world.setEntityState(EntityMinecartMobSpawner.this, (byte)p_broadcastEvent_1_);
        }

        @Override
        public World getSpawnerWorld() {
            return EntityMinecartMobSpawner.this.world;
        }

        @Override
        public BlockPos getSpawnerPosition() {
            return new BlockPos(EntityMinecartMobSpawner.this);
        }
    };

    public EntityMinecartMobSpawner(World p_i46752_1_) {
        super(p_i46752_1_);
    }

    public EntityMinecartMobSpawner(World p_i46753_1_, double p_i46753_2_, double p_i46753_4_, double p_i46753_6_) {
        super(p_i46753_1_, p_i46753_2_, p_i46753_4_, p_i46753_6_);
    }

    public static void registerFixesMinecartMobSpawner(DataFixer p_registerFixesMinecartMobSpawner_0_) {
        EntityMinecartMobSpawner.registerFixesMinecart(p_registerFixesMinecartMobSpawner_0_, EntityMinecartMobSpawner.class);
        p_registerFixesMinecartMobSpawner_0_.registerWalker(FixTypes.ENTITY, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                String lvt_4_1_ = p_process_2_.getString("id");
                if (EntityList.getKey(EntityMinecartMobSpawner.class).equals(new ResourceLocation(lvt_4_1_))) {
                    p_process_2_.setString("id", TileEntity.getKey(TileEntityMobSpawner.class).toString());
                    p_process_1_.process(FixTypes.BLOCK_ENTITY, p_process_2_, p_process_3_);
                    p_process_2_.setString("id", lvt_4_1_);
                }
                return p_process_2_;
            }
        });
    }

    @Override
    public EntityMinecart.Type getType() {
        return EntityMinecart.Type.SPAWNER;
    }

    @Override
    public IBlockState getDefaultDisplayTile() {
        return Blocks.MOB_SPAWNER.getDefaultState();
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.mobSpawnerLogic.readFromNBT(p_readEntityFromNBT_1_);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        this.mobSpawnerLogic.writeToNBT(p_writeEntityToNBT_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        this.mobSpawnerLogic.setDelayToMin(p_handleStatusUpdate_1_);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.mobSpawnerLogic.updateSpawner();
    }
}

