/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMinecartTNT
extends EntityMinecart {
    private int minecartTNTFuse = -1;

    public EntityMinecartTNT(World p_i1727_1_) {
        super(p_i1727_1_);
    }

    public EntityMinecartTNT(World p_i1728_1_, double p_i1728_2_, double p_i1728_4_, double p_i1728_6_) {
        super(p_i1728_1_, p_i1728_2_, p_i1728_4_, p_i1728_6_);
    }

    public static void registerFixesMinecartTNT(DataFixer p_registerFixesMinecartTNT_0_) {
        EntityMinecart.registerFixesMinecart(p_registerFixesMinecartTNT_0_, EntityMinecartTNT.class);
    }

    @Override
    public EntityMinecart.Type getType() {
        return EntityMinecart.Type.TNT;
    }

    @Override
    public IBlockState getDefaultDisplayTile() {
        return Blocks.TNT.getDefaultState();
    }

    @Override
    public void onUpdate() {
        double lvt_1_1_;
        super.onUpdate();
        if (this.minecartTNTFuse > 0) {
            --this.minecartTNTFuse;
            this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        } else if (this.minecartTNTFuse == 0) {
            this.explodeCart(this.motionX * this.motionX + this.motionZ * this.motionZ);
        }
        if (this.isCollidedHorizontally && (lvt_1_1_ = this.motionX * this.motionX + this.motionZ * this.motionZ) >= (double)0.01f) {
            this.explodeCart(lvt_1_1_);
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        EntityArrow lvt_4_1_;
        Entity lvt_3_1_ = p_attackEntityFrom_1_.getSourceOfDamage();
        if (lvt_3_1_ instanceof EntityArrow && (lvt_4_1_ = (EntityArrow)lvt_3_1_).isBurning()) {
            this.explodeCart(lvt_4_1_.motionX * lvt_4_1_.motionX + lvt_4_1_.motionY * lvt_4_1_.motionY + lvt_4_1_.motionZ * lvt_4_1_.motionZ);
        }
        return super.attackEntityFrom(p_attackEntityFrom_1_, p_attackEntityFrom_2_);
    }

    @Override
    public void killMinecart(DamageSource p_killMinecart_1_) {
        super.killMinecart(p_killMinecart_1_);
        double lvt_2_1_ = this.motionX * this.motionX + this.motionZ * this.motionZ;
        if (!p_killMinecart_1_.isExplosion() && this.world.getGameRules().getBoolean("doEntityDrops")) {
            this.entityDropItem(new ItemStack(Blocks.TNT, 1), 0.0f);
        }
        if (p_killMinecart_1_.isFireDamage() || p_killMinecart_1_.isExplosion() || lvt_2_1_ >= (double)0.01f) {
            this.explodeCart(lvt_2_1_);
        }
    }

    protected void explodeCart(double p_explodeCart_1_) {
        if (!this.world.isRemote) {
            double lvt_3_1_ = Math.sqrt(p_explodeCart_1_);
            if (lvt_3_1_ > 5.0) {
                lvt_3_1_ = 5.0;
            }
            this.world.createExplosion(this, this.posX, this.posY, this.posZ, (float)(4.0 + this.rand.nextDouble() * 1.5 * lvt_3_1_), true);
            this.setDead();
        }
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
        if (p_fall_1_ >= 3.0f) {
            float lvt_3_1_ = p_fall_1_ / 10.0f;
            this.explodeCart(lvt_3_1_ * lvt_3_1_);
        }
        super.fall(p_fall_1_, p_fall_2_);
    }

    @Override
    public void onActivatorRailPass(int p_onActivatorRailPass_1_, int p_onActivatorRailPass_2_, int p_onActivatorRailPass_3_, boolean p_onActivatorRailPass_4_) {
        if (p_onActivatorRailPass_4_ && this.minecartTNTFuse < 0) {
            this.ignite();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 10) {
            this.ignite();
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    public void ignite() {
        this.minecartTNTFuse = 80;
        if (!this.world.isRemote) {
            this.world.setEntityState(this, (byte)10);
            if (!this.isSilent()) {
                this.world.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuseTicks() {
        return this.minecartTNTFuse;
    }

    public boolean isIgnited() {
        return this.minecartTNTFuse > -1;
    }

    @Override
    public float getExplosionResistance(Explosion p_getExplosionResistance_1_, World p_getExplosionResistance_2_, BlockPos p_getExplosionResistance_3_, IBlockState p_getExplosionResistance_4_) {
        if (this.isIgnited() && (BlockRailBase.isRailBlock(p_getExplosionResistance_4_) || BlockRailBase.isRailBlock(p_getExplosionResistance_2_, p_getExplosionResistance_3_.up()))) {
            return 0.0f;
        }
        return super.getExplosionResistance(p_getExplosionResistance_1_, p_getExplosionResistance_2_, p_getExplosionResistance_3_, p_getExplosionResistance_4_);
    }

    @Override
    public boolean verifyExplosion(Explosion p_verifyExplosion_1_, World p_verifyExplosion_2_, BlockPos p_verifyExplosion_3_, IBlockState p_verifyExplosion_4_, float p_verifyExplosion_5_) {
        if (this.isIgnited() && (BlockRailBase.isRailBlock(p_verifyExplosion_4_) || BlockRailBase.isRailBlock(p_verifyExplosion_2_, p_verifyExplosion_3_.up()))) {
            return false;
        }
        return super.verifyExplosion(p_verifyExplosion_1_, p_verifyExplosion_2_, p_verifyExplosion_3_, p_verifyExplosion_4_, p_verifyExplosion_5_);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("TNTFuse", 99)) {
            this.minecartTNTFuse = p_readEntityFromNBT_1_.getInteger("TNTFuse");
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("TNTFuse", this.minecartTNTFuse);
    }
}

