/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPainting
extends EntityHanging {
    public EnumArt art;

    public EntityPainting(World p_i1599_1_) {
        super(p_i1599_1_);
    }

    public EntityPainting(World p_i45849_1_, BlockPos p_i45849_2_, EnumFacing p_i45849_3_) {
        super(p_i45849_1_, p_i45849_2_);
        ArrayList lvt_4_1_ = Lists.newArrayList();
        EnumArt[] enumArtArray = EnumArt.values();
        int n = enumArtArray.length;
        for (int i = 0; i < n; ++i) {
            EnumArt lvt_8_1_;
            this.art = lvt_8_1_ = enumArtArray[i];
            this.updateFacingWithBoundingBox(p_i45849_3_);
            if (!this.onValidSurface()) continue;
            lvt_4_1_.add(lvt_8_1_);
        }
        if (!lvt_4_1_.isEmpty()) {
            this.art = (EnumArt)((Object)lvt_4_1_.get(this.rand.nextInt(lvt_4_1_.size())));
        }
        this.updateFacingWithBoundingBox(p_i45849_3_);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPainting(World p_i45850_1_, BlockPos p_i45850_2_, EnumFacing p_i45850_3_, String p_i45850_4_) {
        this(p_i45850_1_, p_i45850_2_, p_i45850_3_);
        for (EnumArt lvt_8_1_ : EnumArt.values()) {
            if (!lvt_8_1_.title.equals(p_i45850_4_)) continue;
            this.art = lvt_8_1_;
            break;
        }
        this.updateFacingWithBoundingBox(p_i45850_3_);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setString("Motive", this.art.title);
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        String lvt_2_1_ = p_readEntityFromNBT_1_.getString("Motive");
        for (EnumArt lvt_6_1_ : EnumArt.values()) {
            if (!lvt_6_1_.title.equals(lvt_2_1_)) continue;
            this.art = lvt_6_1_;
        }
        if (this.art == null) {
            this.art = EnumArt.KEBAB;
        }
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
    }

    @Override
    public int getWidthPixels() {
        return this.art.sizeX;
    }

    @Override
    public int getHeightPixels() {
        return this.art.sizeY;
    }

    @Override
    public void onBroken(Entity p_onBroken_1_) {
        if (!this.world.getGameRules().getBoolean("doEntityDrops")) {
            return;
        }
        this.playSound(SoundEvents.ENTITY_PAINTING_BREAK, 1.0f, 1.0f);
        if (p_onBroken_1_ instanceof EntityPlayer) {
            EntityPlayer lvt_2_1_ = (EntityPlayer)p_onBroken_1_;
            if (lvt_2_1_.capabilities.isCreativeMode) {
                return;
            }
        }
        this.entityDropItem(new ItemStack(Items.PAINTING), 0.0f);
    }

    @Override
    public void playPlaceSound() {
        this.playSound(SoundEvents.ENTITY_PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void setLocationAndAngles(double p_setLocationAndAngles_1_, double p_setLocationAndAngles_3_, double p_setLocationAndAngles_5_, float p_setLocationAndAngles_7_, float p_setLocationAndAngles_8_) {
        this.setPosition(p_setLocationAndAngles_1_, p_setLocationAndAngles_3_, p_setLocationAndAngles_5_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        BlockPos lvt_11_1_ = this.hangingPosition.add(p_setPositionAndRotationDirect_1_ - this.posX, p_setPositionAndRotationDirect_3_ - this.posY, p_setPositionAndRotationDirect_5_ - this.posZ);
        this.setPosition(lvt_11_1_.getX(), lvt_11_1_.getY(), lvt_11_1_.getZ());
    }

    public static enum EnumArt {
        KEBAB("Kebab", 16, 16, 0, 0),
        AZTEC("Aztec", 16, 16, 16, 0),
        ALBAN("Alban", 16, 16, 32, 0),
        AZTEC_2("Aztec2", 16, 16, 48, 0),
        BOMB("Bomb", 16, 16, 64, 0),
        PLANT("Plant", 16, 16, 80, 0),
        WASTELAND("Wasteland", 16, 16, 96, 0),
        POOL("Pool", 32, 16, 0, 32),
        COURBET("Courbet", 32, 16, 32, 32),
        SEA("Sea", 32, 16, 64, 32),
        SUNSET("Sunset", 32, 16, 96, 32),
        CREEBET("Creebet", 32, 16, 128, 32),
        WANDERER("Wanderer", 16, 32, 0, 64),
        GRAHAM("Graham", 16, 32, 16, 64),
        MATCH("Match", 32, 32, 0, 128),
        BUST("Bust", 32, 32, 32, 128),
        STAGE("Stage", 32, 32, 64, 128),
        VOID("Void", 32, 32, 96, 128),
        SKULL_AND_ROSES("SkullAndRoses", 32, 32, 128, 128),
        WITHER("Wither", 32, 32, 160, 128),
        FIGHTERS("Fighters", 64, 32, 0, 96),
        POINTER("Pointer", 64, 64, 0, 192),
        PIGSCENE("Pigscene", 64, 64, 64, 192),
        BURNING_SKULL("BurningSkull", 64, 64, 128, 192),
        SKELETON("Skeleton", 64, 48, 192, 64),
        DONKEY_KONG("DonkeyKong", 64, 48, 192, 112);

        public static final int MAX_NAME_LENGTH;
        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private EnumArt(String p_i1598_3_, int p_i1598_4_, int p_i1598_5_, int p_i1598_6_, int p_i1598_7_) {
            this.title = p_i1598_3_;
            this.sizeX = p_i1598_4_;
            this.sizeY = p_i1598_5_;
            this.offsetX = p_i1598_6_;
            this.offsetY = p_i1598_7_;
        }

        static {
            MAX_NAME_LENGTH = "SkullAndRoses".length();
        }
    }
}

