/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityTNTPrimed
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.createKey(EntityTNTPrimed.class, DataSerializers.VARINT);
    @Nullable
    private EntityLivingBase tntPlacedBy;
    private int fuse = 80;

    public EntityTNTPrimed(World p_i1729_1_) {
        super(p_i1729_1_);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
    }

    public EntityTNTPrimed(World p_i1730_1_, double p_i1730_2_, double p_i1730_4_, double p_i1730_6_, EntityLivingBase p_i1730_8_) {
        this(p_i1730_1_);
        this.setPosition(p_i1730_2_, p_i1730_4_, p_i1730_6_);
        float lvt_9_1_ = (float)(Math.random() * 6.2831854820251465);
        this.motionX = -((float)Math.sin(lvt_9_1_)) * 0.02f;
        this.motionY = 0.2f;
        this.motionZ = -((float)Math.cos(lvt_9_1_)) * 0.02f;
        this.setFuse(80);
        this.prevPosX = p_i1730_2_;
        this.prevPosY = p_i1730_4_;
        this.prevPosZ = p_i1730_6_;
        this.tntPlacedBy = p_i1730_8_;
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(FUSE, 80);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)0.04f;
        }
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.setDead();
            if (!this.world.isRemote) {
                this.explode();
            }
        } else {
            this.handleWaterMovement();
            this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        float lvt_1_1_ = 4.0f;
        this.world.createExplosion(this, this.posX, this.posY + (double)(this.height / 16.0f), this.posZ, 4.0f, true);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setShort("Fuse", (short)this.getFuse());
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.setFuse(p_readEntityFromNBT_1_.getShort("Fuse"));
    }

    @Nullable
    public EntityLivingBase getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    @Override
    public float getEyeHeight() {
        return 0.0f;
    }

    public void setFuse(int p_setFuse_1_) {
        this.dataManager.set(FUSE, p_setFuse_1_);
        this.fuse = p_setFuse_1_;
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        if (FUSE.equals(p_notifyDataManagerChange_1_)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return this.dataManager.get(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }
}

