/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityXPOrb
extends Entity {
    public int xpColor;
    public int xpOrbAge;
    public int delayBeforeCanPickup;
    private int xpOrbHealth = 5;
    public int xpValue;
    private EntityPlayer closestPlayer;
    private int xpTargetColor;

    public EntityXPOrb(World p_i1585_1_, double p_i1585_2_, double p_i1585_4_, double p_i1585_6_, int p_i1585_8_) {
        super(p_i1585_1_);
        this.setSize(0.5f, 0.5f);
        this.setPosition(p_i1585_2_, p_i1585_4_, p_i1585_6_);
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.motionY = (float)(Math.random() * 0.2) * 2.0f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.xpValue = p_i1585_8_;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    public EntityXPOrb(World p_i1586_1_) {
        super(p_i1586_1_);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        float f = 0.5f;
        f = MathHelper.clamp(f, 0.0f, 1.0f);
        int i = super.getBrightnessForRender(p_getBrightnessForRender_1_);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @Override
    public void onUpdate() {
        double d3;
        double d2;
        double d1;
        double d4;
        double d5;
        super.onUpdate();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)0.03f;
        }
        if (this.world.getBlockState(new BlockPos(this)).getMaterial() == Material.LAVA) {
            this.motionY = 0.2f;
            this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.playSound(SoundEvents.ENTITY_GENERIC_BURN, 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
        }
        this.pushOutOfBlocks(this.posX, (this.getEntityBoundingBox().minY + this.getEntityBoundingBox().maxY) / 2.0, this.posZ);
        double d0 = 8.0;
        if (this.xpTargetColor < this.xpColor - 20 + this.getEntityId() % 100) {
            if (this.closestPlayer == null || this.closestPlayer.getDistanceSqToEntity(this) > 64.0) {
                this.closestPlayer = this.world.getClosestPlayerToEntity(this, 8.0);
            }
            this.xpTargetColor = this.xpColor;
        }
        if (this.closestPlayer != null && this.closestPlayer.isSpectator()) {
            this.closestPlayer = null;
        }
        if (this.closestPlayer != null && (d5 = 1.0 - (d4 = Math.sqrt((d1 = (this.closestPlayer.posX - this.posX) / 8.0) * d1 + (d2 = (this.closestPlayer.posY + (double)this.closestPlayer.getEyeHeight() / 2.0 - this.posY) / 8.0) * d2 + (d3 = (this.closestPlayer.posZ - this.posZ) / 8.0) * d3))) > 0.0) {
            d5 *= d5;
            this.motionX += d1 / d4 * d5 * 0.1;
            this.motionY += d2 / d4 * d5 * 0.1;
            this.motionZ += d3 / d4 * d5 * 0.1;
        }
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        float f = 0.98f;
        if (this.onGround) {
            f = this.world.getBlockState((BlockPos)new BlockPos((int)MathHelper.floor((double)this.posX), (int)(MathHelper.floor((double)this.getEntityBoundingBox().minY) - 1), (int)MathHelper.floor((double)this.posZ))).getBlock().slipperiness * 0.98f;
        }
        this.motionX *= (double)f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)f;
        if (this.onGround) {
            this.motionY *= (double)-0.9f;
        }
        ++this.xpColor;
        ++this.xpOrbAge;
        if (this.xpOrbAge >= 6000) {
            this.setDead();
        }
    }

    @Override
    public boolean handleWaterMovement() {
        return this.world.handleMaterialAcceleration(this.getEntityBoundingBox(), Material.WATER, this);
    }

    @Override
    protected void dealFireDamage(int p_dealFireDamage_1_) {
        this.attackEntityFrom(DamageSource.IN_FIRE, p_dealFireDamage_1_);
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        this.setBeenAttacked();
        this.xpOrbHealth = (int)((float)this.xpOrbHealth - p_attackEntityFrom_2_);
        if (this.xpOrbHealth <= 0) {
            this.setDead();
        }
        return false;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setShort("Health", (short)this.xpOrbHealth);
        p_writeEntityToNBT_1_.setShort("Age", (short)this.xpOrbAge);
        p_writeEntityToNBT_1_.setShort("Value", (short)this.xpValue);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.xpOrbHealth = p_readEntityFromNBT_1_.getShort("Health");
        this.xpOrbAge = p_readEntityFromNBT_1_.getShort("Age");
        this.xpValue = p_readEntityFromNBT_1_.getShort("Value");
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer p_onCollideWithPlayer_1_) {
        if (!this.world.isRemote && this.delayBeforeCanPickup == 0 && p_onCollideWithPlayer_1_.xpCooldown == 0) {
            if (MinecraftForge.EVENT_BUS.post(new PlayerPickupXpEvent(p_onCollideWithPlayer_1_, this))) {
                return;
            }
            p_onCollideWithPlayer_1_.xpCooldown = 2;
            p_onCollideWithPlayer_1_.onItemPickup(this, 1);
            ItemStack itemstack = EnchantmentHelper.getEnchantedItem(Enchantments.MENDING, p_onCollideWithPlayer_1_);
            if (!itemstack.isEmpty() && itemstack.isItemDamaged()) {
                int i = Math.min(this.xpToDurability(this.xpValue), itemstack.getItemDamage());
                this.xpValue -= this.durabilityToXp(i);
                itemstack.setItemDamage(itemstack.getItemDamage() - i);
            }
            if (this.xpValue > 0) {
                p_onCollideWithPlayer_1_.addExperience(this.xpValue);
            }
            this.setDead();
        }
    }

    private int durabilityToXp(int p_durabilityToXp_1_) {
        return p_durabilityToXp_1_ / 2;
    }

    private int xpToDurability(int p_xpToDurability_1_) {
        return p_xpToDurability_1_ * 2;
    }

    public int getXpValue() {
        return this.xpValue;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureByXP() {
        return this.xpValue >= 2477 ? 10 : (this.xpValue >= 1237 ? 9 : (this.xpValue >= 617 ? 8 : (this.xpValue >= 307 ? 7 : (this.xpValue >= 149 ? 6 : (this.xpValue >= 73 ? 5 : (this.xpValue >= 37 ? 4 : (this.xpValue >= 17 ? 3 : (this.xpValue >= 7 ? 2 : (this.xpValue >= 3 ? 1 : 0)))))))));
    }

    public static int getXPSplit(int p_getXPSplit_0_) {
        return p_getXPSplit_0_ >= 2477 ? 2477 : (p_getXPSplit_0_ >= 1237 ? 1237 : (p_getXPSplit_0_ >= 617 ? 617 : (p_getXPSplit_0_ >= 307 ? 307 : (p_getXPSplit_0_ >= 149 ? 149 : (p_getXPSplit_0_ >= 73 ? 73 : (p_getXPSplit_0_ >= 37 ? 37 : (p_getXPSplit_0_ >= 17 ? 17 : (p_getXPSplit_0_ >= 7 ? 7 : (p_getXPSplit_0_ >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }
}

