/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Calendar;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractSkeleton
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.createKey(AbstractSkeleton.class, DataSerializers.BOOLEAN);
    private final EntityAIAttackRangedBow aiArrowAttack = new EntityAIAttackRangedBow(this, 1.0, 20, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee(this, 1.2, false){

        @Override
        public void resetTask() {
            super.resetTask();
            AbstractSkeleton.this.setSwingingArms(false);
        }

        @Override
        public void startExecuting() {
            super.startExecuting();
            AbstractSkeleton.this.setSwingingArms(true);
        }
    };

    public AbstractSkeleton(World p_i47289_1_) {
        super(p_i47289_1_);
        this.setSize(0.6f, 1.99f);
        this.setCombatTask();
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, new EntityAIRestrictSun(this));
        this.tasks.addTask(3, new EntityAIFleeSun(this, 1.0));
        this.tasks.addTask(3, new EntityAIAvoidEntity<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.tasks.addTask(5, new EntityAIWanderAvoidWater(this, 1.0));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
        this.targetTasks.addTask(3, new EntityAINearestAttackableTarget<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, true));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(SWINGING_ARMS, false);
    }

    @Override
    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    abstract SoundEvent getStepSound();

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public void onLivingUpdate() {
        if (this.world.isDaytime() && !this.world.isRemote) {
            BlockPos lvt_2_1_;
            float lvt_1_1_ = this.getBrightness(1.0f);
            BlockPos blockPos = lvt_2_1_ = this.getRidingEntity() instanceof EntityBoat ? new BlockPos(this.posX, Math.round(this.posY), this.posZ).up() : new BlockPos(this.posX, Math.round(this.posY), this.posZ);
            if (lvt_1_1_ > 0.5f && this.rand.nextFloat() * 30.0f < (lvt_1_1_ - 0.4f) * 2.0f && this.world.canSeeSky(lvt_2_1_)) {
                boolean lvt_3_1_ = true;
                ItemStack lvt_4_1_ = this.getItemStackFromSlot(EntityEquipmentSlot.HEAD);
                if (!lvt_4_1_.isEmpty()) {
                    if (lvt_4_1_.isItemStackDamageable()) {
                        lvt_4_1_.setItemDamage(lvt_4_1_.getItemDamage() + this.rand.nextInt(2));
                        if (lvt_4_1_.getItemDamage() >= lvt_4_1_.getMaxDamage()) {
                            this.renderBrokenItemStack(lvt_4_1_);
                            this.setItemStackToSlot(EntityEquipmentSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    lvt_3_1_ = false;
                }
                if (lvt_3_1_) {
                    this.setFire(8);
                }
            }
        }
        super.onLivingUpdate();
    }

    @Override
    public void updateRidden() {
        super.updateRidden();
        if (this.getRidingEntity() instanceof EntityCreature) {
            EntityCreature lvt_1_1_ = (EntityCreature)this.getRidingEntity();
            this.renderYawOffset = lvt_1_1_.renderYawOffset;
        }
    }

    @Override
    public void onDeath(DamageSource p_onDeath_1_) {
        super.onDeath(p_onDeath_1_);
        if (p_onDeath_1_.getSourceOfDamage() instanceof EntityArrow && p_onDeath_1_.getEntity() instanceof EntityPlayer) {
            EntityPlayer lvt_2_1_ = (EntityPlayer)p_onDeath_1_.getEntity();
            double lvt_3_1_ = lvt_2_1_.posX - this.posX;
            double lvt_5_1_ = lvt_2_1_.posZ - this.posZ;
            if (lvt_3_1_ * lvt_3_1_ + lvt_5_1_ * lvt_5_1_ >= 2500.0) {
                lvt_2_1_.addStat(AchievementList.SNIPE_SKELETON);
            }
        }
    }

    @Override
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance p_setEquipmentBasedOnDifficulty_1_) {
        super.setEquipmentBasedOnDifficulty(p_setEquipmentBasedOnDifficulty_1_);
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.BOW));
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        Calendar lvt_3_1_;
        p_onInitialSpawn_2_ = super.onInitialSpawn(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
        this.setEquipmentBasedOnDifficulty(p_onInitialSpawn_1_);
        this.setEnchantmentBasedOnDifficulty(p_onInitialSpawn_1_);
        this.setCombatTask();
        this.setCanPickUpLoot(this.rand.nextFloat() < 0.55f * p_onInitialSpawn_1_.getClampedAdditionalDifficulty());
        if (this.getItemStackFromSlot(EntityEquipmentSlot.HEAD).isEmpty() && (lvt_3_1_ = this.world.getCurrentDate()).get(2) + 1 == 10 && lvt_3_1_.get(5) == 31 && this.rand.nextFloat() < 0.25f) {
            this.setItemStackToSlot(EntityEquipmentSlot.HEAD, new ItemStack(this.rand.nextFloat() < 0.1f ? Blocks.LIT_PUMPKIN : Blocks.PUMPKIN));
            this.inventoryArmorDropChances[EntityEquipmentSlot.HEAD.getIndex()] = 0.0f;
        }
        return p_onInitialSpawn_2_;
    }

    public void setCombatTask() {
        if (this.world == null || this.world.isRemote) {
            return;
        }
        this.tasks.removeTask(this.aiAttackOnCollide);
        this.tasks.removeTask(this.aiArrowAttack);
        ItemStack lvt_1_1_ = this.getHeldItemMainhand();
        if (lvt_1_1_.getItem() == Items.BOW) {
            int lvt_2_1_ = 20;
            if (this.world.getDifficulty() != EnumDifficulty.HARD) {
                lvt_2_1_ = 40;
            }
            this.aiArrowAttack.setAttackCooldown(lvt_2_1_);
            this.tasks.addTask(4, this.aiArrowAttack);
        } else {
            this.tasks.addTask(4, this.aiAttackOnCollide);
        }
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase p_attackEntityWithRangedAttack_1_, float p_attackEntityWithRangedAttack_2_) {
        EntityArrow lvt_3_1_ = this.getArrow(p_attackEntityWithRangedAttack_2_);
        double lvt_4_1_ = p_attackEntityWithRangedAttack_1_.posX - this.posX;
        double lvt_6_1_ = p_attackEntityWithRangedAttack_1_.getEntityBoundingBox().minY + (double)(p_attackEntityWithRangedAttack_1_.height / 3.0f) - lvt_3_1_.posY;
        double lvt_8_1_ = p_attackEntityWithRangedAttack_1_.posZ - this.posZ;
        double lvt_10_1_ = MathHelper.sqrt(lvt_4_1_ * lvt_4_1_ + lvt_8_1_ * lvt_8_1_);
        lvt_3_1_.setThrowableHeading(lvt_4_1_, lvt_6_1_ + lvt_10_1_ * (double)0.2f, lvt_8_1_, 1.6f, 14 - this.world.getDifficulty().getDifficultyId() * 4);
        this.playSound(SoundEvents.ENTITY_SKELETON_SHOOT, 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.world.spawnEntity(lvt_3_1_);
    }

    protected EntityArrow getArrow(float p_getArrow_1_) {
        EntityTippedArrow lvt_2_1_ = new EntityTippedArrow(this.world, this);
        lvt_2_1_.setEnchantmentEffectsFromEntity(this, p_getArrow_1_);
        return lvt_2_1_;
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setCombatTask();
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot p_setItemStackToSlot_1_, ItemStack p_setItemStackToSlot_2_) {
        super.setItemStackToSlot(p_setItemStackToSlot_1_, p_setItemStackToSlot_2_);
        if (!this.world.isRemote && p_setItemStackToSlot_1_ == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    @Override
    public float getEyeHeight() {
        return 1.74f;
    }

    @Override
    public double getYOffset() {
        return -0.6;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return this.dataManager.get(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean p_setSwingingArms_1_) {
        this.dataManager.set(SWINGING_ARMS, p_setSwingingArms_1_);
    }
}

