/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlaze
extends EntityMob {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.createKey(EntityBlaze.class, DataSerializers.BYTE);

    public EntityBlaze(World p_i1731_1_) {
        super(p_i1731_1_);
        this.setPathPriority(PathNodeType.WATER, -1.0f);
        this.setPathPriority(PathNodeType.LAVA, 8.0f);
        this.setPathPriority(PathNodeType.DANGER_FIRE, 0.0f);
        this.setPathPriority(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.isImmuneToFire = true;
        this.experienceValue = 10;
    }

    public static void registerFixesBlaze(DataFixer p_registerFixesBlaze_0_) {
        EntityLiving.registerFixesMob(p_registerFixesBlaze_0_, EntityBlaze.class);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(4, new AIFireballAttack(this));
        this.tasks.addTask(5, new EntityAIMoveTowardsRestriction(this, 1.0));
        this.tasks.addTask(7, new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.tasks.addTask(8, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(6.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(48.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(ON_FIRE, (byte)0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_BLAZE_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_BLAZE_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_BLAZE_DEATH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }

    @Override
    public float getBrightness(float p_getBrightness_1_) {
        return 1.0f;
    }

    @Override
    public void onLivingUpdate() {
        if (!this.onGround && this.motionY < 0.0) {
            this.motionY *= 0.6;
        }
        if (this.world.isRemote) {
            if (this.rand.nextInt(24) == 0 && !this.isSilent()) {
                this.world.playSound(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5, SoundEvents.ENTITY_BLAZE_BURN, this.getSoundCategory(), 1.0f + this.rand.nextFloat(), this.rand.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int lvt_1_1_ = 0; lvt_1_1_ < 2; ++lvt_1_1_) {
                this.world.spawnParticle(EnumParticleTypes.SMOKE_LARGE, this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.onLivingUpdate();
    }

    @Override
    protected void updateAITasks() {
        EntityLivingBase lvt_1_1_;
        if (this.isWet()) {
            this.attackEntityFrom(DamageSource.DROWN, 1.0f);
        }
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.rand.nextGaussian() * 3.0f;
        }
        if ((lvt_1_1_ = this.getAttackTarget()) != null && lvt_1_1_.posY + (double)lvt_1_1_.getEyeHeight() > this.posY + (double)this.getEyeHeight() + (double)this.heightOffset) {
            this.motionY += ((double)0.3f - this.motionY) * (double)0.3f;
            this.isAirBorne = true;
        }
        super.updateAITasks();
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
    }

    @Override
    public boolean isBurning() {
        return this.isCharged();
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_BLAZE;
    }

    public boolean isCharged() {
        return (this.dataManager.get(ON_FIRE) & 1) != 0;
    }

    public void setOnFire(boolean p_setOnFire_1_) {
        byte lvt_2_1_ = this.dataManager.get(ON_FIRE);
        lvt_2_1_ = p_setOnFire_1_ ? (byte)(lvt_2_1_ | 1) : (byte)(lvt_2_1_ & 0xFFFFFFFE);
        this.dataManager.set(ON_FIRE, lvt_2_1_);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private final EntityBlaze blaze;
        private int attackStep;
        private int attackTime;

        public AIFireballAttack(EntityBlaze p_i45846_1_) {
            this.blaze = p_i45846_1_;
            this.setMutexBits(3);
        }

        @Override
        public boolean shouldExecute() {
            EntityLivingBase lvt_1_1_ = this.blaze.getAttackTarget();
            return lvt_1_1_ != null && lvt_1_1_.isEntityAlive();
        }

        @Override
        public void startExecuting() {
            this.attackStep = 0;
        }

        @Override
        public void resetTask() {
            this.blaze.setOnFire(false);
        }

        @Override
        public void updateTask() {
            --this.attackTime;
            EntityLivingBase lvt_1_1_ = this.blaze.getAttackTarget();
            double lvt_2_1_ = this.blaze.getDistanceSqToEntity(lvt_1_1_);
            if (lvt_2_1_ < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blaze.attackEntityAsMob(lvt_1_1_);
                }
                this.blaze.getMoveHelper().setMoveTo(lvt_1_1_.posX, lvt_1_1_.posY, lvt_1_1_.posZ, 1.0);
            } else if (lvt_2_1_ < this.func_191523_f() * this.func_191523_f()) {
                double lvt_4_1_ = lvt_1_1_.posX - this.blaze.posX;
                double lvt_6_1_ = lvt_1_1_.getEntityBoundingBox().minY + (double)(lvt_1_1_.height / 2.0f) - (this.blaze.posY + (double)(this.blaze.height / 2.0f));
                double lvt_8_1_ = lvt_1_1_.posZ - this.blaze.posZ;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                        this.blaze.setOnFire(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                        this.blaze.setOnFire(false);
                    }
                    if (this.attackStep > 1) {
                        float lvt_10_1_ = MathHelper.sqrt(MathHelper.sqrt(lvt_2_1_)) * 0.5f;
                        this.blaze.world.playEvent(null, 1018, new BlockPos((int)this.blaze.posX, (int)this.blaze.posY, (int)this.blaze.posZ), 0);
                        for (int lvt_11_1_ = 0; lvt_11_1_ < 1; ++lvt_11_1_) {
                            EntitySmallFireball lvt_12_1_ = new EntitySmallFireball(this.blaze.world, this.blaze, lvt_4_1_ + this.blaze.getRNG().nextGaussian() * (double)lvt_10_1_, lvt_6_1_, lvt_8_1_ + this.blaze.getRNG().nextGaussian() * (double)lvt_10_1_);
                            lvt_12_1_.posY = this.blaze.posY + (double)(this.blaze.height / 2.0f) + 0.5;
                            this.blaze.world.spawnEntity(lvt_12_1_);
                        }
                    }
                }
                this.blaze.getLookHelper().setLookPositionWithEntity(lvt_1_1_, 10.0f, 10.0f);
            } else {
                this.blaze.getNavigator().clearPathEntity();
                this.blaze.getMoveHelper().setMoveTo(lvt_1_1_.posX, lvt_1_1_.posY, lvt_1_1_.posZ, 1.0);
            }
            super.updateTask();
        }

        private double func_191523_f() {
            IAttributeInstance lvt_1_1_ = this.blaze.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
            return lvt_1_1_ == null ? 16.0 : lvt_1_1_.getAttributeValue();
        }
    }
}

