/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityCaveSpider
extends EntitySpider {
    public EntityCaveSpider(World p_i1732_1_) {
        super(p_i1732_1_);
        this.setSize(0.7f, 0.5f);
    }

    public static void registerFixesCaveSpider(DataFixer p_registerFixesCaveSpider_0_) {
        EntityLiving.registerFixesMob(p_registerFixesCaveSpider_0_, EntityCaveSpider.class);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(12.0);
    }

    @Override
    public boolean attackEntityAsMob(Entity p_attackEntityAsMob_1_) {
        if (super.attackEntityAsMob(p_attackEntityAsMob_1_)) {
            if (p_attackEntityAsMob_1_ instanceof EntityLivingBase) {
                int lvt_2_1_ = 0;
                if (this.world.getDifficulty() == EnumDifficulty.NORMAL) {
                    lvt_2_1_ = 7;
                } else if (this.world.getDifficulty() == EnumDifficulty.HARD) {
                    lvt_2_1_ = 15;
                }
                if (lvt_2_1_ > 0) {
                    ((EntityLivingBase)p_attackEntityAsMob_1_).addPotionEffect(new PotionEffect(MobEffects.POISON, lvt_2_1_ * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        return p_onInitialSpawn_2_;
    }

    @Override
    public float getEyeHeight() {
        return 0.45f;
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.ENTITIES_CAVE_SPIDER;
    }
}

